/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.medicalcondition;

import com.gregtechceu.gtceu.api.data.damagesource.DamageTypeData;
import com.gregtechceu.gtceu.api.data.medicalcondition.Symptom;
import com.gregtechceu.gtceu.common.capability.MedicalConditionTracker;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class MedicalCondition {
    public static final Map<String, MedicalCondition> CONDITIONS = new HashMap<String, MedicalCondition>();
    public static final Codec<MedicalCondition> CODEC = Codec.STRING.xmap(CONDITIONS::get, MedicalCondition::getName);
    public final String name;
    public final int color;
    public final float maxProgression;
    public final Set<Symptom.ConfiguredSymptom> symptoms = new HashSet<Symptom.ConfiguredSymptom>();
    private final DamageTypeData damageTypeData;
    public final IdleProgressionType idleProgressionType;
    public final float idleProgressionRate;
    public final boolean canBePermanent;
    @NotNull
    public Consumer<GTRecipeBuilder> recipeModifier = builder -> {};

    public MedicalCondition(String name, int color, int maxProgression, IdleProgressionType idleProgressionType, float idleProgressionRate, boolean canBePermanent, Symptom.ConfiguredSymptom ... symptoms) {
        this.name = name;
        this.color = color;
        this.maxProgression = maxProgression;
        this.damageTypeData = new DamageTypeData.Builder().simpleId("medical_condition/" + name).scaling(DamageScaling.NEVER).tag(DamageTypeTags.f_268490_).build();
        this.symptoms.addAll(Arrays.asList(symptoms));
        this.idleProgressionType = idleProgressionType;
        this.idleProgressionRate = idleProgressionRate;
        this.canBePermanent = canBePermanent;
        CONDITIONS.put(name, this);
    }

    public MedicalCondition(String name, int color, int maxProgression, IdleProgressionType progressionType, boolean canBePermanent, Symptom.ConfiguredSymptom ... symptoms) {
        this(name, color, maxProgression, progressionType, 1.0f, canBePermanent, symptoms);
    }

    public MedicalCondition(String name, int color, int maxProgression, Symptom.ConfiguredSymptom ... symptoms) {
        this(name, color, maxProgression, IdleProgressionType.NONE, 0.0f, false, symptoms);
    }

    public DamageSource getDamageSource(MedicalConditionTracker tracker) {
        return this.damageTypeData.source((LevelAccessor)tracker.getPlayer().m_9236_());
    }

    public DamageSource getDamageSource(Level level) {
        return this.damageTypeData.source((LevelAccessor)level);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public Consumer<GTRecipeBuilder> getRecipeModifier() {
        return this.recipeModifier;
    }

    @NotNull
    @Generated
    public MedicalCondition setRecipeModifier(@NotNull Consumer<GTRecipeBuilder> recipeModifier) {
        if (recipeModifier == null) {
            throw new NullPointerException("recipeModifier is marked non-null but is null");
        }
        this.recipeModifier = recipeModifier;
        return this;
    }

    public static enum IdleProgressionType {
        UNTREATED_PROGRESSION,
        HEAL,
        NONE;

    }
}

