/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.WeightedMaterial;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.utils.RegistryUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class BedrockOreDefinition {
    public static final Codec<BedrockOreDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)Codec.INT.fieldOf("size").forGetter(ft -> ft.size), (App)IntProvider.f_146533_.fieldOf("yield").forGetter(ft -> ft.yield), (App)Codec.INT.fieldOf("depletion_amount").forGetter(ft -> ft.depletionAmount), (App)ExtraCodecs.m_269197_((int)0, (int)100).fieldOf("depletion_chance").forGetter(ft -> ft.depletionChance), (App)Codec.INT.fieldOf("depleted_yield").forGetter(ft -> ft.depletedYield), (App)WeightedMaterial.CODEC.listOf().fieldOf("materials").forGetter(ft -> ft.materials), (App)BiomeWeightModifier.CODEC.listOf().optionalFieldOf("weight_modifier", List.of()).forGetter(ft -> ft.originalModifiers), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<ResourceKey<Level>>(ft.dimensionFilter))).apply((Applicative)instance, (weight, size, yield, depletionAmount, depletionChance, depletedYield, materials, biomeWeightModifier, dimensionFilter) -> new BedrockOreDefinition((int)weight, (int)size, (IntProvider)yield, (int)depletionAmount, (int)depletionChance, (int)depletedYield, (List<WeightedMaterial>)materials, (List<BiomeWeightModifier>)biomeWeightModifier, (Set<ResourceKey<Level>>)new HashSet<ResourceKey<Level>>((Collection<ResourceKey<Level>>)dimensionFilter))));
    private int weight;
    private int size;
    private IntProvider yield;
    private int depletionAmount;
    private int depletionChance;
    private int depletedYield;
    private List<WeightedMaterial> materials;
    private BiomeWeightModifier biomeWeightModifier;
    private List<BiomeWeightModifier> originalModifiers;
    public Set<ResourceKey<Level>> dimensionFilter;

    public BedrockOreDefinition(ResourceLocation name, int size, int weight, IntProvider yield, int depletionAmount, int depletionChance, int depletedYield, List<WeightedMaterial> materials, List<BiomeWeightModifier> originalModifiers, Set<ResourceKey<Level>> dimensionFilter) {
        this(weight, size, yield, depletionAmount, depletionChance, depletedYield, materials, originalModifiers, dimensionFilter);
        GTRegistries.BEDROCK_ORE_DEFINITIONS.register(name, this);
    }

    public BedrockOreDefinition(int weight, int size, IntProvider yield, int depletionAmount, int depletionChance, int depletedYield, List<WeightedMaterial> materials, final List<BiomeWeightModifier> originalModifiers, Set<ResourceKey<Level>> dimensionFilter) {
        this.weight = weight;
        this.size = size;
        this.yield = yield;
        this.depletionAmount = depletionAmount;
        this.depletionChance = depletionChance;
        this.depletedYield = depletedYield;
        this.materials = materials;
        this.originalModifiers = originalModifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> HolderSet.m_205800_(originalModifiers.stream().flatMap(mod -> mod.biomes.get().m_203614_()).toList()), originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public int applyAsInt(Holder<Biome> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : originalModifiers) {
                    if (!modifier.biomes.get().m_203333_(biome)) continue;
                    mod += modifier.applyAsInt(biome);
                }
                return mod;
            }
        };
        this.dimensionFilter = dimensionFilter;
    }

    public void setOriginalModifiers(List<BiomeWeightModifier> modifiers) {
        this.originalModifiers = modifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> HolderSet.m_205800_(this.originalModifiers.stream().flatMap(mod -> mod.biomes.get().m_203614_()).toList()), this.originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public int applyAsInt(Holder<Biome> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : BedrockOreDefinition.this.originalModifiers) {
                    if (!modifier.biomes.get().m_203333_(biome)) continue;
                    mod += modifier.applyAsInt(biome);
                }
                return mod;
            }
        };
    }

    public IntList getAllChances() {
        return IntArrayList.toList((IntStream)this.materials().stream().mapToInt(WeightedMaterial::weight));
    }

    public List<Material> getAllMaterials() {
        return this.materials().stream().map(WeightedMaterial::material).toList();
    }

    public static Builder builder(ResourceLocation name) {
        return new Builder(name);
    }

    @Generated
    public int weight() {
        return this.weight;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition weight(int weight) {
        this.weight = weight;
        return this;
    }

    @Generated
    public int size() {
        return this.size;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition size(int size) {
        this.size = size;
        return this;
    }

    @Generated
    public IntProvider yield() {
        return this.yield;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition yield(IntProvider yield) {
        this.yield = yield;
        return this;
    }

    @Generated
    public int depletionAmount() {
        return this.depletionAmount;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition depletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
        return this;
    }

    @Generated
    public int depletionChance() {
        return this.depletionChance;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition depletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
        return this;
    }

    @Generated
    public int depletedYield() {
        return this.depletedYield;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition depletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
        return this;
    }

    @Generated
    public List<WeightedMaterial> materials() {
        return this.materials;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition materials(List<WeightedMaterial> materials) {
        this.materials = materials;
        return this;
    }

    @Generated
    public BiomeWeightModifier biomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    @Generated
    public Set<ResourceKey<Level>> dimensionFilter() {
        return this.dimensionFilter;
    }

    @NotNull
    @Generated
    public BedrockOreDefinition dimensionFilter(Set<ResourceKey<Level>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }

    public static class Builder {
        private final ResourceLocation name;
        private int weight;
        private int size;
        private IntProvider yield;
        private int depletionAmount;
        private int depletionChance = 1;
        private int depletedYield;
        private List<WeightedMaterial> materials;
        private Set<ResourceKey<Level>> dimensions;
        private final List<BiomeWeightModifier> biomes = new LinkedList<BiomeWeightModifier>();

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder copy(ResourceLocation name) {
            Builder copied = new Builder(name);
            copied.weight = this.weight;
            copied.yield = this.yield;
            copied.depletionAmount = this.depletionAmount;
            copied.depletionChance = this.depletionChance;
            copied.depletedYield = this.depletedYield;
            copied.materials = this.materials;
            return copied;
        }

        public Builder material(Material material, int amount) {
            if (this.materials == null) {
                this.materials = new ArrayList<WeightedMaterial>();
            }
            this.materials.add(new WeightedMaterial(material, amount));
            return this;
        }

        public Builder yield(int min, int max) {
            return this.yield((IntProvider)UniformInt.m_146622_((int)min, (int)max));
        }

        public Builder biomes(int weight, TagKey<Biome> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> GTRegistries.builtinRegistry().m_175515_(Registries.f_256952_).m_203561_(biomes), weight));
            return this;
        }

        @SafeVarargs
        public final Builder biomes(int weight, ResourceKey<Biome> ... biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> HolderSet.m_205806_(arg_0 -> ((Registry)GTRegistries.builtinRegistry().m_175515_(Registries.f_256952_)).m_246971_(arg_0), (Object[])biomes), weight));
            return this;
        }

        public Builder biomes(int weight, HolderSet<Biome> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> biomes, weight));
            return this;
        }

        @HideFromJS
        public Builder dimensions(Set<ResourceKey<Level>> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder dimensions(String ... dimensions) {
            return this.dimensions(new HashSet<ResourceKey<Level>>(RegistryUtil.resolveResourceKeys(Registries.f_256858_, dimensions)));
        }

        public BedrockOreDefinition register() {
            BedrockOreDefinition definition = new BedrockOreDefinition(this.weight, this.size, this.yield, this.depletionAmount, this.depletionChance, this.depletedYield, this.materials, this.biomes, this.dimensions);
            GTRegistries.BEDROCK_ORE_DEFINITIONS.registerOrOverride(this.name, definition);
            return definition;
        }

        @NotNull
        @Generated
        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @NotNull
        @Generated
        public Builder size(int size) {
            this.size = size;
            return this;
        }

        @NotNull
        @Generated
        public Builder yield(IntProvider yield) {
            this.yield = yield;
            return this;
        }

        @NotNull
        @Generated
        public Builder depletionAmount(int depletionAmount) {
            this.depletionAmount = depletionAmount;
            return this;
        }

        @NotNull
        @Generated
        public Builder depletionChance(int depletionChance) {
            this.depletionChance = depletionChance;
            return this;
        }

        @NotNull
        @Generated
        public Builder depletedYield(int depletedYield) {
            this.depletedYield = depletedYield;
            return this;
        }

        @NotNull
        @Generated
        public Builder materials(List<WeightedMaterial> materials) {
            this.materials = materials;
            return this;
        }
    }
}

