/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TitleBarWidget
extends WidgetGroup {
    private static final int BORDER_WIDTH = 3;
    private static final int HORIZONTAL_MARGIN = 8;
    private static final int HEIGHT = 16;
    private static final int BTN_WIDTH = 18;
    private static final float ROLL_SPEED = 0.7f;
    private int width;
    private boolean showBackButton = false;
    private boolean showMenuButton = false;
    private final int innerHeight;
    private final WidgetGroup buttonGroup;
    private final Widget backButton;
    private final Widget menuButton;
    private final WidgetGroup mainSection;
    private final ImageWidget tabIcon;
    private final ImageWidget tabTitle;
    private TextTexture titleText;

    public TitleBarWidget(int parentWidth, Consumer<ClickData> onBackClicked, Consumer<ClickData> onMenuClicked) {
        super(8, -16, parentWidth, 16);
        this.innerHeight = 13;
        this.width = parentWidth - 16;
        this.buttonGroup = new WidgetGroup(0, 3, this.width, this.innerHeight);
        this.addWidget((Widget)this.buttonGroup);
        this.buttonGroup.setBackground(new IGuiTexture[]{GuiTextures.TITLE_BAR_BACKGROUND});
        this.backButton = new ButtonWidget(0, 3, 18, 13, (IGuiTexture)new TextTexture(" <").setDropShadow(false).setColor(ChatFormatting.BLACK.m_126665_().intValue()), onBackClicked).setHoverTooltips(new String[]{"gtceu.gui.title_bar.back"});
        this.buttonGroup.addWidget(this.backButton);
        this.menuButton = new ButtonWidget(this.width - 18, 3, 18, 13, (IGuiTexture)new TextTexture("+").setDropShadow(false).setColor(ChatFormatting.BLACK.m_126665_().intValue()), onMenuClicked).setHoverTooltips(new String[]{"gtceu.gui.title_bar.page_switcher"});
        this.buttonGroup.addWidget(this.menuButton);
        this.mainSection = new WidgetGroup(18, 0, this.width, 16);
        this.addWidget((Widget)this.mainSection);
        this.mainSection.setBackground(new IGuiTexture[]{GuiTextures.TITLE_BAR_BACKGROUND});
        this.tabIcon = new ImageWidget(4, 4, this.innerHeight - 2, this.innerHeight - 2, IGuiTexture.EMPTY);
        this.mainSection.addWidget((Widget)this.tabIcon);
        this.tabTitle = new ImageWidget(3 + this.innerHeight, 3, 0, 0, IGuiTexture.EMPTY);
        this.mainSection.addWidget((Widget)this.tabTitle);
    }

    public void updateState(IFancyUIProvider currentPage, boolean showBackButton, boolean showMenuButton) {
        this.showBackButton = showBackButton;
        this.showMenuButton = showMenuButton;
        this.titleText = new TextTexture(ChatFormatting.BLACK.toString() + currentPage.getTitle().m_6881_().getString()).setDropShadow(false).setType(TextTexture.TextType.ROLL);
        this.titleText.setRollSpeed(0.7f);
        this.tabIcon.setImage(currentPage.getTabIcon());
        this.tabTitle.setImage((IGuiTexture)this.titleText);
        this.backButton.setVisible(showBackButton);
        this.backButton.setActive(showBackButton);
        this.menuButton.setVisible(showMenuButton);
        this.menuButton.setActive(showMenuButton);
        this.onSizeUpdate();
    }

    protected void onSizeUpdate() {
        this.width = this.getSize().getWidth() - 16;
        int hiddenButtons = 2;
        if (this.showBackButton) {
            --hiddenButtons;
        }
        if (this.showMenuButton) {
            --hiddenButtons;
        }
        int buttonGroupWidth = this.width - 18 * hiddenButtons;
        this.buttonGroup.setSize(new Size(buttonGroupWidth, this.innerHeight));
        this.buttonGroup.setSelfPosition(new Position(this.showBackButton ? 0 : 18, 3));
        this.menuButton.setSelfPosition(new Position(buttonGroupWidth - 18, 3));
        int mainSectionWidth = this.width - 36;
        int titleWidth = mainSectionWidth - 6 - this.innerHeight;
        this.mainSection.setSize(new Size(mainSectionWidth, 16));
        this.titleText.setWidth(titleWidth);
        this.tabTitle.setSize(new Size(titleWidth, 13));
    }
}

