/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget.directional;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.widget.directional.IDirectionalConfigHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CombinedDirectionalConfigurator
extends WidgetGroup {
    protected static final int MOUSE_CLICK_CLIENT_ACTION_ID = 65537;
    protected static final int UPDATE_UI_ID = 65538;
    protected final IDirectionalConfigHandler[] configHandlers;
    protected final int width;
    protected final int height;
    private final FancyMachineUIWidget machineUI;
    private final MetaMachine machine;
    protected SceneWidget sceneWidget;
    protected ImageWidget imageWidget;
    @Nullable
    protected BlockPos selectedPos;
    @Nullable
    protected Direction selectedSide;

    public CombinedDirectionalConfigurator(FancyMachineUIWidget machineUI, IDirectionalConfigHandler[] configHandlers, MetaMachine machine, int width, int height) {
        super(0, 0, width, height);
        this.width = width;
        this.height = height;
        this.machineUI = machineUI;
        this.configHandlers = configHandlers;
        this.machine = machine;
    }

    public void initWidget() {
        super.initWidget();
        this.imageWidget = new ImageWidget(0, 0, this.width, this.height, (IGuiTexture)GuiTextures.BACKGROUND_INVERSE);
        this.addWidget((Widget)this.imageWidget);
        this.sceneWidget = this.createSceneWidget();
        this.addWidget((Widget)this.sceneWidget);
        for (IDirectionalConfigHandler configHandler : this.configHandlers) {
            configHandler.addAdditionalUIElements(this);
        }
        this.addConfigWidgets(this.sceneWidget);
    }

    private SceneWidget createSceneWidget() {
        BlockPos pos = this.machine.getPos();
        SceneWidget sceneWidget = new SceneWidget(4, 4, this.width - 8, this.height - 8, this.machine.getLevel()).setRenderedCore(List.of(pos), null).setRenderSelect(false).setOnSelected(this::onSideSelected);
        if (this.isRemote()) {
            sceneWidget.getRenderer().addRenderedBlocks(List.of(pos.m_7494_(), pos.m_7495_(), pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_()), new ISceneBlockRenderHook(){

                @OnlyIn(value=Dist.CLIENT)
                public void apply(boolean isTESR, RenderType layer) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                }
            });
            sceneWidget.getRenderer().setAfterWorldRender(this::renderOverlays);
            Vec2 playerRotation = this.gui.entityPlayer.m_20155_();
            sceneWidget.setCameraYawAndPitch(playerRotation.f_82470_, playerRotation.f_82471_ - 90.0f);
        }
        sceneWidget.setBackground(new IGuiTexture[]{ColorPattern.BLACK.rectTexture()});
        return sceneWidget;
    }

    private void renderOverlays(WorldSceneRenderer renderer) {
        this.sceneWidget.renderBlockOverLay(renderer);
        for (Direction face : GTUtil.DIRECTIONS) {
            for (IDirectionalConfigHandler configHandler : this.configHandlers) {
                configHandler.renderOverlay(this.sceneWidget, new BlockPosFace(this.machine.getPos(), face));
            }
        }
    }

    private void addConfigWidgets(SceneWidget sceneWidget) {
        int yOffsetLeft = 0;
        int yOffsetRight = 0;
        for (IDirectionalConfigHandler configHandler : this.configHandlers) {
            Widget widget = configHandler.getSideSelectorWidget(sceneWidget, this.machineUI);
            if (widget == null) continue;
            Size widgetSize = widget.getSize();
            switch (configHandler.getScreenSide()) {
                case LEFT: {
                    widget.setSelfPosition(new Position(6, this.height - 6 - widgetSize.height - yOffsetLeft));
                    yOffsetLeft += widgetSize.height + 3;
                    break;
                }
                case RIGHT: {
                    widget.setSelfPosition(new Position(this.width - widgetSize.width - 6, this.height - 6 - widgetSize.height - yOffsetRight));
                    yOffsetRight += widgetSize.height + 3;
                }
            }
            this.addWidget(widget);
        }
    }

    protected void onSideSelected(BlockPos pos, Direction side) {
        if (!pos.equals((Object)this.machine.getPos())) {
            return;
        }
        if (this.selectedSide == side) {
            return;
        }
        this.selectedSide = side;
        for (IDirectionalConfigHandler configWidget : this.configHandlers) {
            configWidget.onSideSelected(pos, side);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        BlockPosFace hover;
        Direction lastSide = this.selectedSide;
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (this.isMouseOverElement(mouseX, mouseY) && this.selectedSide == lastSide && this.selectedSide != null && (hover = this.sceneWidget.getHoverPosFace()) != null && hover.pos.equals((Object)this.machine.getPos()) && hover.facing == this.selectedSide) {
            ClickData cd = new ClickData();
            this.writeClientAction(65537, buf -> {
                cd.writeToBuf(buf);
                buf.writeByte(this.selectedSide.ordinal());
            });
        }
        return result;
    }

    public void handleClientAction(int id, FriendlyByteBuf buf) {
        if (id != 65537) {
            super.handleClientAction(id, buf);
            return;
        }
        ClickData clickData = ClickData.readFromBuf((FriendlyByteBuf)buf);
        Direction side = GTUtil.DIRECTIONS[buf.readByte()];
        for (IDirectionalConfigHandler configHandler : this.configHandlers) {
            configHandler.handleClick(clickData, side);
        }
    }
}

