/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifierList;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkableElectricMultiblockMachine
extends WorkableMultiblockMachine
implements IFancyUIMachine,
IDisplayUIMachine,
ITieredMachine,
IOverclockMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(WorkableElectricMultiblockMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    protected EnergyContainerList energyContainer;
    protected int tier;
    @Persisted
    protected boolean batchEnabled;

    public WorkableElectricMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyContainer = null;
        this.tier = 0;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.energyContainer = this.getEnergyContainer();
        this.tier = GTUtil.getFloorTierByVoltage(this.getMaxVoltage());
    }

    @Override
    public void onPartUnload() {
        super.onPartUnload();
        this.energyContainer = null;
        this.tier = 0;
    }

    @Override
    public void setBatchEnabled(boolean batch) {
        this.batchEnabled = batch;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        int totalRuns;
        int batchParallels;
        int subtickParallels;
        int numParallels;
        boolean exact = false;
        if (this.recipeLogic.isActive() && this.recipeLogic.getLastRecipe() != null) {
            numParallels = this.recipeLogic.getLastRecipe().parallels;
            subtickParallels = this.recipeLogic.getLastRecipe().subtickParallels;
            batchParallels = this.recipeLogic.getLastRecipe().batchParallels;
            totalRuns = this.recipeLogic.getLastRecipe().getTotalRuns();
            exact = true;
        } else {
            numParallels = this.getParallelHatch().map(IParallelHatch::getCurrentParallel).orElse(0);
            subtickParallels = 0;
            batchParallels = 0;
            totalRuns = 0;
        }
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).addEnergyUsageLine(this.energyContainer).addEnergyTierLine(this.tier).addMachineModeLine(this.getRecipeType(), this.getRecipeTypes().length > 1).addTotalRunsLine(totalRuns).addParallelsLine(numParallels, exact).addSubtickParallelsLine(subtickParallels).addBatchModeLine(this.isBatchEnabled(), batchParallels).addWorkingStatusLine().addProgressLine(this.recipeLogic.getProgress(), this.recipeLogic.getMaxProgress(), this.recipeLogic.getProgressPercent()).addOutputLines(this.recipeLogic.getLastRecipe());
        this.getDefinition().getAdditionalDisplay().accept(this, textList);
        IDisplayUIMachine.super.addDisplayText(textList);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground(this.getScreenTexture()).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).textSupplier(this.getLevel().f_46443_ ? null : this::addDisplayText).setMaxWidthLimit(200).clickHandler(this::handleDisplayClick)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(198, 208, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget(this, 198, 208));
    }

    @Override
    public List<IFancyUIProvider> getSubTabs() {
        return this.getParts().stream().filter(Objects::nonNull).map(IFancyUIProvider.class::cast).toList();
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        RecipeModifierList list;
        RecipeModifier recipeModifier = this.getDefinition().getRecipeModifier();
        if (recipeModifier instanceof RecipeModifierList && Arrays.stream((list = (RecipeModifierList)recipeModifier).getModifiers()).anyMatch(modifier -> modifier == GTRecipeModifiers.BATCH_MODE)) {
            configuratorPanel.attachConfigurators(new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.BUTTON_BATCH.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.BUTTON_BATCH.getSubTexture(0.0, 0.5, 1.0, 0.5), this::isBatchEnabled, (cd, p) -> this.setBatchEnabled((boolean)p)).setTooltipsSupplier(p -> List.of(Component.m_237115_((String)("gtceu.machine.batch_" + (p != false ? "enabled" : "disabled"))))));
        }
        IFancyUIMachine.super.attachConfigurators(configuratorPanel);
    }

    @Override
    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        for (IMultiPart part : this.getParts()) {
            part.attachFancyTooltipsToController(this, tooltipsPanel);
        }
    }

    @Override
    public int getOverclockTier() {
        return this.getTier();
    }

    @Override
    public int getMaxOverclockTier() {
        return this.getTier();
    }

    @Override
    public int getMinOverclockTier() {
        return this.getTier();
    }

    @Override
    public void setOverclockTier(int tier) {
    }

    @Override
    public long getOverclockVoltage() {
        long amperage;
        long voltage;
        if (this.energyContainer == null) {
            this.energyContainer = this.getEnergyContainer();
        }
        if (this.energyContainer.getInputVoltage() > this.energyContainer.getOutputVoltage()) {
            voltage = this.energyContainer.getInputVoltage();
            amperage = this.energyContainer.getInputAmperage();
        } else {
            voltage = this.energyContainer.getOutputVoltage();
            amperage = this.energyContainer.getOutputAmperage();
        }
        if (amperage == 1L) {
            return GTValues.VEX[GTUtil.getFloorTierByVoltage(voltage)];
        }
        return voltage;
    }

    public EnergyContainerList getEnergyContainer() {
        ArrayList<IEnergyContainer> containers = new ArrayList<IEnergyContainer>();
        List handlers = this.getCapabilitiesFlat(IO.IN, EURecipeCapability.CAP);
        if (handlers.isEmpty()) {
            handlers = this.getCapabilitiesFlat(IO.OUT, EURecipeCapability.CAP);
        }
        for (IRecipeHandler handler : handlers) {
            if (!(handler instanceof IEnergyContainer)) continue;
            IEnergyContainer container = (IEnergyContainer)((Object)handler);
            containers.add(container);
        }
        return new EnergyContainerList(containers);
    }

    @Override
    public long getMaxVoltage() {
        if (this.energyContainer == null) {
            this.energyContainer = this.getEnergyContainer();
        }
        if (this.isGenerator()) {
            long voltage = this.energyContainer.getOutputVoltage();
            long amperage = this.energyContainer.getOutputAmperage();
            if (amperage == 1L) {
                return GTValues.V[GTUtil.getFloorTierByVoltage(voltage)];
            }
            return voltage;
        }
        long highestVoltage = this.energyContainer.getHighestInputVoltage();
        if (this.energyContainer.getNumHighestInputContainers() > 1) {
            byte tier = GTUtil.getTierByVoltage(highestVoltage);
            return GTValues.V[Math.min(tier + 1, 14)];
        }
        return highestVoltage;
    }

    public boolean isGenerator() {
        return this.getDefinition().isGenerator();
    }

    @Override
    @Generated
    public int getTier() {
        return this.tier;
    }

    @Override
    @Generated
    public boolean isBatchEnabled() {
        return this.batchEnabled;
    }
}

