/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerList;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class IOFluidHandlerList
extends FluidHandlerList
implements IFluidHandlerModifiable {
    private final IO io;
    private final Predicate<FluidStack> inFilter;
    private final Predicate<FluidStack> outFilter;

    public IOFluidHandlerList(List<IFluidHandler> handlers, IO io, Predicate<FluidStack> inFilter, Predicate<FluidStack> outFilter) {
        super(handlers);
        this.io = io;
        this.inFilter = inFilter;
        this.outFilter = outFilter;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.io.support(IO.IN) || !this.inFilter.test(resource)) {
            return 0;
        }
        return super.fill(resource, action);
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.io.support(IO.OUT) || !this.outFilter.test(resource)) {
            return FluidStack.EMPTY;
        }
        return super.drain(resource, action);
    }

    @Override
    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.io.support(IO.OUT)) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = super.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty() || !this.outFilter.test(fluidStack)) {
            return FluidStack.EMPTY;
        }
        return action.simulate() ? fluidStack : super.drain(maxDrain, action);
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        Predicate<FluidStack> filter = s -> true;
        if (this.io.support(IO.IN)) {
            filter = this.inFilter.and(filter);
        }
        if (this.io.support(IO.OUT)) {
            filter = this.outFilter.and(filter);
        }
        return filter.test(stack) && super.isFluidValid(tank, stack);
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        int index = 0;
        for (IFluidHandler handler : this.handlers) {
            if (handler instanceof IFluidHandlerModifiable) {
                IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)handler;
                if (tank - index < handler.getTanks()) {
                    modifiable.setFluidInTank(tank - index, stack);
                }
                return;
            }
            index += handler.getTanks();
        }
    }

    @Generated
    public IO getIo() {
        return this.io;
    }
}

