/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.google.common.base.Joiner;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FactoryBlockPattern {
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    private final List<String[]> depth = new ArrayList<String[]>();
    private final List<int[]> aisleRepetitions = new ArrayList<int[]>();
    private final Char2ObjectMap<TraceabilityPredicate> symbolMap = new Char2ObjectArrayMap();
    private final RelativeDirection[] structureDir = new RelativeDirection[3];
    private int aisleHeight;
    private int rowWidth;

    private FactoryBlockPattern(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir) {
        this.structureDir[0] = charDir;
        this.structureDir[1] = stringDir;
        this.structureDir[2] = aisleDir;
        int flags = 0;
        block5: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i]) {
                case UP: 
                case DOWN: {
                    flags |= 1;
                    continue block5;
                }
                case LEFT: 
                case RIGHT: {
                    flags |= 2;
                    continue block5;
                }
                case FRONT: 
                case BACK: {
                    flags |= 4;
                }
            }
        }
        if (flags != 7) {
            throw new IllegalArgumentException("Must have 3 different axes!");
        }
        this.symbolMap.put(' ', (Object)Predicates.any());
    }

    public FactoryBlockPattern aisleRepeatable(int minRepeat, int maxRepeat, String ... aisle) {
        if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
            if (this.depth.isEmpty()) {
                this.aisleHeight = aisle.length;
                this.rowWidth = aisle[0].length();
            }
            if (aisle.length != this.aisleHeight) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length + ")");
            }
            for (String s : aisle) {
                if (s.length() != this.rowWidth) {
                    throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + s.length() + ")");
                }
                for (char c0 : s.toCharArray()) {
                    if (this.symbolMap.containsKey(c0)) continue;
                    this.symbolMap.put(c0, null);
                }
            }
            this.depth.add(aisle);
            if (minRepeat > maxRepeat) {
                throw new IllegalArgumentException("Lower bound of repeat counting must smaller than upper bound!");
            }
            this.aisleRepetitions.add(new int[]{minRepeat, maxRepeat});
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public FactoryBlockPattern aisle(String ... aisle) {
        return this.aisleRepeatable(1, 1, aisle);
    }

    public FactoryBlockPattern setRepeatable(int minRepeat, int maxRepeat) {
        if (minRepeat > maxRepeat) {
            throw new IllegalArgumentException("Lower bound of repeat counting must smaller than upper bound!");
        }
        this.aisleRepetitions.set(this.aisleRepetitions.size() - 1, new int[]{minRepeat, maxRepeat});
        return this;
    }

    public FactoryBlockPattern setRepeatable(int repeatCount) {
        return this.setRepeatable(repeatCount, repeatCount);
    }

    public static FactoryBlockPattern start() {
        return new FactoryBlockPattern(RelativeDirection.LEFT, RelativeDirection.UP, RelativeDirection.FRONT);
    }

    public static FactoryBlockPattern start(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir) {
        return new FactoryBlockPattern(charDir, stringDir, aisleDir);
    }

    public FactoryBlockPattern where(String symbol, TraceabilityPredicate blockMatcher) {
        return this.where(symbol.charAt(0), blockMatcher);
    }

    public FactoryBlockPattern where(char symbol, TraceabilityPredicate blockMatcher) {
        if (blockMatcher.isAny() || blockMatcher.isAir()) {
            this.symbolMap.put(symbol, (Object)blockMatcher);
        } else {
            this.symbolMap.put(symbol, (Object)new TraceabilityPredicate(blockMatcher).sort());
        }
        return this;
    }

    public BlockPattern build() {
        this.checkMissingPredicates();
        int[] centerOffset = new int[5];
        int[][] aisleRepetitions = (int[][])this.aisleRepetitions.toArray((T[])new int[this.aisleRepetitions.size()][]);
        TraceabilityPredicate[][][] predicate = (TraceabilityPredicate[][][])Array.newInstance(TraceabilityPredicate.class, this.depth.size(), this.aisleHeight, this.rowWidth);
        int minZ = 0;
        int maxZ = 0;
        for (int i = 0; i < this.depth.size(); ++i) {
            for (int j = 0; j < this.aisleHeight; ++j) {
                for (int k = 0; k < this.rowWidth; ++k) {
                    predicate[i][j][k] = (TraceabilityPredicate)this.symbolMap.get(this.depth.get(i)[j].charAt(k));
                    if (!predicate[i][j][k].isController) continue;
                    centerOffset = new int[]{k, j, i, minZ, maxZ};
                }
            }
            minZ += aisleRepetitions[i][0];
            maxZ += aisleRepetitions[i][1];
        }
        return new BlockPattern(predicate, this.structureDir, aisleRepetitions, centerOffset);
    }

    private TraceabilityPredicate[][][] makePredicateArray() {
        this.checkMissingPredicates();
        TraceabilityPredicate[][][] predicate = (TraceabilityPredicate[][][])Array.newInstance(TraceabilityPredicate.class, this.depth.size(), this.aisleHeight, this.rowWidth);
        for (int i = 0; i < this.depth.size(); ++i) {
            for (int j = 0; j < this.aisleHeight; ++j) {
                for (int k = 0; k < this.rowWidth; ++k) {
                    predicate[i][j][k] = (TraceabilityPredicate)this.symbolMap.get(this.depth.get(i)[j].charAt(k));
                }
            }
        }
        return predicate;
    }

    private void checkMissingPredicates() {
        CharArrayList list = new CharArrayList();
        for (Char2ObjectMap.Entry entry : this.symbolMap.char2ObjectEntrySet()) {
            if (entry.getValue() != null) continue;
            list.add(entry.getCharKey());
        }
        if (!list.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + COMMA_JOIN.join((Iterable)list) + " are missing");
        }
    }
}

