/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.util;

import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum RelativeDirection implements StringRepresentable
{
    UP(dir -> dir.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, Direction.UP),
    DOWN(dir -> dir.m_122434_() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, Direction.DOWN),
    LEFT(dir -> {
        if (dir == Direction.UP) {
            return Direction.EAST;
        }
        if (dir == Direction.DOWN) {
            return Direction.WEST;
        }
        return dir.m_122428_();
    }, Direction.WEST),
    RIGHT(dir -> {
        if (dir == Direction.UP) {
            return Direction.WEST;
        }
        if (dir == Direction.DOWN) {
            return Direction.EAST;
        }
        return dir.m_122427_();
    }, Direction.EAST),
    FRONT(UnaryOperator.identity(), Direction.NORTH),
    BACK(Direction::m_122424_, Direction.SOUTH);

    public static final StringRepresentable.EnumCodec<RelativeDirection> CODEC;
    public static final RelativeDirection[] VALUES;
    private static final RelativeDirection[] BY_GLOBAL_DIRECTION;
    private final UnaryOperator<Direction> actualDirection;
    public final Direction global;

    private RelativeDirection(UnaryOperator<Direction> actualDirection, Direction global) {
        this.actualDirection = actualDirection;
        this.global = global;
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public RelativeDirection getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> DOWN;
            case DOWN -> UP;
            case LEFT -> RIGHT;
            case RIGHT -> LEFT;
            case FRONT -> BACK;
            case BACK -> FRONT;
        };
    }

    public Direction getActualDirection(Direction direction) {
        return (Direction)this.actualDirection.apply(direction);
    }

    public boolean isSameAxis(RelativeDirection other) {
        return this.global.m_122434_() == other.global.m_122434_();
    }

    public Vec3i applyVec3i(Direction facing) {
        return this.getActualDirection(facing).m_122436_();
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="8.0.0")
    public Direction getRelativeFacing(Direction frontFacing, Direction upwardsFacing, boolean isFlipped) {
        return this.getRelative(frontFacing, upwardsFacing, isFlipped);
    }

    public Direction getRelative(Direction frontDir, Direction upwardsDir, boolean isFlipped) {
        Direction.Axis frontAxis = frontDir.m_122434_();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> {
                if (frontAxis == Direction.Axis.Y) {
                    yield upwardsDir;
                }
                switch (upwardsDir) {
                    case NORTH: {
                        yield Direction.UP;
                    }
                    case SOUTH: {
                        yield Direction.DOWN;
                    }
                    case EAST: {
                        yield frontDir.m_122428_();
                    }
                }
                yield frontDir.m_122427_();
            }
            case DOWN -> {
                if (frontAxis == Direction.Axis.Y) {
                    yield upwardsDir.m_122424_();
                }
                switch (upwardsDir) {
                    case NORTH: {
                        yield Direction.DOWN;
                    }
                    case SOUTH: {
                        yield Direction.UP;
                    }
                    case EAST: {
                        yield frontDir.m_122427_();
                    }
                }
                yield frontDir.m_122428_();
            }
            case LEFT -> {
                Direction direction;
                if (frontAxis == Direction.Axis.Y) {
                    direction = frontDir.m_122430_() > 0 ? upwardsDir.m_122427_() : upwardsDir.m_122428_();
                } else {
                    switch (upwardsDir) {
                        case NORTH: {
                            Direction v1 = frontDir.m_122428_();
                            break;
                        }
                        case SOUTH: {
                            Direction v1 = frontDir.m_122427_();
                            break;
                        }
                        case EAST: {
                            Direction v1 = Direction.DOWN;
                            break;
                        }
                        default: {
                            Direction v1 = direction = Direction.UP;
                        }
                    }
                }
                if (isFlipped) {
                    yield direction.m_122424_();
                }
                yield direction;
            }
            case RIGHT -> {
                Direction direction;
                if (frontAxis == Direction.Axis.Y) {
                    direction = frontDir.m_122430_() > 0 ? upwardsDir.m_122428_() : upwardsDir.m_122427_();
                } else {
                    switch (upwardsDir) {
                        case NORTH: {
                            Direction v2 = frontDir.m_122427_();
                            break;
                        }
                        case SOUTH: {
                            Direction v2 = frontDir.m_122428_();
                            break;
                        }
                        case EAST: {
                            Direction v2 = Direction.UP;
                            break;
                        }
                        default: {
                            Direction v2 = direction = Direction.DOWN;
                        }
                    }
                }
                if (isFlipped) {
                    yield direction.m_122424_();
                }
                yield direction;
            }
            case FRONT -> frontDir;
            case BACK -> frontDir.m_122424_();
        };
    }

    public Comparator<BlockPos> getSorter(Direction frontDir, Direction upwardsDir, boolean isFlipped) {
        Direction sorterDirection = this.getRelative(frontDir, upwardsDir, isFlipped);
        return switch (sorterDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Comparator.comparingInt(Vec3i::m_123342_);
            case Direction.DOWN -> Comparator.comparingInt(pos -> -pos.m_123342_());
            case Direction.NORTH -> Comparator.comparingInt(pos -> -pos.m_123343_());
            case Direction.EAST -> Comparator.comparingInt(Vec3i::m_123341_);
            case Direction.SOUTH -> Comparator.comparingInt(Vec3i::m_123343_);
            case Direction.WEST -> Comparator.comparingInt(pos -> -pos.m_123341_());
        };
    }

    public static Direction simulateAxisRotation(Direction newFrontDir, Direction oldFrontDir, Direction upwardsDir) {
        if (newFrontDir == oldFrontDir) {
            return upwardsDir;
        }
        Direction.Axis newAxis = newFrontDir.m_122434_();
        Direction.Axis oldAxis = oldFrontDir.m_122434_();
        if (newAxis != Direction.Axis.Y && oldAxis != Direction.Axis.Y) {
            return upwardsDir;
        }
        if (newAxis == Direction.Axis.Y && oldAxis != Direction.Axis.Y) {
            Direction newUpwardsDir = switch (upwardsDir) {
                case Direction.NORTH -> oldFrontDir.m_122424_();
                case Direction.SOUTH -> oldFrontDir;
                case Direction.EAST -> oldFrontDir.m_122428_();
                default -> oldFrontDir.m_122427_();
            };
            return newFrontDir == Direction.DOWN && upwardsDir.m_122434_() == Direction.Axis.Z ? newUpwardsDir.m_122424_() : newUpwardsDir;
        }
        if (newAxis != Direction.Axis.Y) {
            Direction newUpwardsDir = upwardsDir == newFrontDir ? Direction.SOUTH : (upwardsDir == newFrontDir.m_122424_() ? Direction.NORTH : (upwardsDir == newFrontDir.m_122427_() ? Direction.WEST : Direction.EAST));
            return oldFrontDir == Direction.DOWN && newUpwardsDir.m_122434_() == Direction.Axis.Z ? newUpwardsDir.m_122424_() : newUpwardsDir;
        }
        return upwardsDir.m_122424_();
    }

    public static BlockPos offsetPos(BlockPos pos, Direction frontDir, Direction upwardsDir, boolean isFlipped, int upOffset, int leftOffset, int forwardOffset) {
        if (upOffset == 0 && leftOffset == 0 && forwardOffset == 0) {
            return pos;
        }
        int oX = 0;
        int oY = 0;
        int oZ = 0;
        Direction relUp = UP.getRelative(frontDir, upwardsDir, isFlipped);
        oX += relUp.m_122429_() * upOffset;
        oY += relUp.m_122430_() * upOffset;
        oZ += relUp.m_122431_() * upOffset;
        Direction relLeft = LEFT.getRelative(frontDir, upwardsDir, isFlipped);
        oX += relLeft.m_122429_() * leftOffset;
        oY += relLeft.m_122430_() * leftOffset;
        oZ += relLeft.m_122431_() * leftOffset;
        Direction relForward = FRONT.getRelative(frontDir, upwardsDir, isFlipped);
        return pos.m_7918_(oX += relForward.m_122429_() * forwardOffset, oY += relForward.m_122430_() * forwardOffset, oZ += relForward.m_122431_() * forwardOffset);
    }

    public static RelativeDirection fromGlobalDirection(Direction direction) {
        return BY_GLOBAL_DIRECTION[direction.ordinal()];
    }

    public static Direction getActualDirection(Direction original, Direction current, Direction direction) {
        return RelativeDirection.findRelativeOf(original, current).getActualDirection(direction);
    }

    public static RelativeDirection findRelativeOf(Direction baseDir, Direction relativeDir) {
        return RelativeDirection.findRelativeOf(baseDir, relativeDir, Direction.NORTH);
    }

    public static RelativeDirection findRelativeOf(Direction baseDir, Direction relativeDir, Direction upwardsDir) {
        if (baseDir == relativeDir) {
            return FRONT;
        }
        if (baseDir.m_122424_() == relativeDir) {
            return BACK;
        }
        if (baseDir.m_122434_().m_122479_()) {
            if (relativeDir == Direction.UP) {
                return UP;
            }
            if (relativeDir == Direction.DOWN) {
                return DOWN;
            }
            if (relativeDir == baseDir.m_122428_()) {
                return LEFT;
            }
            return RIGHT;
        }
        if (upwardsDir.m_122434_() == Direction.Axis.Y) {
            throw new IllegalStateException("upwardsDir must be a horizontal direction! is " + String.valueOf(upwardsDir));
        }
        if (relativeDir == upwardsDir.m_122428_()) {
            return LEFT;
        }
        if (relativeDir == upwardsDir.m_122427_()) {
            return RIGHT;
        }
        RelativeDirection dir = relativeDir == upwardsDir.m_122424_() ? UP : DOWN;
        if (baseDir == Direction.DOWN) {
            dir = dir.getOpposite();
        }
        return dir;
    }

    static {
        CODEC = StringRepresentable.m_216439_(RelativeDirection::values);
        VALUES = RelativeDirection.values();
        BY_GLOBAL_DIRECTION = new RelativeDirection[GTUtil.DIRECTIONS.length];
        RelativeDirection[] relativeDirectionArray = VALUES;
        int n = relativeDirectionArray.length;
        for (int i = 0; i < n; ++i) {
            RelativeDirection relative;
            RelativeDirection.BY_GLOBAL_DIRECTION[relative.global.ordinal()] = relative = relativeDirectionArray[i];
        }
    }
}

