/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PipeNetWalker<T extends IPipeNode<?, ?>, NodeDataType, Net extends PipeNet<NodeDataType>> {
    protected PipeNetWalker<T, NodeDataType, Net> root;
    protected final Net pipeNet;
    private Set<T> walked;
    protected List<PipeNetWalker<T, NodeDataType, Net>> walkers;
    protected final BlockPos.MutableBlockPos currentPos;
    protected final List<Direction> nextPipeFacings = new ArrayList<Direction>(5);
    protected final List<T> nextPipes = new ArrayList<T>(5);
    protected T currentPipe;
    private Direction from = null;
    protected int walkedBlocks;
    protected boolean invalid;
    protected boolean running;
    private boolean failed = false;

    protected PipeNetWalker(Net pipeNet, BlockPos sourcePipe, int walkedBlocks) {
        this.pipeNet = pipeNet;
        this.walkedBlocks = walkedBlocks;
        this.currentPos = sourcePipe.m_122032_();
        this.root = this;
    }

    @NotNull
    protected abstract PipeNetWalker<T, NodeDataType, Net> createSubWalker(Net var1, Direction var2, BlockPos var3, int var4);

    protected void checkNeighbour(T pipeNode, BlockPos pipePos, Direction faceToNeighbour, @Nullable BlockEntity neighbourTile) {
    }

    protected boolean isValidPipe(T currentPipe, T neighbourPipe, BlockPos pipePos, Direction faceToNeighbour) {
        return true;
    }

    protected abstract Class<T> getBasePipeClass();

    protected abstract void checkPipe(T var1, BlockPos var2);

    protected Direction[] getSurroundingPipeSides() {
        return GTUtil.DIRECTIONS;
    }

    protected void onRemoveSubWalker(PipeNetWalker<T, NodeDataType, Net> subWalker) {
    }

    public void traversePipeNet() {
        this.traversePipeNet(32768);
    }

    public void traversePipeNet(int maxWalks) {
        if (this.invalid) {
            throw new IllegalStateException("This walker already walked. Create a new one if you want to walk again");
        }
        this.root = this;
        this.walked = new ObjectOpenHashSet();
        int i = 0;
        this.running = true;
        while (this.running && !this.walk() && i++ < maxWalks) {
        }
        this.running = false;
        this.root.walked.clear();
        if (i >= maxWalks) {
            GTCEu.LOGGER.warn("The walker reached the maximum amount of walks {}", (Object)i);
        }
        this.invalid = true;
    }

    private boolean walk() {
        if (this.walkers == null) {
            if (!this.checkPos()) {
                this.root.failed = true;
                return true;
            }
            if (this.nextPipeFacings.isEmpty()) {
                return true;
            }
            if (this.nextPipeFacings.size() == 1) {
                this.currentPos.m_122190_((Vec3i)((IPipeNode)this.nextPipes.get(0)).getPipePos());
                this.currentPipe = (IPipeNode)this.nextPipes.get(0);
                this.from = this.nextPipeFacings.get(0).m_122424_();
                ++this.walkedBlocks;
                return !this.isRunning();
            }
            this.walkers = new ArrayList<PipeNetWalker<T, NodeDataType, Net>>();
            for (int i = 0; i < this.nextPipeFacings.size(); ++i) {
                Direction side = this.nextPipeFacings.get(i);
                PipeNetWalker<T, NodeDataType, Net> walker = Objects.requireNonNull(this.createSubWalker(this.pipeNet, side, this.currentPos.m_121945_(side), this.walkedBlocks + 1), "Walker can't be null");
                walker.root = this.root;
                walker.currentPipe = (IPipeNode)this.nextPipes.get(i);
                walker.from = side.m_122424_();
                this.walkers.add(walker);
            }
        }
        Iterator<PipeNetWalker<T, NodeDataType, Net>> iterator = this.walkers.iterator();
        while (iterator.hasNext()) {
            PipeNetWalker<T, NodeDataType, Net> walker = iterator.next();
            if (!walker.walk()) continue;
            this.onRemoveSubWalker(walker);
            iterator.remove();
        }
        return !this.isRunning() || this.walkers.isEmpty();
    }

    private boolean checkPos() {
        this.nextPipeFacings.clear();
        this.nextPipes.clear();
        if (this.currentPipe == null) {
            BlockEntity thisPipe = this.getLevel().m_7702_((BlockPos)this.currentPos);
            if (!(thisPipe instanceof IPipeNode)) {
                GTCEu.LOGGER.error("PipeWalker expected a pipe, but found {} at {}", (Object)thisPipe, (Object)this.currentPos);
                return false;
            }
            if (!this.getBasePipeClass().isAssignableFrom(thisPipe.getClass())) {
                return false;
            }
            this.currentPipe = (IPipeNode)thisPipe;
        }
        T pipeTile = this.currentPipe;
        this.checkPipe(pipeTile, (BlockPos)this.currentPos);
        this.root.walked.add(pipeTile);
        for (Direction accessSide : this.getSurroundingPipeSides()) {
            if (accessSide == this.from || !pipeTile.isConnected(accessSide)) continue;
            BlockEntity tile = pipeTile.getNeighbor(accessSide);
            if (tile != null && this.getBasePipeClass().isAssignableFrom(tile.getClass())) {
                IPipeNode otherPipe = (IPipeNode)tile;
                if (!otherPipe.isConnected(accessSide.m_122424_()) || otherPipe.isBlocked(accessSide.m_122424_()) || this.isWalked(otherPipe)) continue;
                if (this.isValidPipe(pipeTile, otherPipe, (BlockPos)this.currentPos, accessSide)) {
                    this.nextPipeFacings.add(accessSide);
                    this.nextPipes.add(otherPipe);
                    continue;
                }
            }
            this.checkNeighbour(pipeTile, (BlockPos)this.currentPos, accessSide, tile);
        }
        return true;
    }

    protected boolean isWalked(T pipe) {
        return this.root.walked.contains(pipe);
    }

    public void stop() {
        this.root.running = false;
    }

    public boolean isRunning() {
        return this.root.running;
    }

    public ServerLevel getLevel() {
        return ((PipeNet)this.pipeNet).getLevel();
    }

    public BlockPos getCurrentPos() {
        return this.currentPos.m_7949_();
    }

    @Generated
    public int getWalkedBlocks() {
        return this.walkedBlocks;
    }

    @Generated
    public boolean isInvalid() {
        return this.invalid;
    }

    @Generated
    public boolean isFailed() {
        return this.failed;
    }
}

