/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.common.data.GTFluids;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluidHelper;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

@OnlyIn(value=Dist.CLIENT)
public class TooltipsHandler {
    private static final String ITEM_PREFIX = "item.gtceu";
    private static final String BLOCK_PREFIX = "block.gtceu";

    public static void appendTooltips(ItemStack stack, TooltipFlag flag, List<Component> tooltips) {
        Material material;
        Item item;
        String formula;
        MaterialEntry materialEntry = ChemicalHelper.getMaterialEntry((ItemLike)stack.m_41720_());
        if (!materialEntry.isEmpty() && (formula = materialEntry.material().getChemicalFormula()) != null && !formula.isEmpty()) {
            tooltips.add(1, (Component)Component.m_237113_((String)formula).m_130940_(ChatFormatting.YELLOW));
        }
        if ((item = stack.m_41720_()) instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            Fluid fluid = bucket.getFluid();
            if (!(fluid instanceof EmptyFluid)) {
                TooltipsHandler.appendFluidTooltips(new FluidStack(fluid, 1000), tooltips::add, flag);
            }
        } else if (stack.m_41720_() instanceof MilkBucketItem) {
            TooltipsHandler.appendFluidTooltips(GTMaterials.Milk.getFluid(1000), tooltips::add, flag);
        }
        String translationKey = stack.m_41778_();
        if (translationKey.startsWith(ITEM_PREFIX) || translationKey.startsWith(BLOCK_PREFIX)) {
            String tooltipKey = translationKey + ".tooltip";
            if (Language.m_128107_().m_6722_(tooltipKey)) {
                tooltips.add(1, (Component)Component.m_237115_((String)tooltipKey));
            } else {
                List<MutableComponent> multiLang = LangHandler.getMultiLang(tooltipKey);
                if (multiLang != null && !multiLang.isEmpty()) {
                    tooltips.addAll(1, multiLang);
                }
            }
        }
        if ((material = HazardProperty.getValidHazardMaterial(stack)).isNull()) {
            return;
        }
        GTUtil.appendHazardTooltips(material, tooltips);
    }

    public static void appendFluidTooltips(FluidStack fluidStack, Consumer<Component> tooltips, TooltipFlag flag) {
        Fluid fluid = fluidStack.getFluid();
        int amount = fluidStack.getAmount();
        FluidType fluidType = fluid.getFluidType();
        if (fluidType == GTFluids.POTION.getType()) {
            if (fluid.m_205067_(FluidTags.f_13131_)) {
                return;
            }
            PotionFluidHelper.addPotionTooltip(fluidStack, tooltips);
            return;
        }
        Material material = ChemicalHelper.getMaterial(fluid);
        if (!material.isNull()) {
            String formula = material.getChemicalFormula();
            if (formula != null && !formula.isEmpty()) {
                tooltips.accept((Component)Component.m_237113_((String)formula).m_130940_(ChatFormatting.YELLOW));
            }
            if (material.hasProperty(PropertyKey.INGOT) && GTUtil.isShiftDown() && amount >= 144) {
                long ingots = amount / 144;
                long remainder = amount % 144;
                Object fluidAmount = String.format(" %,d mB = %,d * %d mB", amount, ingots, 144);
                if (remainder != 0L) {
                    fluidAmount = (String)fluidAmount + String.format(" + %d mB", remainder);
                }
                tooltips.accept((Component)Component.m_237115_((String)"gtceu.gui.fluid_amount").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)fluidAmount)));
            }
        }
        if (fluid instanceof GTFluid) {
            GTFluid attributedFluid = (GTFluid)fluid;
            FluidState state = attributedFluid.getState();
            switch (state) {
                case LIQUID: {
                    tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.state_liquid"));
                    break;
                }
                case GAS: {
                    tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.state_gas"));
                    break;
                }
                case PLASMA: {
                    tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.state_plasma"));
                }
            }
            attributedFluid.getAttributes().forEach(a -> a.appendFluidTooltips(tooltips));
        } else {
            String key = "gtceu.fluid.state_" + (fluidType.isLighterThanAir() ? "gas" : "liquid");
            tooltips.accept((Component)Component.m_237115_((String)key));
        }
        tooltips.accept((Component)Component.m_237110_((String)"gtceu.fluid.temperature", (Object[])new Object[]{fluidType.getTemperature()}));
        if (fluidType.getTemperature() < 120) {
            tooltips.accept((Component)Component.m_237115_((String)"gtceu.fluid.temperature.cryogenic"));
        }
    }
}

