/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.particle;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class MufflerParticle
extends TextureSheetParticle {
    private static final int COLOR = 1973277;
    private final SpriteSet sprites;

    protected MufflerParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SimpleParticleType options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107215_ *= (double)0.1f;
        this.f_107216_ *= 0.5;
        this.f_107217_ *= (double)0.1f;
        float colorMultiplier = this.f_107223_.m_188501_() * 4.4f + 1.3f;
        this.f_107227_ = this.randomizeColor((float)FastColor.ARGB32.m_13665_((int)1973277) / 255.0f, colorMultiplier);
        this.f_107228_ = this.randomizeColor((float)FastColor.ARGB32.m_13667_((int)1973277) / 255.0f, colorMultiplier);
        this.f_107229_ = this.randomizeColor((float)FastColor.ARGB32.m_13669_((int)1973277) / 255.0f, colorMultiplier + 1.0f);
        this.f_107663_ *= 1.5f;
        this.f_107225_ = (int)((double)this.f_107225_ / ((double)level.f_46441_.m_188501_() * 0.8 + 0.2) * 2.0);
        this.m_108339_(sprites);
        this.f_107219_ = true;
    }

    protected float randomizeColor(float coordMultiplier, float multiplier) {
        return (this.f_107223_.m_188501_() * 0.2f + 0.8f) * coordMultiplier * multiplier;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.m_108339_(this.sprites);
        if (this.f_107224_++ < this.f_107225_ && !(this.f_107230_ <= 0.0f)) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107224_ >= this.f_107225_ - 60 && this.f_107230_ > 0.01f) {
                this.f_107230_ -= 0.015f;
            }
        } else {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RandomSource randomSource = level.f_46441_;
            return new MufflerParticle(level, x, y, z, xSpeed, ySpeed += (double)randomSource.m_188501_() * -1.9 * (double)randomSource.m_188501_() * 0.1 * 5.0, zSpeed, options, this.sprites);
        }
    }
}

