/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.IIOCover;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.client.util.ModelUtils;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOCoverRenderer
implements ICoverRenderer {
    public static final IOCoverRenderer PUMP_LIKE_COVER_RENDERER = new IOCoverRenderer(GTCEu.id("block/cover/pump"), GTCEu.id("block/cover/pump_inverted"), null, null);
    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite overlaySprite = null;
    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite invertedOverlaySprite = null;
    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite emissiveOverlaySprite = null;
    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite invertedEmissiveOverlaySprite = null;

    public IOCoverRenderer(@Nullable ResourceLocation overlay, @Nullable ResourceLocation invertedOverlay, @Nullable ResourceLocation emissiveOverlay, @Nullable ResourceLocation invertedEmissiveOverlay) {
        ModelUtils.registerAtlasStitchedEventListener(false, InventoryMenu.f_39692_, event -> {
            TextureAtlas atlas = event.getAtlas();
            if (overlay != null) {
                this.overlaySprite = atlas.m_118316_(overlay);
            }
            if (invertedOverlay != null) {
                this.invertedOverlaySprite = atlas.m_118316_(invertedOverlay);
            }
            if (emissiveOverlay != null) {
                this.emissiveOverlaySprite = atlas.m_118316_(emissiveOverlay);
            }
            if (invertedEmissiveOverlay != null) {
                this.invertedEmissiveOverlaySprite = atlas.m_118316_(invertedEmissiveOverlay);
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderCover(List<BakedQuad> quads, @Nullable Direction side, RandomSource rand, @NotNull CoverBehavior coverBehavior, BlockPos pos, BlockAndTintGetter level, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if ((side == null || side == coverBehavior.attachedSide) && coverBehavior instanceof IIOCover) {
            boolean isInverted;
            IIOCover ioCover = (IIOCover)((Object)coverBehavior);
            boolean bl = isInverted = ioCover.getIo() != IO.OUT;
            if (isInverted && this.invertedOverlaySprite != null) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.COVER_OVERLAY, coverBehavior.attachedSide, this.invertedOverlaySprite));
            } else if (this.overlaySprite != null) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.COVER_OVERLAY, coverBehavior.attachedSide, this.overlaySprite));
            }
            if (isInverted && this.invertedEmissiveOverlaySprite != null) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.COVER_OVERLAY, coverBehavior.attachedSide, this.invertedEmissiveOverlaySprite, (ModelState)BlockModelRotation.X0_Y0, -101, 15, true, false));
            } else if (this.emissiveOverlaySprite != null) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.COVER_OVERLAY, coverBehavior.attachedSide, this.emissiveOverlaySprite, (ModelState)BlockModelRotation.X0_Y0, -101, 15, true, false));
            }
        }
    }
}

