/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.entity;

import com.gregtechceu.gtceu.common.entity.GTExplosiveEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GTExplosiveRenderer<T extends GTExplosiveEntity>
extends EntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;

    public GTExplosiveRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        this.blockRenderer = context.m_234597_();
    }

    public void render(@NotNull T entity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.5f, 0.0f);
        int fuseTime = entity.m_32100_();
        if ((float)fuseTime - partialTicks + 1.0f < 10.0f) {
            float size = 1.0f - ((float)fuseTime - partialTicks + 1.0f) / 10.0f;
            size = Mth.m_14036_((float)size, (float)0.0f, (float)1.0f);
            size *= size;
            size *= size;
            float scale = 1.0f + size * 0.3f;
            poseStack.m_85841_(scale, scale, scale);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252880_(-0.5f, -0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        TntMinecartRenderer.m_234661_((BlockRenderDispatcher)this.blockRenderer, (BlockState)((GTExplosiveEntity)((Object)entity)).getExplosiveState(), (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (fuseTime / 5 % 2 == 0 ? 1 : 0) != 0);
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return InventoryMenu.f_39692_;
    }
}

