/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.BoilerMultiPartRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.CentralMonitorRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.FluidAreaRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.FusionRingRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.GrowingPlantRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.QuantumChestItemRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.QuantumTankFluidRender;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DynamicRenderHelper {
    public static DynamicRender<?, ?> makeBoilerPartRender(BoilerFireboxType fireboxType, Supplier<? extends Block> casingBlock) {
        return new BoilerMultiPartRender(fireboxType, casingBlock);
    }

    public static DynamicRender<?, ?> makeFluidAreaRender(FluidBlockRenderer fluidBlockRenderer, Optional<Fluid> fixedFluid, List<RelativeDirection> drawFaces) {
        return new FluidAreaRender(fluidBlockRenderer, fixedFluid, drawFaces);
    }

    public static DynamicRender<?, ?> makeGrowingPlantRender(Vec3i ... offsets) {
        return DynamicRenderHelper.makeGrowingPlantRender(null, null, offsets);
    }

    public static DynamicRender<?, ?> makeGrowingPlantRender(@Nullable Block growingBlock, @Nullable GrowingPlantRender.GrowthMode growthMode, Vec3i ... offsets) {
        return DynamicRenderHelper.makeGrowingPlantRender(growingBlock, growthMode, Arrays.stream(offsets).map(v -> new Vector3f((float)v.m_123341_(), (float)v.m_123342_(), (float)v.m_123343_())).toList());
    }

    public static DynamicRender<?, ?> makeGrowingPlantRender(Vector3f ... offsets) {
        return DynamicRenderHelper.makeGrowingPlantRender(null, null, offsets);
    }

    public static DynamicRender<?, ?> makeGrowingPlantRender(@Nullable Block growingBlock, @Nullable GrowingPlantRender.GrowthMode growthMode, Vector3f ... offsets) {
        return DynamicRenderHelper.makeGrowingPlantRender(growingBlock, growthMode, Arrays.asList(offsets));
    }

    public static DynamicRender<?, ?> makeGrowingPlantRender(List<Vector3f> offsets) {
        return DynamicRenderHelper.makeGrowingPlantRender(null, null, offsets);
    }

    public static DynamicRender<?, ?> makeGrowingPlantRender(@Nullable Block growingBlock, @Nullable GrowingPlantRender.GrowthMode growthMode, List<Vector3f> offsets) {
        return new GrowingPlantRender(offsets, Optional.ofNullable(growingBlock), Optional.ofNullable(growthMode));
    }

    public static DynamicRender<?, ?> makeRecipeFluidAreaRender() {
        return DynamicRenderHelper.makeFluidAreaRender(FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer(), Optional.empty(), FluidAreaRender.DEFAULT_FACES);
    }

    public static DynamicRender<?, ?> createPBFLavaRender() {
        return DynamicRenderHelper.makeFluidAreaRender(FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer(), Optional.of(Fluids.f_76195_.m_5613_()), FluidAreaRender.DEFAULT_FACES);
    }

    public static DynamicRender<?, ?> createFusionRingRender() {
        return new FusionRingRender();
    }

    public static DynamicRender<?, ?> createQuantumChestRender() {
        return new QuantumChestItemRender();
    }

    public static DynamicRender<?, ?> createQuantumTankRender() {
        return new QuantumTankFluidRender();
    }

    public static DynamicRender<?, ?> createCentralMonitorRender() {
        return new CentralMonitorRender();
    }
}

