/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.capability.IMonitorComponent;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMonitorModuleItem;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CentralMonitorMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CentralMonitorRender
extends DynamicRender<CentralMonitorMachine, CentralMonitorRender> {
    public static final Codec<CentralMonitorRender> CODEC = Codec.unit(CentralMonitorRender::new);
    public static final DynamicRenderType<CentralMonitorMachine, CentralMonitorRender> TYPE = new DynamicRenderType(CODEC);
    private static final float SCREEN_OFFSET_Z = 0.01f;

    @Override
    public DynamicRenderType<CentralMonitorMachine, CentralMonitorRender> getType() {
        return TYPE;
    }

    @Override
    public void render(CentralMonitorMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        RenderUtil.moveToFace(poseStack, 0.5f, 0.5f, 0.5f, machine.getFrontFacing());
        RenderUtil.rotateToFace(poseStack, machine.getFrontFacing(), machine.getUpwardsFacing());
        poseStack.m_252880_((float)(-machine.getRightDist()) - 0.5f, (float)(-machine.getUpDist()) - 0.5f, 0.01f);
        if (machine.getRecipeLogic().isActive()) {
            for (MonitorGroup group : machine.getMonitorGroups()) {
                ItemStack itemStack = group.getItemStackHandler().getStackInSlot(0);
                Item item = itemStack.m_41720_();
                if (!(item instanceof ComponentItem)) continue;
                ComponentItem item2 = (ComponentItem)item;
                for (IItemComponent component : item2.getComponents()) {
                    if (!(component instanceof IMonitorModuleItem)) continue;
                    IMonitorModuleItem module = (IMonitorModuleItem)component;
                    poseStack.m_85836_();
                    module.getRenderer(group.getItemStackHandler().getStackInSlot(0), machine, group).render(machine, group, partialTick, poseStack, buffer, packedLight, packedOverlay);
                    poseStack.m_85849_();
                }
            }
        }
        poseStack.m_85849_();
    }

    @Override
    public boolean shouldRenderOffScreen(CentralMonitorMachine machine) {
        return true;
    }

    @Override
    public boolean shouldRender(CentralMonitorMachine machine, Vec3 cameraPos) {
        return machine.isFormed();
    }

    @Override
    public AABB getRenderBoundingBox(CentralMonitorMachine machine) {
        BlockPos pos = machine.getPos();
        BoundingBox bounds = new BoundingBox(pos.m_123341_() - 1, pos.m_123342_() - 1, pos.m_123343_() - 1, pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1);
        for (int row = 0; row <= machine.getUpDist() + machine.getDownDist(); ++row) {
            for (int col = 0; col <= machine.getLeftDist() + machine.getRightDist(); ++col) {
                IMonitorComponent component = machine.getComponent(row, col);
                if (component == null || !component.isMonitor()) continue;
                bounds.m_162371_(component.getPos());
            }
        }
        return AABB.m_82321_((BoundingBox)bounds);
    }
}

