/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.gregtechceu.gtceu.utils.GTMatrixUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class RenderBufferHelper {
    public static void renderRing(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float r, float tubeRadius, int sides, int segments, float red, float green, float blue, float alpha, Direction.Axis axis) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float sideDelta = (float)(Math.PI * 2 / (double)sides);
        float ringDelta = (float)(Math.PI * 2 / (double)segments);
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float theta1 = theta + ringDelta;
            float cosTheta1 = Mth.m_14089_((float)theta1);
            float sinTheta1 = Mth.m_14031_((float)theta1);
            float phi = 0.0f;
            block6: for (int j = 0; j <= sides; ++j) {
                float cosPhi = Mth.m_14089_((float)(phi += sideDelta));
                float sinPhi = Mth.m_14031_((float)phi);
                float dist = r + tubeRadius * cosPhi;
                switch (axis) {
                    case Y: {
                        buffer.m_252986_(mat, x + sinTheta * dist, y + tubeRadius * sinPhi, z + cosTheta * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        buffer.m_252986_(mat, x + sinTheta1 * dist, y + tubeRadius * sinPhi, z + cosTheta1 * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        continue block6;
                    }
                    case X: {
                        buffer.m_252986_(mat, x + tubeRadius * sinPhi, y + sinTheta * dist, z + cosTheta * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        buffer.m_252986_(mat, x + tubeRadius * sinPhi, y + sinTheta1 * dist, z + cosTheta1 * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        continue block6;
                    }
                    case Z: {
                        buffer.m_252986_(mat, x + cosTheta * dist, y + sinTheta * dist, z + tubeRadius * sinPhi).m_85950_(red, green, blue, alpha).m_5752_();
                        buffer.m_252986_(mat, x + cosTheta1 * dist, y + sinTheta1 * dist, z + tubeRadius * sinPhi).m_85950_(red, green, blue, alpha).m_5752_();
                    }
                }
            }
            theta = theta1;
            cosTheta = cosTheta1;
            sinTheta = sinTheta1;
        }
    }

    public static void renderCube(VertexConsumer buffer, PoseStack.Pose pose, int color, int combinedLight, TextureAtlasSprite sprite, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        RenderBufferHelper.renderCube(buffer, pose, EnumSet.allOf(Direction.class), color, combinedLight, sprite, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static void renderCube(VertexConsumer buffer, PoseStack.Pose pose, Set<Direction> sidesToRender, int color, int combinedLight, TextureAtlasSprite sprite, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        if (sidesToRender.contains(Direction.UP)) {
            RenderBufferHelper.renderCubeFace(buffer, pose, color, combinedLight, Direction.UP, minX, maxY, minZ, uMin, vMax, minX, maxY, maxZ, uMax, vMax, maxX, maxY, maxZ, uMax, vMin, maxX, maxY, minZ, uMin, vMin);
        }
        if (sidesToRender.contains(Direction.DOWN)) {
            RenderBufferHelper.renderCubeFace(buffer, pose, color, combinedLight, Direction.DOWN, minX, minY, minZ, uMin, vMax, maxX, minY, minZ, uMax, vMax, maxX, minY, maxZ, uMax, vMin, minX, minY, maxZ, uMin, vMin);
        }
        if (sidesToRender.contains(Direction.NORTH)) {
            RenderBufferHelper.renderCubeFace(buffer, pose, color, combinedLight, Direction.NORTH, minX, minY, minZ, uMin, vMax, minX, maxY, minZ, uMax, vMax, maxX, maxY, minZ, uMax, vMin, maxX, minY, minZ, uMin, vMin);
        }
        if (sidesToRender.contains(Direction.SOUTH)) {
            RenderBufferHelper.renderCubeFace(buffer, pose, color, combinedLight, Direction.SOUTH, minX, minY, maxZ, uMin, vMax, maxX, minY, maxZ, uMax, vMax, maxX, maxY, maxZ, uMax, vMin, minX, maxY, maxZ, uMin, vMin);
        }
        if (sidesToRender.contains(Direction.WEST)) {
            RenderBufferHelper.renderCubeFace(buffer, pose, color, combinedLight, Direction.WEST, minX, minY, minZ, uMin, vMax, minX, minY, maxZ, uMax, vMax, minX, maxY, maxZ, uMax, vMin, minX, maxY, minZ, uMin, vMin);
        }
        if (sidesToRender.contains(Direction.EAST)) {
            RenderBufferHelper.renderCubeFace(buffer, pose, color, combinedLight, Direction.EAST, maxX, minY, minZ, uMin, vMax, maxX, maxY, minZ, uMax, vMax, maxX, maxY, maxZ, uMax, vMin, maxX, minY, maxZ, uMin, vMin);
        }
    }

    public static void renderCubeFace(VertexConsumer buffer, PoseStack.Pose pose, int color, int combinedLight, Direction normalDir, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float x4, float y4, float z4, float u4, float v4) {
        Vector3fc normal = GTMatrixUtils.getDirectionAxis(normalDir);
        RenderBufferHelper.vertex(buffer, pose, x1, y1, z1, color, u1, v1, combinedLight, normal.x(), normal.y(), normal.z());
        RenderBufferHelper.vertex(buffer, pose, x2, y2, z2, color, u2, v2, combinedLight, normal.x(), normal.y(), normal.z());
        RenderBufferHelper.vertex(buffer, pose, x3, y3, z3, color, u3, v3, combinedLight, normal.x(), normal.y(), normal.z());
        RenderBufferHelper.vertex(buffer, pose, x4, y4, z4, color, u4, v4, combinedLight, normal.x(), normal.y(), normal.z());
    }

    public static void vertex(VertexConsumer buffer, PoseStack.Pose pose, float x, float y, float z, int color, float texU, float texV, int lightmapUV, float normalX, float normalY, float normalZ) {
        RenderBufferHelper.vertex(buffer, pose, x, y, z, color, texU, texV, OverlayTexture.f_118083_, lightmapUV, normalX, normalY, normalZ);
    }

    public static void vertex(VertexConsumer buffer, PoseStack.Pose pose, float x, float y, float z, int color, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        buffer.m_252986_(pose.m_252922_(), x, y, z);
        buffer.m_193479_(color);
        buffer.m_7421_(texU, texV);
        buffer.m_86008_(overlayUV);
        buffer.m_85969_(lightmapUV);
        buffer.m_252939_(pose.m_252943_(), normalX, normalY, normalZ);
        buffer.m_5752_();
    }
}

