/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.google.common.base.Preconditions;
import com.mojang.math.Transformation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BlockModelRotation;
import org.joml.Quaternionf;

public class VariantRotationHelpers {
    private static final Transformation[] TRANSFORMS = VariantRotationHelpers.createTransformations();

    private static Transformation[] createTransformations() {
        Transformation[] result = new Transformation[64];
        for (int xRot = 0; xRot < 360; xRot += 90) {
            for (int yRot = 0; yRot < 360; yRot += 90) {
                result[VariantRotationHelpers.indexFromAngles((int)xRot, (int)yRot, (int)0)] = BlockModelRotation.m_119153_((int)xRot, (int)yRot).m_6189_();
                for (int zRot = 90; zRot < 360; zRot += 90) {
                    int idx = VariantRotationHelpers.indexFromAngles(xRot, yRot, zRot);
                    Quaternionf quaternion = new Quaternionf().rotateYXZ((float)(-yRot) * ((float)Math.PI / 180), (float)(-xRot) * ((float)Math.PI / 180), (float)(-zRot) * ((float)Math.PI / 180));
                    result[idx] = new Transformation(null, quaternion, null, null);
                }
            }
        }
        return result;
    }

    private VariantRotationHelpers() {
    }

    public static Variant rotateVariant(Variant variant, int xRot, int yRot, int zRot) {
        return new Variant(variant.m_111883_(), VariantRotationHelpers.getRotationTransform(xRot, yRot, zRot), variant.m_7538_(), variant.m_111886_());
    }

    public static Transformation getRotationTransform(int xRot, int yRot, int zRot) {
        return TRANSFORMS[VariantRotationHelpers.indexFromAngles(xRot, yRot, zRot)];
    }

    private static int indexFromAngles(int xRot, int yRot, int zRot) {
        Preconditions.checkArgument((xRot >= 0 && xRot < 360 && xRot % 90 == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((yRot >= 0 && yRot < 360 && yRot % 90 == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((zRot >= 0 && zRot < 360 && zRot % 90 == 0 ? 1 : 0) != 0);
        return xRot / 90 * 16 + yRot / 90 * 4 + zRot / 90;
    }
}

