/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.capability;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketAddHazardZone;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketRemoveHazardZone;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketSyncHazardZoneStrength;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentalHazardSavedData
extends SavedData {
    public static final float MIN_STRENGTH_FOR_SPREAD = 1000.0f;
    private final ServerLevel serverLevel;
    private final Map<ChunkPos, HazardZone> hazardZones = new HashMap<ChunkPos, HazardZone>();

    public static EnvironmentalHazardSavedData getOrCreate(ServerLevel serverLevel) {
        return (EnvironmentalHazardSavedData)serverLevel.m_8895_().m_164861_(tag -> new EnvironmentalHazardSavedData(serverLevel, (CompoundTag)tag), () -> new EnvironmentalHazardSavedData(serverLevel), "gtceu_environmental_hazard_tracker");
    }

    public EnvironmentalHazardSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public EnvironmentalHazardSavedData(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        ListTag allHazardZones = tag.m_128437_("zones", 10);
        for (int i = 0; i < allHazardZones.size(); ++i) {
            CompoundTag zoneTag = allHazardZones.m_128728_(i);
            ChunkPos source = new ChunkPos(zoneTag.m_128454_("pos"));
            HazardZone zone = HazardZone.deserializeNBT(zoneTag);
            this.hazardZones.put(source, zone);
        }
    }

    public void tick() {
        HazardZone zone;
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        HashSet<ChunkPos> zonesToSpread = new HashSet<ChunkPos>();
        HashSet<ChunkPos> zonesToRemove = new HashSet<ChunkPos>();
        for (Map.Entry<ChunkPos, HazardZone> entry : this.hazardZones.entrySet()) {
            zone = entry.getValue();
            Stream<ServerPlayer> playersInZone = this.serverLevel.m_6907_().stream().filter(player -> new ChunkPos(BlockPos.m_274446_((Position)player.m_146892_())).equals(entry.getKey()));
            this.tickPlayerHazards(zone, playersInZone);
            zone = zone.removeStrength(ConfigHolder.INSTANCE.gameplay.environmentalHazardDecayRate);
            if (zone == null) {
                zonesToRemove.add(entry.getKey());
                continue;
            }
            if (!zone.canSpread() || !(zone.strength() > 1000.0f)) continue;
            zonesToSpread.add(entry.getKey());
        }
        for (ChunkPos pos : zonesToRemove) {
            this.hazardZones.remove(pos);
            if (!this.serverLevel.m_7232_(pos.f_45578_, pos.f_45579_)) continue;
            LevelChunk chunk = this.serverLevel.m_6325_(pos.f_45578_, pos.f_45579_);
            GTNetwork.sendToAllPlayersTrackingChunk(chunk, new SPacketRemoveHazardZone(pos));
        }
        for (ChunkPos pos : zonesToSpread) {
            zone = this.hazardZones.get(pos);
            ChunkPos[] relativePositions = new ChunkPos[]{new ChunkPos(pos.f_45578_, pos.f_45579_ - 1), new ChunkPos(pos.f_45578_, pos.f_45579_ + 1), new ChunkPos(pos.f_45578_ - 1, pos.f_45579_), new ChunkPos(pos.f_45578_ + 1, pos.f_45579_)};
            float removedStrength = 0.0f;
            for (ChunkPos relativePos : relativePositions) {
                this.hazardZones.compute(relativePos, (k, v) -> {
                    HazardZone newZone;
                    if (v != null && v.condition() == zone.condition() && v.trigger() == zone.trigger()) {
                        newZone = v.addStrength(20.0f);
                        this.sendSyncZonePacket((ChunkPos)k, newZone);
                    } else {
                        newZone = new HazardZone(k.m_151394_(zone.source().m_123342_()), 20.0f, true, zone.trigger(), zone.condition());
                        this.sendAddZonePacket((ChunkPos)k, newZone);
                    }
                    return newZone;
                });
                removedStrength += 20.0f;
            }
            HazardZone newZone = zone.removeStrength(removedStrength);
            if (newZone == null) {
                this.hazardZones.remove(pos);
                if (this.serverLevel.m_7232_(pos.f_45578_, pos.f_45579_)) {
                    LevelChunk chunk = this.serverLevel.m_6325_(pos.f_45578_, pos.f_45579_);
                    GTNetwork.sendToAllPlayersTrackingChunk(chunk, new SPacketRemoveHazardZone(pos));
                }
            }
            this.m_77762_();
        }
    }

    public void tickPlayerHazards(HazardZone zone, Stream<ServerPlayer> playerStream) {
        playerStream.forEach(player -> {
            if (zone.trigger().protectionType().isProtected((LivingEntity)player)) {
                zone.trigger().protectionType().damageEquipment((Player)player, 1);
                return;
            }
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) {
                return;
            }
            tracker.progressCondition(zone.condition(), zone.strength() / 1000.0f);
        });
    }

    @Nullable
    public HazardZone getZoneByPos(ChunkPos pos) {
        return this.hazardZones.get(pos);
    }

    @Nullable
    public HazardZone getZoneByContainedPos(BlockPos containedPos) {
        return this.getZoneByPos(new ChunkPos(containedPos));
    }

    @Nullable
    public HazardZone getZoneByContainedPosAndCondition(BlockPos containedPos, MedicalCondition condition) {
        HazardZone zone = this.hazardZones.get(new ChunkPos(containedPos));
        return zone != null && zone.condition == condition ? zone : null;
    }

    public void removeZone(BlockPos inChunkPos) {
        this.removeZone(new ChunkPos(inChunkPos));
    }

    public void removeZone(BlockPos inChunkPos, MedicalCondition condition) {
        ChunkPos chunkPos = new ChunkPos(inChunkPos);
        if (this.hazardZones.get(chunkPos).condition() == condition) {
            this.removeZone(chunkPos);
        }
    }

    public void removeZone(ChunkPos chunkPos) {
        this.hazardZones.remove(chunkPos);
        if (this.serverLevel.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            LevelChunk chunk = this.serverLevel.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            GTNetwork.sendToAllPlayersTrackingChunk(chunk, new SPacketRemoveHazardZone(chunkPos));
        }
    }

    public void addZone(ChunkPos source, HazardZone zone) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        HazardZone existing = this.hazardZones.get(source);
        if (existing != null && existing.condition == zone.condition) {
            existing.addStrength(zone.strength());
            this.sendSyncZonePacket(source, existing);
        } else if (!this.hazardZones.containsKey(source)) {
            this.hazardZones.put(source, zone);
            this.sendAddZonePacket(source, zone);
        }
        this.m_77762_();
    }

    public void addZone(BlockPos source, float strength, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        this.addZone(new ChunkPos(source), new HazardZone(source, strength, canSpread, trigger, condition));
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        ListTag hazardZonesTag = new ListTag();
        for (Map.Entry<ChunkPos, HazardZone> entry : this.hazardZones.entrySet()) {
            CompoundTag zoneTag = new CompoundTag();
            zoneTag.m_128356_("pos", entry.getKey().m_45588_());
            entry.getValue().serializeNBT(zoneTag);
            hazardZonesTag.add((Object)zoneTag);
        }
        compoundTag.m_128365_("zones", (Tag)hazardZonesTag);
        return compoundTag;
    }

    public void sendAddZonePacket(ChunkPos pos, HazardZone zone) {
        if (this.serverLevel.m_7232_(pos.f_45578_, pos.f_45579_)) {
            LevelChunk chunk = this.serverLevel.m_6325_(pos.f_45578_, pos.f_45579_);
            GTNetwork.sendToAllPlayersTrackingChunk(chunk, new SPacketAddHazardZone(pos, zone));
        }
    }

    public void sendSyncZonePacket(ChunkPos pos, HazardZone zone) {
        if (this.serverLevel.m_7232_(pos.f_45578_, pos.f_45579_)) {
            LevelChunk chunk = this.serverLevel.m_6325_(pos.f_45578_, pos.f_45579_);
            GTNetwork.sendToAllPlayersTrackingChunk(chunk, new SPacketSyncHazardZoneStrength(pos, zone.strength()));
        }
    }

    @Generated
    public Map<ChunkPos, HazardZone> getHazardZones() {
        return this.hazardZones;
    }

    public static class HazardZone {
        private final BlockPos source;
        private float strength;
        private final boolean canSpread;
        private final HazardProperty.HazardTrigger trigger;
        private final MedicalCondition condition;

        public HazardZone addStrength(float toAdd) {
            this.strength += toAdd;
            return this;
        }

        public HazardZone removeStrength(float toRemove) {
            this.strength -= toRemove;
            if (this.strength <= 0.0f) {
                return null;
            }
            return this;
        }

        public CompoundTag serializeNBT(CompoundTag zoneTag) {
            zoneTag.m_128365_("source", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
            zoneTag.m_128350_("strength", this.strength);
            zoneTag.m_128379_("can_spread", this.canSpread);
            zoneTag.m_128359_("trigger", this.trigger.name());
            zoneTag.m_128359_("condition", this.condition.name);
            return zoneTag;
        }

        public static HazardZone deserializeNBT(CompoundTag zoneTag) {
            BlockPos source = NbtUtils.m_129239_((CompoundTag)zoneTag.m_128469_("source"));
            float strength = zoneTag.m_128457_("strength");
            boolean canSpread = zoneTag.m_128471_("can_spread");
            HazardProperty.HazardTrigger trigger = HazardProperty.HazardTrigger.ALL_TRIGGERS.get(zoneTag.m_128461_("trigger"));
            MedicalCondition condition = MedicalCondition.CONDITIONS.get(zoneTag.m_128461_("condition"));
            return new HazardZone(source, strength, canSpread, trigger, condition);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130064_(this.source);
            buf.writeFloat(this.strength);
            buf.writeBoolean(this.canSpread);
            buf.m_130070_(this.trigger.name());
            buf.m_130070_(this.condition.name);
        }

        public static HazardZone fromNetwork(FriendlyByteBuf buf) {
            BlockPos source = buf.m_130135_();
            float strength = buf.readFloat();
            boolean canSpread = buf.readBoolean();
            HazardProperty.HazardTrigger trigger = HazardProperty.HazardTrigger.ALL_TRIGGERS.get(buf.m_130277_());
            MedicalCondition condition = MedicalCondition.CONDITIONS.get(buf.m_130277_());
            return new HazardZone(source, strength, canSpread, trigger, condition);
        }

        @Generated
        public HazardZone(BlockPos source, float strength, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
            this.source = source;
            this.strength = strength;
            this.canSpread = canSpread;
            this.trigger = trigger;
            this.condition = condition;
        }

        @Generated
        public BlockPos source() {
            return this.source;
        }

        @Generated
        public float strength() {
            return this.strength;
        }

        @NotNull
        @Generated
        public HazardZone strength(float strength) {
            this.strength = strength;
            return this;
        }

        @Generated
        public boolean canSpread() {
            return this.canSpread;
        }

        @Generated
        public HazardProperty.HazardTrigger trigger() {
            return this.trigger;
        }

        @Generated
        public MedicalCondition condition() {
            return this.condition;
        }
    }
}

