/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CoverSolarPanel
extends CoverBehavior {
    private final long EUt;
    protected TickableSubscription subscription;

    public CoverSolarPanel(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        this.EUt = 1L;
    }

    public CoverSolarPanel(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        super(definition, coverHolder, attachedSide);
        this.EUt = GTValues.V[tier];
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscription = this.coverHolder.subscribeServerTick(this.subscription, this::update);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    @Override
    public boolean canAttach() {
        return super.canAttach() && this.attachedSide == Direction.UP && this.getEnergyContainer() != null;
    }

    protected void update() {
        IEnergyContainer energyContainer;
        BlockPos blockPos;
        Level level = this.coverHolder.getLevel();
        if (GTUtil.canSeeSunClearly(level, blockPos = this.coverHolder.getPos()) && (energyContainer = this.getEnergyContainer()) != null) {
            energyContainer.acceptEnergyFromNetwork(null, this.EUt, 1L);
        }
    }

    @Nullable
    protected IEnergyContainer getEnergyContainer() {
        return GTCapabilityHelper.getEnergyContainer(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide);
    }
}

