/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ActivityDetectorCover
extends DetectorCover {
    public ActivityDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return super.canAttach() && GTCapabilityHelper.getWorkable(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide) != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IWorkable workable = GTCapabilityHelper.getWorkable(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide);
        boolean isCurrentlyWorking = workable.isActive() && workable.isWorkingEnabled();
        this.setRedstoneSignalOutput(isCurrentlyWorking != this.isInverted() ? 15 : 0);
    }
}

