/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.client.renderer.cover.FacadeCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.IOCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.SimpleCoverRenderer;
import com.gregtechceu.gtceu.common.cover.ComputerMonitorCover;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.CoverSolarPanel;
import com.gregtechceu.gtceu.common.cover.FacadeCover;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.FluidRegulatorCover;
import com.gregtechceu.gtceu.common.cover.InfiniteWaterCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.MachineControllerCover;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.gregtechceu.gtceu.common.cover.ShutterCover;
import com.gregtechceu.gtceu.common.cover.StorageCover;
import com.gregtechceu.gtceu.common.cover.WirelessTransmitterCover;
import com.gregtechceu.gtceu.common.cover.detector.ActivityDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedActivityDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedEnergyDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedFluidDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedItemDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.EnergyDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.FluidDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.ItemDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.MaintenanceDetectorCover;
import com.gregtechceu.gtceu.common.cover.ender.EnderFluidLinkCover;
import com.gregtechceu.gtceu.common.cover.ender.EnderItemLinkCover;
import com.gregtechceu.gtceu.common.cover.ender.EnderRedstoneLinkCover;
import com.gregtechceu.gtceu.common.cover.voiding.AdvancedFluidVoidingCover;
import com.gregtechceu.gtceu.common.cover.voiding.AdvancedItemVoidingCover;
import com.gregtechceu.gtceu.common.cover.voiding.FluidVoidingCover;
import com.gregtechceu.gtceu.common.cover.voiding.ItemVoidingCover;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModLoader;

public class GTCovers {
    public static final int[] ALL_TIERS = GTValues.tiersBetween(1, GTCEuAPI.isHighTier() ? 13 : 8);
    public static final int[] ALL_TIERS_WITH_ULV = GTValues.tiersBetween(0, GTCEuAPI.isHighTier() ? 13 : 8);
    public static final CoverDefinition FACADE;
    public static final CoverDefinition ITEM_FILTER;
    public static final CoverDefinition FLUID_FILTER;
    public static final CoverDefinition INFINITE_WATER;
    public static final CoverDefinition ENDER_FLUID_LINK;
    public static final CoverDefinition ENDER_ITEM_LINK;
    public static final CoverDefinition ENDER_REDSTONE_LINK;
    public static final CoverDefinition SHUTTER;
    public static final CoverDefinition COVER_STORAGE;
    public static final CoverDefinition[] CONVEYORS;
    public static final CoverDefinition[] ROBOT_ARMS;
    public static final CoverDefinition[] PUMPS;
    public static final CoverDefinition[] FLUID_REGULATORS;
    public static final CoverDefinition COMPUTER_MONITOR;
    public static final CoverDefinition MACHINE_CONTROLLER;
    public static final CoverDefinition WIRELESS_TRANSMITTER;
    public static final CoverDefinition ITEM_VOIDING;
    public static final CoverDefinition ITEM_VOIDING_ADVANCED;
    public static final CoverDefinition FLUID_VOIDING;
    public static final CoverDefinition FLUID_VOIDING_ADVANCED;
    public static final CoverDefinition ACTIVITY_DETECTOR;
    public static final CoverDefinition ACTIVITY_DETECTOR_ADVANCED;
    public static final CoverDefinition FLUID_DETECTOR;
    public static final CoverDefinition FLUID_DETECTOR_ADVANCED;
    public static final CoverDefinition ITEM_DETECTOR;
    public static final CoverDefinition ITEM_DETECTOR_ADVANCED;
    public static final CoverDefinition ENERGY_DETECTOR;
    public static final CoverDefinition ENERGY_DETECTOR_ADVANCED;
    public static final CoverDefinition MAINTENANCE_DETECTOR;
    public static final CoverDefinition SOLAR_PANEL_BASIC;
    public static final CoverDefinition[] SOLAR_PANEL;

    private static CoverDefinition register(String id, CoverDefinition.CoverBehaviourProvider behaviorCreator) {
        return GTCovers.register(id, behaviorCreator, () -> () -> new SimpleCoverRenderer(GTCEu.id("block/cover/" + id)));
    }

    private static CoverDefinition register(String id, CoverDefinition.CoverBehaviourProvider behaviorCreator, Supplier<Supplier<ICoverRenderer>> coverRenderer) {
        return GTCovers.register(GTCEu.id(id), behaviorCreator, coverRenderer);
    }

    public static CoverDefinition register(ResourceLocation id, CoverDefinition.CoverBehaviourProvider behaviorCreator, Supplier<Supplier<ICoverRenderer>> coverRenderer) {
        CoverDefinition definition = new CoverDefinition(id, behaviorCreator, coverRenderer);
        GTRegistries.COVERS.register(definition.getId(), definition);
        return definition;
    }

    private static CoverDefinition[] registerTiered(String id, CoverDefinition.TieredCoverBehaviourProvider behaviorCreator, Supplier<Int2ObjectFunction<ICoverRenderer>> coverRenderer, int ... tiers) {
        return (CoverDefinition[])Arrays.stream(tiers).mapToObj(tier -> {
            String name = id + "." + GTValues.VN[tier].toLowerCase(Locale.ROOT);
            return GTCovers.register(name, (CoverDefinition def, ICoverable coverable, Direction side) -> behaviorCreator.create(def, coverable, side, tier), () -> GTCovers.lambda$registerTiered$18((Supplier)coverRenderer, tier));
        }).toArray(CoverDefinition[]::new);
    }

    private static CoverDefinition[] registerTiered(String id, CoverDefinition.TieredCoverBehaviourProvider behaviorCreator, int ... tiers) {
        return (CoverDefinition[])Arrays.stream(tiers).mapToObj(tier -> {
            String name = id + "." + GTValues.VN[tier].toLowerCase(Locale.ROOT);
            return GTCovers.register(name, (def, coverable, side) -> behaviorCreator.create(def, coverable, side, tier));
        }).toArray(CoverDefinition[]::new);
    }

    public static void init() {
        AddonFinder.getAddons().forEach(IGTAddon::registerCovers);
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.COVERS, CoverDefinition.class));
        GTRegistries.COVERS.freeze();
    }

    private static /* synthetic */ Supplier lambda$registerTiered$18(Supplier coverRenderer, int tier) {
        return () -> GTCovers.lambda$registerTiered$17((Supplier)coverRenderer, tier);
    }

    private static /* synthetic */ ICoverRenderer lambda$registerTiered$17(Supplier coverRenderer, int tier) {
        return (ICoverRenderer)((Int2ObjectFunction)coverRenderer.get()).apply(tier);
    }

    static {
        GTRegistries.COVERS.unfreeze();
        FACADE = GTCovers.register("facade", FacadeCover::new, () -> () -> FacadeCoverRenderer.INSTANCE);
        ITEM_FILTER = GTCovers.register("item_filter", ItemFilterCover::new);
        FLUID_FILTER = GTCovers.register("fluid_filter", FluidFilterCover::new);
        INFINITE_WATER = GTCovers.register("infinite_water", InfiniteWaterCover::new);
        ENDER_FLUID_LINK = GTCovers.register("ender_fluid_link", EnderFluidLinkCover::new);
        ENDER_ITEM_LINK = GTCovers.register("ender_item_link", EnderItemLinkCover::new);
        ENDER_REDSTONE_LINK = GTCovers.register("ender_redstone_link", EnderRedstoneLinkCover::new);
        SHUTTER = GTCovers.register("shutter", ShutterCover::new);
        COVER_STORAGE = GTCovers.register("storage", StorageCover::new);
        CONVEYORS = GTCovers.registerTiered("conveyor", ConveyorCover::new, () -> tier -> new IOCoverRenderer(GTCEu.id("block/cover/conveyor"), null, GTCEu.id("block/cover/conveyor_emissive"), GTCEu.id("block/cover/conveyor_inverted_emissive")), ALL_TIERS);
        ROBOT_ARMS = GTCovers.registerTiered("robot_arm", RobotArmCover::new, () -> tier -> new IOCoverRenderer(GTCEu.id("block/cover/arm"), null, GTCEu.id("block/cover/arm_emissive"), GTCEu.id("block/cover/arm_inverted_emissive")), ALL_TIERS);
        PUMPS = GTCovers.registerTiered("pump", PumpCover::new, () -> tier -> IOCoverRenderer.PUMP_LIKE_COVER_RENDERER, ALL_TIERS);
        FLUID_REGULATORS = GTCovers.registerTiered("fluid_regulator", FluidRegulatorCover::new, () -> tier -> IOCoverRenderer.PUMP_LIKE_COVER_RENDERER, ALL_TIERS);
        COMPUTER_MONITOR = GTCovers.register("computer_monitor", ComputerMonitorCover::new);
        MACHINE_CONTROLLER = GTCovers.register("machine_controller", MachineControllerCover::new);
        WIRELESS_TRANSMITTER = GTCovers.register("wireless_transmitter", WirelessTransmitterCover::new, () -> () -> new SimpleCoverRenderer(GTCEu.id("block/cover/wireless_transmitter")));
        ITEM_VOIDING = GTCovers.register("item_voiding", ItemVoidingCover::new);
        ITEM_VOIDING_ADVANCED = GTCovers.register("item_voiding_advanced", AdvancedItemVoidingCover::new);
        FLUID_VOIDING = GTCovers.register("fluid_voiding", FluidVoidingCover::new);
        FLUID_VOIDING_ADVANCED = GTCovers.register("fluid_voiding_advanced", AdvancedFluidVoidingCover::new);
        ACTIVITY_DETECTOR = GTCovers.register("activity_detector", ActivityDetectorCover::new);
        ACTIVITY_DETECTOR_ADVANCED = GTCovers.register("activity_detector_advanced", AdvancedActivityDetectorCover::new);
        FLUID_DETECTOR = GTCovers.register("fluid_detector", FluidDetectorCover::new);
        FLUID_DETECTOR_ADVANCED = GTCovers.register("fluid_detector_advanced", AdvancedFluidDetectorCover::new);
        ITEM_DETECTOR = GTCovers.register("item_detector", ItemDetectorCover::new);
        ITEM_DETECTOR_ADVANCED = GTCovers.register("item_detector_advanced", AdvancedItemDetectorCover::new);
        ENERGY_DETECTOR = GTCovers.register("energy_detector", EnergyDetectorCover::new);
        ENERGY_DETECTOR_ADVANCED = GTCovers.register("energy_detector_advanced", AdvancedEnergyDetectorCover::new);
        MAINTENANCE_DETECTOR = GTCovers.register("maintenance_detector", MaintenanceDetectorCover::new);
        SOLAR_PANEL_BASIC = GTCovers.register("solar_panel", CoverSolarPanel::new);
        SOLAR_PANEL = GTCovers.registerTiered("solar_panel", CoverSolarPanel::new, () -> tier -> new SimpleCoverRenderer(GTCEu.id("block/cover/solar_panel")), ALL_TIERS_WITH_ULV);
    }
}

