/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.cover.filter.SimpleFluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SmartItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagFluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagItemFilter;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gregtechceu.gtceu.api.item.component.FilteredFluidContainer;
import com.gregtechceu.gtceu.api.item.component.FoodStats;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMaterialPartItem;
import com.gregtechceu.gtceu.api.item.component.ThermalFluidStats;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.common.data.GTCovers;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.data.materials.GTFoods;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import com.gregtechceu.gtceu.common.entity.GTBoat;
import com.gregtechceu.gtceu.common.item.AntidoteBehavior;
import com.gregtechceu.gtceu.common.item.ColorSprayBehaviour;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.common.item.DataItemBehavior;
import com.gregtechceu.gtceu.common.item.DynamiteBehaviour;
import com.gregtechceu.gtceu.common.item.FacadeItemBehaviour;
import com.gregtechceu.gtceu.common.item.FertilizerBehavior;
import com.gregtechceu.gtceu.common.item.FluidFilterBehaviour;
import com.gregtechceu.gtceu.common.item.GTBoatItem;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.common.item.ItemFilterBehaviour;
import com.gregtechceu.gtceu.common.item.ItemFluidContainer;
import com.gregtechceu.gtceu.common.item.ItemMagnetBehavior;
import com.gregtechceu.gtceu.common.item.NanoSaberBehavior;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.item.ProspectorScannerBehavior;
import com.gregtechceu.gtceu.common.item.TapeBehaviour;
import com.gregtechceu.gtceu.common.item.TerminalBehavior;
import com.gregtechceu.gtceu.common.item.TooltipBehavior;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.common.item.armor.AdvancedJetpack;
import com.gregtechceu.gtceu.common.item.armor.AdvancedNanoMuscleSuite;
import com.gregtechceu.gtceu.common.item.armor.AdvancedQuarkTechSuite;
import com.gregtechceu.gtceu.common.item.armor.GTArmorMaterials;
import com.gregtechceu.gtceu.common.item.armor.HazmatSuit;
import com.gregtechceu.gtceu.common.item.armor.Jetpack;
import com.gregtechceu.gtceu.common.item.armor.NanoMuscleSuite;
import com.gregtechceu.gtceu.common.item.armor.NightvisionGoggles;
import com.gregtechceu.gtceu.common.item.armor.PowerlessJetpack;
import com.gregtechceu.gtceu.common.item.armor.QuarkTechSuite;
import com.gregtechceu.gtceu.common.item.modules.ImageModuleBehaviour;
import com.gregtechceu.gtceu.common.item.modules.TextModuleBehaviour;
import com.gregtechceu.gtceu.common.item.tool.behavior.LighterBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.MetaMachineConfigCopyBehaviour;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GTItems {
    public static ItemEntry<Item> COMPRESSED_CLAY;
    public static ItemEntry<Item> COMPRESSED_COKE_CLAY;
    public static ItemEntry<Item> COMPRESSED_FIRECLAY;
    public static ItemEntry<Item> FIRECLAY_BRICK;
    public static ItemEntry<Item> COKE_OVEN_BRICK;
    public static ItemEntry<Item> WOODEN_FORM_EMPTY;
    public static ItemEntry<ComponentItem> WOODEN_FORM_BRICK;
    public static ItemEntry<Item> SHAPE_EMPTY;
    public static final ItemEntry<Item>[] SHAPE_MOLDS;
    public static final ItemEntry<Item> SHAPE_MOLD_PLATE;
    public static final ItemEntry<Item> SHAPE_MOLD_GEAR;
    public static final ItemEntry<Item> SHAPE_MOLD_BOTTLE;
    public static final ItemEntry<Item> SHAPE_MOLD_INGOT;
    public static final ItemEntry<Item> SHAPE_MOLD_BALL;
    public static final ItemEntry<Item> SHAPE_MOLD_BLOCK;
    public static final ItemEntry<Item> SHAPE_MOLD_NUGGET;
    public static final ItemEntry<Item> SHAPE_MOLD_CYLINDER;
    public static final ItemEntry<Item> SHAPE_MOLD_ANVIL;
    public static final ItemEntry<Item> SHAPE_MOLD_NAME;
    public static final ItemEntry<Item> SHAPE_MOLD_GEAR_SMALL;
    public static final ItemEntry<Item> SHAPE_MOLD_ROTOR;
    public static final ItemEntry<Item> SHAPE_MOLD_PILL;
    public static final ItemEntry<Item> SHAPE_MOLD_TINY_PIPE;
    public static final ItemEntry<Item> SHAPE_MOLD_SMALL_PIPE;
    public static final ItemEntry<Item> SHAPE_MOLD_NORMAL_PIPE;
    public static final ItemEntry<Item> SHAPE_MOLD_LARGE_PIPE;
    public static final ItemEntry<Item> SHAPE_MOLD_HUGE_PIPE;
    public static final ItemEntry<Item>[] SHAPE_EXTRUDERS;
    public static ItemEntry<Item> SHAPE_EXTRUDER_PLATE;
    public static ItemEntry<Item> SHAPE_EXTRUDER_ROD;
    public static ItemEntry<Item> SHAPE_EXTRUDER_BOLT;
    public static ItemEntry<Item> SHAPE_EXTRUDER_RING;
    public static ItemEntry<Item> SHAPE_EXTRUDER_CELL;
    public static ItemEntry<Item> SHAPE_EXTRUDER_INGOT;
    public static ItemEntry<Item> SHAPE_EXTRUDER_WIRE;
    public static ItemEntry<Item> SHAPE_EXTRUDER_PIPE_TINY;
    public static ItemEntry<Item> SHAPE_EXTRUDER_PIPE_SMALL;
    public static ItemEntry<Item> SHAPE_EXTRUDER_PIPE_NORMAL;
    public static ItemEntry<Item> SHAPE_EXTRUDER_PIPE_LARGE;
    public static ItemEntry<Item> SHAPE_EXTRUDER_PIPE_HUGE;
    public static ItemEntry<Item> SHAPE_EXTRUDER_BLOCK;
    public static ItemEntry<Item> SHAPE_EXTRUDER_GEAR;
    public static ItemEntry<Item> SHAPE_EXTRUDER_BOTTLE;
    public static ItemEntry<Item> SHAPE_EXTRUDER_FOIL;
    public static ItemEntry<Item> SHAPE_EXTRUDER_GEAR_SMALL;
    public static ItemEntry<Item> SHAPE_EXTRUDER_ROTOR;
    public static ItemEntry<Item> SPRAY_EMPTY;
    public static ItemEntry<ComponentItem> SPRAY_SOLVENT;
    public static ItemEntry<ComponentItem> PORTABLE_SCANNER;
    public static ItemEntry<ComponentItem> PORTABLE_DEBUG_SCANNER;
    public static ItemEntry<ComponentItem> FLUID_CELL;
    public static ItemEntry<ComponentItem> FLUID_CELL_UNIVERSAL;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_STEEL;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_ALUMINIUM;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_STAINLESS_STEEL;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_TITANIUM;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_TUNGSTEN_STEEL;
    public static ItemEntry<ComponentItem> FLUID_CELL_GLASS_VIAL;
    public static ItemEntry<ComponentItem> TOOL_MATCHES;
    public static ItemEntry<ComponentItem> TOOL_MATCHBOX;
    public static ItemEntry<ComponentItem> TOOL_LIGHTER_INVAR;
    public static ItemEntry<ComponentItem> TOOL_LIGHTER_PLATINUM;
    public static ItemEntry<Item> CARBON_FIBERS;
    public static ItemEntry<Item> CARBON_MESH;
    public static ItemEntry<Item> CARBON_FIBER_PLATE;
    public static ItemEntry<ComponentItem> DUCT_TAPE;
    public static ItemEntry<ComponentItem> BASIC_TAPE;
    public static ItemEntry<Item> NEUTRON_REFLECTOR;
    public static ItemEntry<Item> BATTERY_HULL_LV;
    public static ItemEntry<Item> BATTERY_HULL_MV;
    public static ItemEntry<Item> BATTERY_HULL_HV;
    public static ItemEntry<Item> BATTERY_HULL_SMALL_VANADIUM;
    public static ItemEntry<Item> BATTERY_HULL_MEDIUM_VANADIUM;
    public static ItemEntry<Item> BATTERY_HULL_LARGE_VANADIUM;
    public static ItemEntry<Item> BATTERY_HULL_MEDIUM_NAQUADRIA;
    public static ItemEntry<Item> BATTERY_HULL_LARGE_NAQUADRIA;
    public static ItemEntry<ComponentItem> BATTERY_ULV_TANTALUM;
    public static ItemEntry<ComponentItem> BATTERY_LV_SODIUM;
    public static ItemEntry<ComponentItem> BATTERY_MV_SODIUM;
    public static ItemEntry<ComponentItem> BATTERY_HV_SODIUM;
    public static ItemEntry<ComponentItem> BATTERY_LV_LITHIUM;
    public static ItemEntry<ComponentItem> BATTERY_MV_LITHIUM;
    public static ItemEntry<ComponentItem> BATTERY_HV_LITHIUM;
    public static ItemEntry<ComponentItem> BATTERY_LV_CADMIUM;
    public static ItemEntry<ComponentItem> BATTERY_MV_CADMIUM;
    public static ItemEntry<ComponentItem> BATTERY_HV_CADMIUM;
    public static ItemEntry<ComponentItem> ENERGIUM_CRYSTAL;
    public static ItemEntry<ComponentItem> LAPOTRON_CRYSTAL;
    public static ItemEntry<ComponentItem> BATTERY_EV_VANADIUM;
    public static ItemEntry<ComponentItem> BATTERY_IV_VANADIUM;
    public static ItemEntry<ComponentItem> BATTERY_LuV_VANADIUM;
    public static ItemEntry<ComponentItem> BATTERY_ZPM_NAQUADRIA;
    public static ItemEntry<ComponentItem> BATTERY_UV_NAQUADRIA;
    public static ItemEntry<ComponentItem> ENERGY_LAPOTRONIC_ORB;
    public static ItemEntry<ComponentItem> ENERGY_LAPOTRONIC_ORB_CLUSTER;
    public static ItemEntry<ComponentItem> ENERGY_MODULE;
    public static ItemEntry<ComponentItem> ENERGY_CLUSTER;
    public static ItemEntry<ComponentItem> ZERO_POINT_MODULE;
    public static ItemEntry<ComponentItem> ULTIMATE_BATTERY;
    public static ItemEntry<Item> ELECTRIC_MOTOR_LV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_MV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_HV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_EV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_IV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_LuV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_ZPM;
    public static ItemEntry<Item> ELECTRIC_MOTOR_UV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_UHV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_UEV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_UIV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_UXV;
    public static ItemEntry<Item> ELECTRIC_MOTOR_OpV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_LV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_MV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_HV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_EV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_IV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_LuV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_ZPM;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UHV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UEV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UIV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UXV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_OpV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_LV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_MV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_HV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_EV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_IV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_LuV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_ZPM;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UHV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UEV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UIV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UXV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_OpV;
    public static ItemEntry<ComponentItem> DYNAMITE;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_LV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_MV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_HV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_EV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_IV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_LuV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_ZPM;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UHV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UEV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UIV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UXV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_OpV;
    public static ItemEntry<Item> ELECTRIC_PISTON_LV;
    public static ItemEntry<Item> ELECTRIC_PISTON_MV;
    public static ItemEntry<Item> ELECTRIC_PISTON_HV;
    public static ItemEntry<Item> ELECTRIC_PISTON_EV;
    public static ItemEntry<Item> ELECTRIC_PISTON_IV;
    public static ItemEntry<Item> ELECTRIC_PISTON_LuV;
    public static ItemEntry<Item> ELECTRIC_PISTON_ZPM;
    public static ItemEntry<Item> ELECTRIC_PISTON_UV;
    public static ItemEntry<Item> ELECTRIC_PISTON_UHV;
    public static ItemEntry<Item> ELECTRIC_PISTON_UEV;
    public static ItemEntry<Item> ELECTRIC_PISTON_UIV;
    public static ItemEntry<Item> ELECTRIC_PISTON_UXV;
    public static ItemEntry<Item> ELECTRIC_PISTON_OpV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_LV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_MV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_HV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_EV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_IV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_LuV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_ZPM;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UHV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UEV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UIV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UXV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_OpV;
    public static ItemEntry<Item> FIELD_GENERATOR_LV;
    public static ItemEntry<Item> FIELD_GENERATOR_MV;
    public static ItemEntry<Item> FIELD_GENERATOR_HV;
    public static ItemEntry<Item> FIELD_GENERATOR_EV;
    public static ItemEntry<Item> FIELD_GENERATOR_IV;
    public static ItemEntry<Item> FIELD_GENERATOR_LuV;
    public static ItemEntry<Item> FIELD_GENERATOR_ZPM;
    public static ItemEntry<Item> FIELD_GENERATOR_UV;
    public static ItemEntry<Item> FIELD_GENERATOR_UHV;
    public static ItemEntry<Item> FIELD_GENERATOR_UEV;
    public static ItemEntry<Item> FIELD_GENERATOR_UIV;
    public static ItemEntry<Item> FIELD_GENERATOR_UXV;
    public static ItemEntry<Item> FIELD_GENERATOR_OpV;
    public static ItemEntry<Item> EMITTER_LV;
    public static ItemEntry<Item> EMITTER_MV;
    public static ItemEntry<Item> EMITTER_HV;
    public static ItemEntry<Item> EMITTER_EV;
    public static ItemEntry<Item> EMITTER_IV;
    public static ItemEntry<Item> EMITTER_LuV;
    public static ItemEntry<Item> EMITTER_ZPM;
    public static ItemEntry<Item> EMITTER_UV;
    public static ItemEntry<Item> EMITTER_UHV;
    public static ItemEntry<Item> EMITTER_UEV;
    public static ItemEntry<Item> EMITTER_UIV;
    public static ItemEntry<Item> EMITTER_UXV;
    public static ItemEntry<Item> EMITTER_OpV;
    public static ItemEntry<Item> SENSOR_LV;
    public static ItemEntry<Item> SENSOR_MV;
    public static ItemEntry<Item> SENSOR_HV;
    public static ItemEntry<Item> SENSOR_EV;
    public static ItemEntry<Item> SENSOR_IV;
    public static ItemEntry<Item> SENSOR_LuV;
    public static ItemEntry<Item> SENSOR_ZPM;
    public static ItemEntry<Item> SENSOR_UV;
    public static ItemEntry<Item> SENSOR_UHV;
    public static ItemEntry<Item> SENSOR_UEV;
    public static ItemEntry<Item> SENSOR_UIV;
    public static ItemEntry<Item> SENSOR_UXV;
    public static ItemEntry<Item> SENSOR_OpV;
    public static ItemEntry<ComponentItem> TOOL_DATA_STICK;
    public static ItemEntry<ComponentItem> TOOL_DATA_ORB;
    public static ItemEntry<ComponentItem> TOOL_DATA_MODULE;
    public static final Map<MarkerMaterial, ItemEntry<Item>> GLASS_LENSES;
    public static ItemEntry<Item> SILICON_BOULE;
    public static ItemEntry<Item> PHOSPHORUS_BOULE;
    public static ItemEntry<Item> NAQUADAH_BOULE;
    public static ItemEntry<Item> NEUTRONIUM_BOULE;
    public static ItemEntry<Item> SILICON_WAFER;
    public static ItemEntry<Item> PHOSPHORUS_WAFER;
    public static ItemEntry<Item> NAQUADAH_WAFER;
    public static ItemEntry<Item> NEUTRONIUM_WAFER;
    public static ItemEntry<Item> CENTRAL_PROCESSING_UNIT_WAFER;
    public static ItemEntry<Item> RANDOM_ACCESS_MEMORY_WAFER;
    public static ItemEntry<Item> INTEGRATED_LOGIC_CIRCUIT_WAFER;
    public static ItemEntry<Item> NANO_CENTRAL_PROCESSING_UNIT_WAFER;
    public static ItemEntry<Item> QUBIT_CENTRAL_PROCESSING_UNIT_WAFER;
    public static ItemEntry<Item> SIMPLE_SYSTEM_ON_CHIP_WAFER;
    public static ItemEntry<Item> SYSTEM_ON_CHIP_WAFER;
    public static ItemEntry<Item> ADVANCED_SYSTEM_ON_CHIP_WAFER;
    public static ItemEntry<Item> HIGHLY_ADVANCED_SOC_WAFER;
    public static ItemEntry<Item> NAND_MEMORY_CHIP_WAFER;
    public static ItemEntry<Item> NOR_MEMORY_CHIP_WAFER;
    public static ItemEntry<Item> ULTRA_LOW_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<Item> LOW_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<Item> POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<Item> HIGH_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<Item> ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<Item> ENGRAVED_CRYSTAL_CHIP;
    public static ItemEntry<Item> ENGRAVED_LAPOTRON_CHIP;
    public static ItemEntry<Item> CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<Item> RANDOM_ACCESS_MEMORY;
    public static ItemEntry<Item> INTEGRATED_LOGIC_CIRCUIT;
    public static ItemEntry<Item> NANO_CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<Item> QUBIT_CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<Item> SIMPLE_SYSTEM_ON_CHIP;
    public static ItemEntry<Item> SYSTEM_ON_CHIP;
    public static ItemEntry<Item> ADVANCED_SYSTEM_ON_CHIP;
    public static ItemEntry<Item> HIGHLY_ADVANCED_SOC;
    public static ItemEntry<Item> NAND_MEMORY_CHIP;
    public static ItemEntry<Item> NOR_MEMORY_CHIP;
    public static ItemEntry<Item> ULTRA_LOW_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<Item> LOW_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<Item> POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<Item> HIGH_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<Item> ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<Item> RAW_CRYSTAL_CHIP;
    public static ItemEntry<Item> RAW_CRYSTAL_CHIP_PART;
    public static ItemEntry<Item> CRYSTAL_CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<Item> CRYSTAL_SYSTEM_ON_CHIP;
    public static ItemEntry<Item> COATED_BOARD;
    public static ItemEntry<Item> PHENOLIC_BOARD;
    public static ItemEntry<Item> PLASTIC_BOARD;
    public static ItemEntry<Item> EPOXY_BOARD;
    public static ItemEntry<Item> FIBER_BOARD;
    public static ItemEntry<Item> MULTILAYER_FIBER_BOARD;
    public static ItemEntry<Item> WETWARE_BOARD;
    public static ItemEntry<Item> BASIC_CIRCUIT_BOARD;
    public static ItemEntry<Item> GOOD_CIRCUIT_BOARD;
    public static ItemEntry<Item> PLASTIC_CIRCUIT_BOARD;
    public static ItemEntry<Item> ADVANCED_CIRCUIT_BOARD;
    public static ItemEntry<Item> EXTREME_CIRCUIT_BOARD;
    public static ItemEntry<Item> ELITE_CIRCUIT_BOARD;
    public static ItemEntry<Item> WETWARE_CIRCUIT_BOARD;
    public static ItemEntry<Item> VACUUM_TUBE;
    public static ItemEntry<Item> GLASS_TUBE;
    public static ItemEntry<Item> TRANSISTOR;
    public static ItemEntry<Item> RESISTOR;
    public static ItemEntry<Item> CAPACITOR;
    public static ItemEntry<Item> DIODE;
    public static ItemEntry<Item> INDUCTOR;
    public static ItemEntry<Item> SMD_TRANSISTOR;
    public static ItemEntry<Item> SMD_RESISTOR;
    public static ItemEntry<Item> SMD_CAPACITOR;
    public static ItemEntry<Item> SMD_DIODE;
    public static ItemEntry<Item> SMD_INDUCTOR;
    public static ItemEntry<Item> ADVANCED_SMD_TRANSISTOR;
    public static ItemEntry<Item> ADVANCED_SMD_RESISTOR;
    public static ItemEntry<Item> ADVANCED_SMD_CAPACITOR;
    public static ItemEntry<Item> ADVANCED_SMD_DIODE;
    public static ItemEntry<Item> ADVANCED_SMD_INDUCTOR;
    public static ItemEntry<Item> ELECTRONIC_CIRCUIT_LV;
    public static ItemEntry<Item> ELECTRONIC_CIRCUIT_MV;
    public static ItemEntry<Item> INTEGRATED_CIRCUIT_LV;
    public static ItemEntry<Item> INTEGRATED_CIRCUIT_MV;
    public static ItemEntry<Item> INTEGRATED_CIRCUIT_HV;
    public static ItemEntry<Item> NAND_CHIP_ULV;
    public static ItemEntry<Item> MICROPROCESSOR_LV;
    public static ItemEntry<Item> PROCESSOR_MV;
    public static ItemEntry<Item> PROCESSOR_ASSEMBLY_HV;
    public static ItemEntry<Item> WORKSTATION_EV;
    public static ItemEntry<Item> MAINFRAME_IV;
    public static ItemEntry<Item> NANO_PROCESSOR_HV;
    public static ItemEntry<Item> NANO_PROCESSOR_ASSEMBLY_EV;
    public static ItemEntry<Item> NANO_COMPUTER_IV;
    public static ItemEntry<Item> NANO_MAINFRAME_LuV;
    public static ItemEntry<Item> QUANTUM_PROCESSOR_EV;
    public static ItemEntry<Item> QUANTUM_ASSEMBLY_IV;
    public static ItemEntry<Item> QUANTUM_COMPUTER_LuV;
    public static ItemEntry<Item> QUANTUM_MAINFRAME_ZPM;
    public static ItemEntry<Item> CRYSTAL_PROCESSOR_IV;
    public static ItemEntry<Item> CRYSTAL_ASSEMBLY_LuV;
    public static ItemEntry<Item> CRYSTAL_COMPUTER_ZPM;
    public static ItemEntry<Item> CRYSTAL_MAINFRAME_UV;
    public static ItemEntry<Item> WETWARE_PROCESSOR_LuV;
    public static ItemEntry<Item> WETWARE_PROCESSOR_ASSEMBLY_ZPM;
    public static ItemEntry<Item> WETWARE_SUPER_COMPUTER_UV;
    public static ItemEntry<Item> WETWARE_MAINFRAME_UHV;
    public static ItemEntry<Item> COMPONENT_GRINDER_DIAMOND;
    public static ItemEntry<Item> COMPONENT_GRINDER_TUNGSTEN;
    public static ItemEntry<Item> IRON_MINECART_WHEELS;
    public static ItemEntry<Item> STEEL_MINECART_WHEELS;
    public static ItemEntry<Item> QUANTUM_EYE;
    public static ItemEntry<Item> QUANTUM_STAR;
    public static ItemEntry<Item> GRAVI_STAR;
    public static ItemEntry<ComponentItem> ITEM_FILTER;
    public static ItemEntry<ComponentItem> TAG_FILTER;
    public static ItemEntry<ComponentItem> SMART_ITEM_FILTER;
    public static ItemEntry<ComponentItem> FLUID_FILTER;
    public static ItemEntry<ComponentItem> TAG_FLUID_FILTER;
    public static ItemEntry<ComponentItem> COVER_WIRELESS_TRANSMITTER;
    public static ItemEntry<ComponentItem> COVER_MACHINE_CONTROLLER;
    public static ItemEntry<ComponentItem> COVER_ACTIVITY_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_ACTIVITY_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_FLUID_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_FLUID_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_ITEM_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_ITEM_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_ENERGY_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_ENERGY_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_MAINTENANCE_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_SCREEN;
    public static ItemEntry<ComponentItem> COVER_STORAGE;
    public static ItemEntry<ComponentItem> COVER_SHUTTER;
    public static ItemEntry<ComponentItem> COVER_INFINITE_WATER;
    public static ItemEntry<ComponentItem> COVER_ENDER_FLUID_LINK;
    public static ItemEntry<ComponentItem> COVER_ENDER_ITEM_LINK;
    public static ItemEntry<ComponentItem> COVER_ENDER_REDSTONE_LINK;
    public static ItemEntry<ComponentItem> COVER_FLUID_VOIDING;
    public static ItemEntry<ComponentItem> COVER_FLUID_VOIDING_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_ITEM_VOIDING;
    public static ItemEntry<ComponentItem> COVER_ITEM_VOIDING_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_FACADE;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_ULV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_LV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_MV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_HV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_EV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_IV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_LuV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_ZPM;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_UV;
    public static ItemEntry<Item> PLUGIN_TEXT;
    public static ItemEntry<Item> PLUGIN_ONLINE_PIC;
    public static ItemEntry<Item> PLUGIN_FAKE_GUI;
    public static ItemEntry<Item> PLUGIN_ADVANCED_MONITOR;
    public static ItemEntry<ComponentItem> PROGRAMMED_CIRCUIT;
    public static ItemEntry<Item> GELLED_TOLUENE;
    public static ItemEntry<ComponentItem> BOTTLE_PURPLE_DRINK;
    public static ItemEntry<ComponentItem> DOUGH;
    public static ItemEntry<ComponentItem> PLANT_BALL;
    public static ItemEntry<ComponentItem> STICKY_RESIN;
    public static ItemEntry<ComponentItem> BIO_CHAFF;
    public static ItemEntry<Item> ENERGIUM_DUST;
    public static ItemEntry<ComponentItem> POWER_UNIT_LV;
    public static ItemEntry<ComponentItem> POWER_UNIT_MV;
    public static ItemEntry<ComponentItem> POWER_UNIT_HV;
    public static ItemEntry<ComponentItem> POWER_UNIT_EV;
    public static ItemEntry<ComponentItem> POWER_UNIT_IV;
    public static ItemEntry<Item> MASK_FILTER;
    public static ItemEntry<ComponentItem> PARACETAMOL_PILL;
    public static ItemEntry<ComponentItem> RAD_AWAY_PILL;
    public static ItemEntry<ComponentItem> NANO_SABER;
    public static ItemEntry<ComponentItem> PROSPECTOR_LV;
    public static ItemEntry<ComponentItem> PROSPECTOR_HV;
    public static ItemEntry<ComponentItem> PROSPECTOR_LuV;
    public static ItemEntry<ComponentItem> ITEM_MAGNET_LV;
    public static ItemEntry<ComponentItem> ITEM_MAGNET_HV;
    public static ItemEntry<Item> WIRELESS;
    public static ItemEntry<Item> CAMERA;
    public static ItemEntry<ComponentItem> TERMINAL;
    public static ItemEntry<ComponentItem> MACHINE_MEMORY_CARD;
    public static final ItemEntry<DyeItem>[] DYE_ONLY_ITEMS;
    public static final ItemEntry<ComponentItem>[] SPRAY_CAN_DYES;
    public static ItemEntry<ComponentItem> TURBINE_ROTOR;
    public static ItemEntry<Item> NEURO_PROCESSOR;
    public static ItemEntry<Item> STEM_CELLS;
    public static ItemEntry<Item> PETRI_DISH;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_ULV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_LV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_MV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_HV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_EV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_IV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_LuV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_ZPM;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_UV;
    public static ItemEntry<Item> CLIPBOARD;
    public static ItemEntry<ArmorComponentItem> NIGHTVISION_GOGGLES;
    public static ItemEntry<ArmorComponentItem> NANO_CHESTPLATE;
    public static ItemEntry<ArmorComponentItem> NANO_LEGGINGS;
    public static ItemEntry<ArmorComponentItem> NANO_BOOTS;
    public static ItemEntry<ArmorComponentItem> NANO_HELMET;
    public static ItemEntry<ArmorComponentItem> FACE_MASK;
    public static ItemEntry<ArmorComponentItem> RUBBER_GLOVES;
    public static ItemEntry<ArmorComponentItem> HAZMAT_CHESTPLATE;
    public static ItemEntry<ArmorComponentItem> HAZMAT_LEGGINGS;
    public static ItemEntry<ArmorComponentItem> HAZMAT_BOOTS;
    public static ItemEntry<ArmorComponentItem> HAZMAT_HELMET;
    public static ItemEntry<ArmorComponentItem> QUANTUM_CHESTPLATE;
    public static ItemEntry<ArmorComponentItem> QUANTUM_LEGGINGS;
    public static ItemEntry<ArmorComponentItem> QUANTUM_BOOTS;
    public static ItemEntry<ArmorComponentItem> QUANTUM_HELMET;
    public static ItemEntry<ArmorComponentItem> LIQUID_FUEL_JETPACK;
    public static ItemEntry<ArmorComponentItem> ELECTRIC_JETPACK;
    public static ItemEntry<ArmorComponentItem> ELECTRIC_JETPACK_ADVANCED;
    public static ItemEntry<ArmorComponentItem> NANO_CHESTPLATE_ADVANCED;
    public static ItemEntry<ArmorComponentItem> QUANTUM_CHESTPLATE_ADVANCED;
    public static ItemEntry<Item> POWER_THRUSTER;
    public static ItemEntry<Item> POWER_THRUSTER_ADVANCED;
    public static ItemEntry<Item> GRAVITATION_ENGINE;
    public static ItemEntry<RecordItem> SUS_RECORD;
    public static ItemEntry<Item> NAN_CERTIFICATE;
    public static ItemEntry<ComponentItem> FERTILIZER;
    public static ItemEntry<Item> BLACKLIGHT;
    public static ItemEntry<GTBoatItem> RUBBER_BOAT;
    public static ItemEntry<GTBoatItem> TREATED_WOOD_BOAT;
    public static ItemEntry<GTBoatItem> RUBBER_CHEST_BOAT;
    public static ItemEntry<GTBoatItem> TREATED_WOOD_CHEST_BOAT;
    public static ItemEntry<ComponentItem> TEXT_MODULE;
    public static ItemEntry<ComponentItem> IMAGE_MODULE;

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor cellColor() {
        return (itemStack, index) -> {
            if (index == 1) {
                return FluidUtil.getFluidContained((ItemStack)itemStack).map(f -> f.getFluid() == Fluids.f_76195_ ? -36864 : GTUtil.getFluidColor(f)).orElse(-1);
            }
            return -1;
        };
    }

    public static ICustomDescriptionId cellName() {
        return new ICustomDescriptionId(){

            @Override
            public Component getItemName(ItemStack stack) {
                Component prefix = FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getDisplayName).orElse((Component)Component.m_237115_((String)"gtceu.fluid.empty"));
                return Component.m_237110_((String)stack.m_41778_(), (Object[])new Object[]{prefix});
            }
        };
    }

    public static ItemEntry<ComponentItem> createFluidCell(Material mat, int capacity, int matSize, int stackSize) {
        FluidPipeProperties prop = mat.getProperty(PropertyKey.FLUID_PIPE);
        Preconditions.checkArgument((prop != null ? 1 : 0) != 0, (String)"Material { %s } does not have Fluid Pipe properties, but is being used to create a Fluid Cell", (Object)mat.getName());
        return ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("%s_fluid_cell".formatted(mat.getName()), ComponentItem::create).lang("%s " + FormattingUtil.toEnglishName(mat.getName()) + " Cell").color(() -> GTItems::cellColor).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).properties(p -> p.m_41487_(stackSize)).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create(1000 * capacity, prop, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(mat, 3628800L * (long)matSize))))).register();
    }

    public static void init() {
        GTMaterialItems.generateMaterialItems();
        GTMaterialItems.generateTools();
        GTMaterialItems.generateArmors();
    }

    public static <T extends ItemLike> NonNullConsumer<T> materialInfo(ItemMaterialInfo materialInfo) {
        return item -> ItemMaterialData.registerMaterialInfo(item, materialInfo);
    }

    public static <P, T extends Item, S2 extends ItemBuilder<T, P>> NonNullFunction<S2, S2> unificationItem(@NotNull TagPrefix tagPrefix, @NotNull Material mat) {
        return builder -> {
            builder.onRegister(item -> {
                MemoizedSupplier<ItemLike> supplier = GTMemoizer.memoize(() -> item);
                MaterialEntry entry = new MaterialEntry(tagPrefix, mat);
                GTMaterialItems.toUnify.put(entry, supplier);
                ItemMaterialData.registerMaterialEntry(supplier, entry);
            });
            return builder;
        };
    }

    public static <T extends Item> void cauldronInteraction(T item) {
        if (item instanceof TagPrefixItem) {
            TagPrefixItem tagPrefixItem = (TagPrefixItem)item;
            if (GTMaterialItems.purifyMap.containsKey(tagPrefixItem.tagPrefix)) {
                CauldronInteraction.f_175607_.put(item, (state, world, pos, player, hand, stack) -> {
                    Item stackItem;
                    if (!world.f_46443_ && (stackItem = stack.m_41720_()) instanceof TagPrefixItem) {
                        TagPrefixItem prefixItem = (TagPrefixItem)stackItem;
                        if (!GTMaterialItems.purifyMap.containsKey(prefixItem.tagPrefix)) {
                            return InteractionResult.PASS;
                        }
                        if (!state.m_61138_((Property)LayeredCauldronBlock.f_153514_)) {
                            return InteractionResult.PASS;
                        }
                        int level = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                        if (level == 0) {
                            return InteractionResult.PASS;
                        }
                        player.m_21008_(hand, ChemicalHelper.get(GTMaterialItems.purifyMap.get(prefixItem.tagPrefix), prefixItem.material, stack.m_41613_()));
                        player.m_36220_(Stats.f_12944_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stackItem));
                        LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                });
            }
        }
    }

    public static <T extends ComponentItem> NonNullConsumer<T> burnTime(int burnTime) {
        return item -> item.burnTime(burnTime);
    }

    public static <T extends IComponentItem> NonNullConsumer<T> attach(IItemComponent components) {
        return item -> item.attachComponents(components);
    }

    public static <T extends IComponentItem> NonNullConsumer<T> attach(IItemComponent ... components) {
        return item -> item.attachComponents(components);
    }

    public static <T extends Item> NonNullConsumer<T> modelPredicate(ResourceLocation predicate, StackProperty property) {
        return item -> {
            if (GTCEu.isClientSide()) {
                ItemProperties.register((Item)item, (ResourceLocation)predicate, (itemStack, c, l, i) -> property.apply(itemStack));
            }
        };
    }

    public static <T extends Item> NonNullConsumer<T> modelPredicate(ResourceLocation predicate, Supplier<Supplier<ItemPropertyFunction>> property) {
        return item -> {
            if (GTCEu.isClientSide()) {
                ItemProperties.register((Item)item, (ResourceLocation)predicate, (ItemPropertyFunction)((ItemPropertyFunction)((Supplier)property.get()).get()));
            }
        };
    }

    public static void registerToolTier(MaterialToolTier tier, ResourceLocation id, Collection<ResourceLocation> before, Collection<ResourceLocation> after) {
        TierSortingRegistry.registerTier((Tier)tier, (ResourceLocation)id, Arrays.asList(before.toArray(ResourceLocation[]::new)), Arrays.asList(after.toArray(ResourceLocation[]::new)));
    }

    public static ResourceLocation getTierName(Tier tier) {
        return TierSortingRegistry.getName((Tier)tier);
    }

    @NotNull
    private static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateLangProvider> reverseLangValue() {
        return (ctx, prov) -> {
            List names = Arrays.stream(ctx.getName().split("/.")).collect(Collectors.toList());
            Collections.reverse(names);
            prov.add((Item)ctx.get(), names.stream().map(StringUtils::capitalize).collect(Collectors.joining(" ")));
        };
    }

    static {
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.ITEM);
        COMPRESSED_CLAY = ((ItemBuilder)GTRegistration.REGISTRATE.item("compressed_clay", Item::new).lang("Compressed Clay").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Clay, 3628800L))))).register();
        COMPRESSED_COKE_CLAY = ((ItemBuilder)GTRegistration.REGISTRATE.item("compressed_coke_clay", Item::new).lang("Compressed Coke Clay").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Clay, 3628800L))))).register();
        COMPRESSED_FIRECLAY = ((ItemBuilder)GTRegistration.REGISTRATE.item("compressed_fireclay", Item::new).lang("Compressed Fireclay").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Fireclay, 3628800L))))).register();
        FIRECLAY_BRICK = ((ItemBuilder)GTRegistration.REGISTRATE.item("firebrick", Item::new).lang("Firebrick").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Fireclay, 3628800L))))).register();
        COKE_OVEN_BRICK = ((ItemBuilder)GTRegistration.REGISTRATE.item("coke_oven_brick", Item::new).lang("Coke Oven Brick").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Clay, 3628800L))))).register();
        WOODEN_FORM_EMPTY = GTRegistration.REGISTRATE.item("empty_wooden_form", Item::new).lang("Empty Wooden Form").register();
        WOODEN_FORM_BRICK = ((ItemBuilder)GTRegistration.REGISTRATE.item("brick_wooden_form", ComponentItem::create).lang("Brick Wooden Form").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ItemStack::m_41777_))).register();
        SHAPE_EMPTY = ((ItemBuilder)GTRegistration.REGISTRATE.item("empty_mold", Item::new).lang("Empty Mold").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        SHAPE_MOLDS = new ItemEntry[18];
        GTItems.SHAPE_MOLDS[0] = SHAPE_MOLD_PLATE = ((ItemBuilder)GTRegistration.REGISTRATE.item("plate_casting_mold", Item::new).lang("Casting Mold (Plate)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[1] = SHAPE_MOLD_GEAR = ((ItemBuilder)GTRegistration.REGISTRATE.item("gear_casting_mold", Item::new).lang("Casting Mold (Gear)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[2] = SHAPE_MOLD_BOTTLE = ((ItemBuilder)GTRegistration.REGISTRATE.item("bottle_casting_mold", Item::new).lang("Casting Mold (Bottle)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[3] = SHAPE_MOLD_INGOT = ((ItemBuilder)GTRegistration.REGISTRATE.item("ingot_casting_mold", Item::new).lang("Casting Mold (Ingot)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[4] = SHAPE_MOLD_BALL = ((ItemBuilder)GTRegistration.REGISTRATE.item("ball_casting_mold", Item::new).lang("Casting Mold (Ball)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[5] = SHAPE_MOLD_BLOCK = ((ItemBuilder)GTRegistration.REGISTRATE.item("block_casting_mold", Item::new).lang("Casting Mold (Block)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[6] = SHAPE_MOLD_NUGGET = ((ItemBuilder)GTRegistration.REGISTRATE.item("nugget_casting_mold", Item::new).lang("Casting Mold (Nugget)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[7] = SHAPE_MOLD_CYLINDER = ((ItemBuilder)GTRegistration.REGISTRATE.item("cylinder_casting_mold", Item::new).lang("Casting Mold (Cylinder)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[8] = SHAPE_MOLD_ANVIL = ((ItemBuilder)GTRegistration.REGISTRATE.item("anvil_casting_mold", Item::new).lang("Casting Mold (Anvil)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[9] = SHAPE_MOLD_NAME = ((ItemBuilder)GTRegistration.REGISTRATE.item("name_casting_mold", Item::new).lang("Casting Mold (Name)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[10] = SHAPE_MOLD_GEAR_SMALL = ((ItemBuilder)GTRegistration.REGISTRATE.item("small_gear_casting_mold", Item::new).lang("Casting Mold (Small Gear)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[11] = SHAPE_MOLD_ROTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("rotor_casting_mold", Item::new).lang("Casting Mold (Rotor)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[12] = SHAPE_MOLD_PILL = ((ItemBuilder)GTRegistration.REGISTRATE.item("pill_casting_mold", Item::new).lang("Casting Mold (Pill)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[13] = SHAPE_MOLD_TINY_PIPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("tiny_pipe_casting_mold", Item::new).lang("Casting Mold (Tiny Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[14] = SHAPE_MOLD_SMALL_PIPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("small_pipe_casting_mold", Item::new).lang("Casting Mold (Small Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[15] = SHAPE_MOLD_NORMAL_PIPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("normal_pipe_casting_mold", Item::new).lang("Casting Mold (Normal Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[16] = SHAPE_MOLD_LARGE_PIPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("large_pipe_casting_mold", Item::new).lang("Casting Mold (Large Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[17] = SHAPE_MOLD_HUGE_PIPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("huge_pipe_casting_mold", Item::new).lang("Casting Mold (Huge Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        SHAPE_EXTRUDERS = new ItemEntry[27];
        GTItems.SHAPE_EXTRUDERS[0] = SHAPE_EXTRUDER_PLATE = ((ItemBuilder)GTRegistration.REGISTRATE.item("plate_extruder_mold", Item::new).lang("Extruder Mold (Plate)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[1] = SHAPE_EXTRUDER_ROD = ((ItemBuilder)GTRegistration.REGISTRATE.item("rod_extruder_mold", Item::new).lang("Extruder Mold (Rod)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[2] = SHAPE_EXTRUDER_BOLT = ((ItemBuilder)GTRegistration.REGISTRATE.item("bolt_extruder_mold", Item::new).lang("Extruder Mold (Bolt)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[3] = SHAPE_EXTRUDER_RING = ((ItemBuilder)GTRegistration.REGISTRATE.item("ring_extruder_mold", Item::new).lang("Extruder Mold (Ring)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[4] = SHAPE_EXTRUDER_CELL = ((ItemBuilder)GTRegistration.REGISTRATE.item("cell_extruder_mold", Item::new).lang("Extruder Mold (Cell)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[5] = SHAPE_EXTRUDER_INGOT = ((ItemBuilder)GTRegistration.REGISTRATE.item("ingot_extruder_mold", Item::new).lang("Extruder Mold (Ingot)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[6] = SHAPE_EXTRUDER_WIRE = ((ItemBuilder)GTRegistration.REGISTRATE.item("wire_extruder_mold", Item::new).lang("Extruder Mold (Wire)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[7] = SHAPE_EXTRUDER_PIPE_TINY = ((ItemBuilder)GTRegistration.REGISTRATE.item("tiny_pipe_extruder_mold", Item::new).lang("Extruder Mold (Tiny Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[8] = SHAPE_EXTRUDER_PIPE_SMALL = ((ItemBuilder)GTRegistration.REGISTRATE.item("small_pipe_extruder_mold", Item::new).lang("Extruder Mold (Small Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[9] = SHAPE_EXTRUDER_PIPE_NORMAL = ((ItemBuilder)GTRegistration.REGISTRATE.item("normal_pipe_extruder_mold", Item::new).lang("Extruder Mold (Normal Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[10] = SHAPE_EXTRUDER_PIPE_LARGE = ((ItemBuilder)GTRegistration.REGISTRATE.item("large_pipe_extruder_mold", Item::new).lang("Extruder Mold (Large Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[11] = SHAPE_EXTRUDER_PIPE_HUGE = ((ItemBuilder)GTRegistration.REGISTRATE.item("huge_pipe_extruder_mold", Item::new).lang("Extruder Mold (Huge Pipe)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[12] = SHAPE_EXTRUDER_BLOCK = ((ItemBuilder)GTRegistration.REGISTRATE.item("block_extruder_mold", Item::new).lang("Extruder Mold (Block)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[21] = SHAPE_EXTRUDER_GEAR = ((ItemBuilder)GTRegistration.REGISTRATE.item("gear_extruder_mold", Item::new).lang("Extruder Mold (Gear)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[22] = SHAPE_EXTRUDER_BOTTLE = ((ItemBuilder)GTRegistration.REGISTRATE.item("bottle_extruder_mold", Item::new).lang("Extruder Mold (Bottle)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[23] = SHAPE_EXTRUDER_FOIL = ((ItemBuilder)GTRegistration.REGISTRATE.item("foil_extruder_mold", Item::new).lang("Extruder Mold (Foil)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[24] = SHAPE_EXTRUDER_GEAR_SMALL = ((ItemBuilder)GTRegistration.REGISTRATE.item("small_gear_extruder_mold", Item::new).lang("Extruder Mold (Small Gear)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[26] = SHAPE_EXTRUDER_ROTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("rotor_extruder_mold", Item::new).lang("Extruder Mold (Rotor)").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        SPRAY_EMPTY = GTRegistration.REGISTRATE.item("empty_spray_can", Item::new).lang("Spray Can (Empty)").register();
        SPRAY_SOLVENT = ((ItemBuilder)GTRegistration.REGISTRATE.item("solvent_spray_can", ComponentItem::create).lang("Spray Can (Solvent)").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach((IItemComponent)new ColorSprayBehaviour(() -> SPRAY_EMPTY.asStack(), 1024, -1)))).register();
        PORTABLE_SCANNER = ((ItemBuilder)GTRegistration.REGISTRATE.item("portable_scanner", ComponentItem::create).lang("Portable Scanner").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(100000L, 2), new PortableScannerBehavior(0)))).register();
        PORTABLE_DEBUG_SCANNER = ((ItemBuilder)GTRegistration.REGISTRATE.item("portable_debug_scanner", ComponentItem::create).lang("Portable Debug Scanner").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(1000000L, 2), new PortableScannerBehavior(1)))).register();
        FLUID_CELL = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("fluid_cell", ComponentItem::create).lang("%s Fluid Cell").setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).color(() -> GTItems::cellColor).onRegister(GTItems.attach(ThermalFluidStats.create(1000, 1800, true, false, false, false, false), new ItemFluidContainer(), GTItems.cellName()))).register();
        FLUID_CELL_UNIVERSAL = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("universal_fluid_cell", ComponentItem::create).lang("%s Universal Cell").color(() -> GTItems::cellColor).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create(1000, 1800, true, false, false, false, true), new ItemFluidContainer()))).register();
        FLUID_CELL_LARGE_STEEL = GTItems.createFluidCell(GTMaterials.Steel, 8, 4, 64);
        FLUID_CELL_LARGE_ALUMINIUM = GTItems.createFluidCell(GTMaterials.Aluminium, 32, 4, 64);
        FLUID_CELL_LARGE_STAINLESS_STEEL = GTItems.createFluidCell(GTMaterials.StainlessSteel, 64, 6, 64);
        FLUID_CELL_LARGE_TITANIUM = GTItems.createFluidCell(GTMaterials.Titanium, 128, 6, 64);
        FLUID_CELL_LARGE_TUNGSTEN_STEEL = GTItems.createFluidCell(GTMaterials.TungstenSteel, 512, 8, 32);
        FLUID_CELL_GLASS_VIAL = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("glass_vial", ComponentItem::create).lang("%s Glass Vial").color(() -> GTItems::cellColor).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create(1000, 1200, false, true, false, false, true), new ItemFluidContainer()))).register();
        TOOL_MATCHES = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("matches", ComponentItem::create).lang("Matches").setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).onRegister(GTItems.attach((IItemComponent)new LighterBehavior(false, false, false)))).tag(new TagKey[]{CustomTags.TOOLS_IGNITER}).register();
        TOOL_MATCHBOX = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("matchbox", ComponentItem::create).lang("Matchbox").properties(p -> p.m_41487_(1)).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).onRegister(GTItems.attach((IItemComponent)new LighterBehavior(false, true, false, () -> new ItemStack((ItemLike)Items.f_42516_, 1), 16)))).tag(new TagKey[]{CustomTags.TOOLS_IGNITER}).register();
        TOOL_LIGHTER_INVAR = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("invar_lighter", ComponentItem::create).lang("Invar Lighter").properties(p -> p.m_41487_(1)).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).onRegister(GTItems.attach((IItemComponent)new LighterBehavior(true, true, true)))).onRegister(GTItems.attach(new FilteredFluidContainer(100, true, x -> x.getFluid().m_205067_(CustomTags.LIGHTER_FLUIDS)), new ItemFluidContainer()))).onRegister(GTItems.modelPredicate(GTCEu.id("lighter_open"), (ItemStack itemStack) -> itemStack.m_41784_().m_128471_("lighterOpen") ? 1.0f : 0.0f))).tag(new TagKey[]{CustomTags.TOOLS_IGNITER}).register();
        TOOL_LIGHTER_PLATINUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("platinum_lighter", ComponentItem::create).lang("Platinum Lighter").properties(p -> p.m_41487_(1).m_41497_(Rarity.UNCOMMON)).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).onRegister(GTItems.attach((IItemComponent)new LighterBehavior(true, true, true)))).onRegister(GTItems.attach(new FilteredFluidContainer(1000, true, x -> x.getFluid().m_205067_(CustomTags.LIGHTER_FLUIDS)), new ItemFluidContainer()))).onRegister(GTItems.modelPredicate(GTCEu.id("lighter_open"), (ItemStack itemStack) -> itemStack.m_41784_().m_128471_("lighterOpen") ? 1.0f : 0.0f))).tag(new TagKey[]{CustomTags.TOOLS_IGNITER}).register();
        CARBON_FIBERS = GTRegistration.REGISTRATE.item("carbon_fibers", Item::new).lang("Raw Carbon Fibers").register();
        CARBON_MESH = GTRegistration.REGISTRATE.item("carbon_fiber_mesh", Item::new).lang("Carbon Fiber Mesh").register();
        CARBON_FIBER_PLATE = GTRegistration.REGISTRATE.item("carbon_fiber_plate", Item::new).lang("Carbon Fiber Plate").register();
        DUCT_TAPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("duct_tape", ComponentItem::create).lang("BrainTech Aerospace Advanced Reinforced Duct Tape FAL-84").onRegister(GTItems.attach((IItemComponent)new TapeBehaviour()))).register();
        BASIC_TAPE = ((ItemBuilder)GTRegistration.REGISTRATE.item("basic_tape", ComponentItem::create).lang("Tape").onRegister(GTItems.attach((IItemComponent)new TapeBehaviour()))).register();
        NEUTRON_REFLECTOR = GTRegistration.REGISTRATE.item("neutron_reflector", Item::new).lang("Iridium Neutron Reflector").register();
        BATTERY_HULL_LV = ((ItemBuilder)GTRegistration.REGISTRATE.item("lv_battery_hull", Item::new).lang("Small Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BatteryAlloy, 3628800L))))).register();
        BATTERY_HULL_MV = ((ItemBuilder)GTRegistration.REGISTRATE.item("mv_battery_hull", Item::new).lang("Medium Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BatteryAlloy, 10886400L))))).register();
        BATTERY_HULL_HV = ((ItemBuilder)GTRegistration.REGISTRATE.item("hv_battery_hull", Item::new).lang("Large Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BatteryAlloy, 32659200L))))).register();
        BATTERY_HULL_SMALL_VANADIUM = ((ItemBuilder)GTRegistration.REGISTRATE.item("ev_battery_hull", Item::new).lang("Small Vanadium Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.RedSteel, 7257600L))))).register();
        BATTERY_HULL_MEDIUM_VANADIUM = ((ItemBuilder)GTRegistration.REGISTRATE.item("iv_battery_hull", Item::new).lang("Medium Vanadium Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.RoseGold, 21772800L))))).register();
        BATTERY_HULL_LARGE_VANADIUM = ((ItemBuilder)GTRegistration.REGISTRATE.item("luv_battery_hull", Item::new).lang("Large Vanadium Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BlueSteel, 65318400L))))).register();
        BATTERY_HULL_MEDIUM_NAQUADRIA = ((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_battery_hull", Item::new).lang("Medium Naquadria Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Europium, 21772800L))))).register();
        BATTERY_HULL_LARGE_NAQUADRIA = ((ItemBuilder)GTRegistration.REGISTRATE.item("uv_battery_hull", Item::new).lang("Large Naquadria Battery Hull").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Americium, 65318400L))))).register();
        BATTERY_ULV_TANTALUM = ((ItemBuilder)GTRegistration.REGISTRATE.item("tantalum_capacitor", ComponentItem::create).lang("Tantalum Capacitor").onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(1000L, 0)))).tag(new TagKey[]{CustomTags.ULV_BATTERIES}).register();
        BATTERY_LV_SODIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_sodium_battery", ComponentItem::create).lang("Small Sodium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(80000L, 1)))).tag(new TagKey[]{CustomTags.LV_BATTERIES}).register();
        BATTERY_MV_SODIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_sodium_battery", ComponentItem::create).lang("Medium Sodium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(360000L, 2)))).tag(new TagKey[]{CustomTags.MV_BATTERIES}).register();
        BATTERY_HV_SODIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_sodium_battery", ComponentItem::create).lang("Large Sodium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(1200000L, 3)))).tag(new TagKey[]{CustomTags.HV_BATTERIES}).register();
        BATTERY_LV_LITHIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_lithium_battery", ComponentItem::create).lang("Small Lithium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(120000L, 1)))).tag(new TagKey[]{CustomTags.LV_BATTERIES}).register();
        BATTERY_MV_LITHIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_lithium_battery", ComponentItem::create).lang("Medium Lithium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(420000L, 2)))).tag(new TagKey[]{CustomTags.MV_BATTERIES}).register();
        BATTERY_HV_LITHIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_lithium_battery", ComponentItem::create).lang("Large Lithium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(1800000L, 3)))).tag(new TagKey[]{CustomTags.HV_BATTERIES}).register();
        BATTERY_LV_CADMIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_cadmium_battery", ComponentItem::create).lang("Small Cadmium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(100000L, 1)))).tag(new TagKey[]{CustomTags.LV_BATTERIES}).register();
        BATTERY_MV_CADMIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_cadmium_battery", ComponentItem::create).lang("Medium Cadmium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(400000L, 2)))).tag(new TagKey[]{CustomTags.MV_BATTERIES}).register();
        BATTERY_HV_CADMIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_cadmium_battery", ComponentItem::create).lang("Large Cadmium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(1600000L, 3)))).tag(new TagKey[]{CustomTags.HV_BATTERIES}).register();
        ENERGIUM_CRYSTAL = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("energy_crystal", ComponentItem::create).lang("Energium Crystal").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(6400000L, 3)))).tag(new TagKey[]{CustomTags.HV_BATTERIES}).register();
        LAPOTRON_CRYSTAL = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lapotron_crystal", ComponentItem::create).model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(25000000L, 4)))).tag(new TagKey[]{CustomTags.EV_BATTERIES}).register();
        BATTERY_EV_VANADIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ev_vanadium_battery", ComponentItem::create).lang("Small Vanadium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(10240000L, 4)))).tag(new TagKey[]{CustomTags.EV_BATTERIES}).register();
        BATTERY_IV_VANADIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("iv_vanadium_battery", ComponentItem::create).lang("Medium Vanadium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(40960000L, 5)))).tag(new TagKey[]{CustomTags.IV_BATTERIES}).register();
        BATTERY_LuV_VANADIUM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("luv_vanadium_battery", ComponentItem::create).lang("Large Vanadium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(163840000L, 6)))).tag(new TagKey[]{CustomTags.LuV_BATTERIES}).register();
        BATTERY_ZPM_NAQUADRIA = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_naquadria_battery", ComponentItem::create).lang("Medium Naquadria Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(655360000L, 7)))).tag(new TagKey[]{CustomTags.ZPM_BATTERIES}).register();
        BATTERY_UV_NAQUADRIA = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uv_naquadria_battery", ComponentItem::create).lang("Large Naquadria Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(2621440000L, 8)))).tag(new TagKey[]{CustomTags.UV_BATTERIES}).register();
        ENERGY_LAPOTRONIC_ORB = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lapotronic_energy_orb", ComponentItem::create).lang("Lapotronic Energy Orb").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(250000000L, 5)))).tag(new TagKey[]{CustomTags.IV_BATTERIES}).register();
        ENERGY_LAPOTRONIC_ORB_CLUSTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lapotronic_energy_orb_cluster", ComponentItem::create).lang("Lapotronic Energy Orb Cluster").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(1000000000L, 6)))).tag(new TagKey[]{CustomTags.LuV_BATTERIES}).register();
        ENERGY_MODULE = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("energy_module", ComponentItem::create).lang("Energy Module").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(4000000000L, 7)))).tag(new TagKey[]{CustomTags.ZPM_BATTERIES}).register();
        ENERGY_CLUSTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("energy_cluster", ComponentItem::create).lang("Energy Cluster").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(20000000000L, 8)))).tag(new TagKey[]{CustomTags.UV_BATTERIES}).register();
        ZERO_POINT_MODULE = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zero_point_module", ComponentItem::create).lang("Zero Point Module").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createBattery(2000000000000L, 7, true)))).register();
        ULTIMATE_BATTERY = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("max_battery", ComponentItem::create).lang("Ultimate Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach((IItemComponent)ElectricStats.createRechargeableBattery(Long.MAX_VALUE, 9)))).tag(new TagKey[]{CustomTags.UHV_BATTERIES}).register();
        ELECTRIC_MOTOR_LV = GTRegistration.REGISTRATE.item("lv_electric_motor", Item::new).lang("LV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_MV = GTRegistration.REGISTRATE.item("mv_electric_motor", Item::new).lang("MV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_HV = GTRegistration.REGISTRATE.item("hv_electric_motor", Item::new).lang("HV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_EV = GTRegistration.REGISTRATE.item("ev_electric_motor", Item::new).lang("EV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_IV = GTRegistration.REGISTRATE.item("iv_electric_motor", Item::new).lang("IV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_LuV = GTRegistration.REGISTRATE.item("luv_electric_motor", Item::new).lang("LuV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_ZPM = GTRegistration.REGISTRATE.item("zpm_electric_motor", Item::new).lang("ZPM Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_UV = GTRegistration.REGISTRATE.item("uv_electric_motor", Item::new).lang("UV Electric Motor").tag(new TagKey[]{CustomTags.ELECTRIC_MOTORS}).register();
        ELECTRIC_MOTOR_UHV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uhv_electric_motor", Item::new).lang("UHV Electric Motor").register() : null;
        ELECTRIC_MOTOR_UEV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uev_electric_motor", Item::new).lang("UEV Electric Motor").register() : null;
        ELECTRIC_MOTOR_UIV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uiv_electric_motor", Item::new).lang("UIV Electric Motor").register() : null;
        ELECTRIC_MOTOR_UXV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uxv_electric_motor", Item::new).lang("UXV Electric Motor").register() : null;
        ELECTRIC_MOTOR_OpV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("opv_electric_motor", Item::new).lang("OpV Electric Motor").register() : null;
        ELECTRIC_PUMP_LV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_electric_pump", ComponentItem::create).lang("LV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[0])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(64)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_MV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_electric_pump", ComponentItem::create).lang("MV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[1])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(256)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_HV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_electric_pump", ComponentItem::create).lang("HV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[2])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(1024)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_EV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ev_electric_pump", ComponentItem::create).lang("EV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[3])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(4096)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_IV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("iv_electric_pump", ComponentItem::create).lang("IV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[4])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(16384)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_LuV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("luv_electric_pump", ComponentItem::create).lang("LuV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[5])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(65536)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_ZPM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_electric_pump", ComponentItem::create).lang("ZPM Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[6])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(262144)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_UV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uv_electric_pump", ComponentItem::create).lang("UV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[7])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{FormattingUtil.formatNumbers(0x100000)}));
        })))).tag(new TagKey[]{CustomTags.ELECTRIC_PUMPS}).register();
        ELECTRIC_PUMP_UHV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uhv_electric_pump", ComponentItem::create).lang("UHV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[8])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        ELECTRIC_PUMP_UEV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uev_electric_pump", ComponentItem::create).lang("UEV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[9])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        ELECTRIC_PUMP_UIV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uiv_electric_pump", ComponentItem::create).lang("UIV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[10])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        ELECTRIC_PUMP_UXV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uxv_electric_pump", ComponentItem::create).lang("UXV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[11])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        ELECTRIC_PUMP_OpV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("opv_electric_pump", ComponentItem::create).lang("OpV Electric Pump").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.PUMPS[12])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_LV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_fluid_regulator", ComponentItem::create).lang("LV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[0])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{64}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_MV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_fluid_regulator", ComponentItem::create).lang("MV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[1])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{256}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_HV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_fluid_regulator", ComponentItem::create).lang("HV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[2])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{1024}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_EV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ev_fluid_regulator", ComponentItem::create).lang("EV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[3])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{4096}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_IV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("iv_fluid_regulator", ComponentItem::create).lang("IV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[4])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{16384}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_LuV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("luv_fluid_regulator", ComponentItem::create).lang("LuV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[5])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{65536}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_ZPM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_fluid_regulator", ComponentItem::create).lang("ZPM Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[6])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{262144}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_UV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uv_fluid_regulator", ComponentItem::create).lang("UV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[7])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).tag(new TagKey[]{CustomTags.FLUID_REGULATORS}).register();
        FLUID_REGULATOR_UHV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uhv_fluid_regulator", ComponentItem::create).lang("UHV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[8])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_UEV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uev_fluid_regulator", ComponentItem::create).lang("UEV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[9])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_UIV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uiv_fluid_regulator", ComponentItem::create).lang("UIV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[10])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_UXV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uxv_fluid_regulator", ComponentItem::create).lang("UXV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[11])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_OpV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("opv_fluid_regulator", ComponentItem::create).lang("OpV Fluid Regulator").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[12])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        DYNAMITE = ((ItemBuilder)GTRegistration.REGISTRATE.item("dynamite", ComponentItem::create).lang("Dynamite").onRegister(GTItems.attach((IItemComponent)new DynamiteBehaviour()))).tab(GTCreativeModeTabs.TOOL.getKey()).register();
        CONVEYOR_MODULE_LV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_conveyor_module", ComponentItem::create).lang("LV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[0])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{8}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_MV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_conveyor_module", ComponentItem::create).lang("MV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[1])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{32}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_HV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_conveyor_module", ComponentItem::create).lang("HV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[2])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{64}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_EV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ev_conveyor_module", ComponentItem::create).lang("EV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[3])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{3}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_IV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("iv_conveyor_module", ComponentItem::create).lang("IV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[4])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{8}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_LuV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("luv_conveyor_module", ComponentItem::create).lang("LuV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[5])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_ZPM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_conveyor_module", ComponentItem::create).lang("ZPM Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[6])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_UV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uv_conveyor_module", ComponentItem::create).lang("UV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[7])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).tag(new TagKey[]{CustomTags.CONVEYOR_MODULES}).register();
        CONVEYOR_MODULE_UHV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uhv_conveyor_module", ComponentItem::create).lang("UHV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[8])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        CONVEYOR_MODULE_UEV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uev_conveyor_module", ComponentItem::create).lang("UEV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[9])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        CONVEYOR_MODULE_UIV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uiv_conveyor_module", ComponentItem::create).lang("UIV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[10])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        CONVEYOR_MODULE_UXV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uxv_conveyor_module", ComponentItem::create).lang("UXV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[11])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        CONVEYOR_MODULE_OpV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("opv_conveyor_module", ComponentItem::create).lang("OpV Conveyor Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.CONVEYORS[12])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        ELECTRIC_PISTON_LV = GTRegistration.REGISTRATE.item("lv_electric_piston", Item::new).lang("LV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_MV = GTRegistration.REGISTRATE.item("mv_electric_piston", Item::new).lang("MV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_HV = GTRegistration.REGISTRATE.item("hv_electric_piston", Item::new).lang("HV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_EV = GTRegistration.REGISTRATE.item("ev_electric_piston", Item::new).lang("EV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_IV = GTRegistration.REGISTRATE.item("iv_electric_piston", Item::new).lang("IV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_LuV = GTRegistration.REGISTRATE.item("luv_electric_piston", Item::new).lang("LuV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_ZPM = GTRegistration.REGISTRATE.item("zpm_electric_piston", Item::new).lang("ZPM Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_UV = GTRegistration.REGISTRATE.item("uv_electric_piston", Item::new).lang("UV Electric Piston").tag(new TagKey[]{CustomTags.ELECTRIC_PISTONS}).register();
        ELECTRIC_PISTON_UHV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uhv_electric_piston", Item::new).lang("UHV Electric Piston").register() : null;
        ELECTRIC_PISTON_UEV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uev_electric_piston", Item::new).lang("UEV Electric Piston").register() : null;
        ELECTRIC_PISTON_UIV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uiv_electric_piston", Item::new).lang("UIV Electric Piston").register() : null;
        ELECTRIC_PISTON_UXV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uxv_electric_piston", Item::new).lang("UXV Electric Piston").register() : null;
        ELECTRIC_PISTON_OpV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("opv_electric_piston", Item::new).lang("OpV Electric Piston").register() : null;
        ROBOT_ARM_LV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_robot_arm", ComponentItem::create).lang("LV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[0])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{8}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_MV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_robot_arm", ComponentItem::create).lang("MV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[1])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{32}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_HV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_robot_arm", ComponentItem::create).lang("HV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[2])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{64}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_EV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ev_robot_arm", ComponentItem::create).lang("EV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[3])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{3}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_IV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("iv_robot_arm", ComponentItem::create).lang("IV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[4])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{8}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_LuV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("luv_robot_arm", ComponentItem::create).lang("LuV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[5])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_ZPM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_robot_arm", ComponentItem::create).lang("ZPM Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[6])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_UV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uv_robot_arm", ComponentItem::create).lang("UV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[7])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).tag(new TagKey[]{CustomTags.ROBOT_ARMS}).register();
        ROBOT_ARM_UHV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uhv_robot_arm", ComponentItem::create).lang("UHV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[8])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        ROBOT_ARM_UEV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uev_robot_arm", ComponentItem::create).lang("UEV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[9])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        ROBOT_ARM_UIV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uiv_robot_arm", ComponentItem::create).lang("UIV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[10])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        ROBOT_ARM_UXV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uxv_robot_arm", ComponentItem::create).lang("UXV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[11])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        ROBOT_ARM_OpV = GTCEuAPI.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("opv_robot_arm", ComponentItem::create).lang("OpV Robot Arm").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[12])))).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.add(Component.m_237115_((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).register() : null;
        FIELD_GENERATOR_LV = GTRegistration.REGISTRATE.item("lv_field_generator", Item::new).lang("LV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_MV = GTRegistration.REGISTRATE.item("mv_field_generator", Item::new).lang("MV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_HV = GTRegistration.REGISTRATE.item("hv_field_generator", Item::new).lang("HV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_EV = GTRegistration.REGISTRATE.item("ev_field_generator", Item::new).lang("EV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_IV = GTRegistration.REGISTRATE.item("iv_field_generator", Item::new).lang("IV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_LuV = GTRegistration.REGISTRATE.item("luv_field_generator", Item::new).lang("LuV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_ZPM = GTRegistration.REGISTRATE.item("zpm_field_generator", Item::new).lang("ZPM Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_UV = GTRegistration.REGISTRATE.item("uv_field_generator", Item::new).lang("UV Field Generator").tag(new TagKey[]{CustomTags.FIELD_GENERATORS}).register();
        FIELD_GENERATOR_UHV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uhv_field_generator", Item::new).lang("UHV Field Generator").register() : null;
        FIELD_GENERATOR_UEV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uev_field_generator", Item::new).lang("UEV Field Generator").register() : null;
        FIELD_GENERATOR_UIV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uiv_field_generator", Item::new).lang("UIV Field Generator").register() : null;
        FIELD_GENERATOR_UXV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uxv_field_generator", Item::new).lang("UXV Field Generator").register() : null;
        FIELD_GENERATOR_OpV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("opv_field_generator", Item::new).lang("OpV Field Generator").register() : null;
        EMITTER_LV = GTRegistration.REGISTRATE.item("lv_emitter", Item::new).lang("LV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_MV = GTRegistration.REGISTRATE.item("mv_emitter", Item::new).lang("MV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_HV = GTRegistration.REGISTRATE.item("hv_emitter", Item::new).lang("HV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_EV = GTRegistration.REGISTRATE.item("ev_emitter", Item::new).lang("EV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_IV = GTRegistration.REGISTRATE.item("iv_emitter", Item::new).lang("IV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_LuV = GTRegistration.REGISTRATE.item("luv_emitter", Item::new).lang("LuV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_ZPM = GTRegistration.REGISTRATE.item("zpm_emitter", Item::new).lang("ZPM Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_UV = GTRegistration.REGISTRATE.item("uv_emitter", Item::new).lang("UV Emitter").tag(new TagKey[]{CustomTags.EMITTERS}).register();
        EMITTER_UHV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uhv_emitter", Item::new).lang("UHV Emitter").register() : null;
        EMITTER_UEV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uev_emitter", Item::new).lang("UEV Emitter").register() : null;
        EMITTER_UIV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uiv_emitter", Item::new).lang("UIV Emitter").register() : null;
        EMITTER_UXV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uxv_emitter", Item::new).lang("UXV Emitter").register() : null;
        EMITTER_OpV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("opv_emitter", Item::new).lang("OpV Emitter").register() : null;
        SENSOR_LV = GTRegistration.REGISTRATE.item("lv_sensor", Item::new).lang("LV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_MV = GTRegistration.REGISTRATE.item("mv_sensor", Item::new).lang("MV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_HV = GTRegistration.REGISTRATE.item("hv_sensor", Item::new).lang("HV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_EV = GTRegistration.REGISTRATE.item("ev_sensor", Item::new).lang("EV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_IV = GTRegistration.REGISTRATE.item("iv_sensor", Item::new).lang("IV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_LuV = GTRegistration.REGISTRATE.item("luv_sensor", Item::new).lang("LuV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_ZPM = GTRegistration.REGISTRATE.item("zpm_sensor", Item::new).lang("ZPM Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_UV = GTRegistration.REGISTRATE.item("uv_sensor", Item::new).lang("UV Sensor").tag(new TagKey[]{CustomTags.SENSORS}).register();
        SENSOR_UHV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uhv_sensor", Item::new).lang("UHV Sensor").register() : null;
        SENSOR_UEV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uev_sensor", Item::new).lang("UEV Sensor").register() : null;
        SENSOR_UIV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uiv_sensor", Item::new).lang("UIV Sensor").register() : null;
        SENSOR_UXV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("uxv_sensor", Item::new).lang("UXV Sensor").register() : null;
        SENSOR_OpV = GTCEuAPI.isHighTier() ? GTRegistration.REGISTRATE.item("opv_sensor", Item::new).lang("OpV Sensor").register() : null;
        TOOL_DATA_STICK = ((ItemBuilder)GTRegistration.REGISTRATE.item("data_stick", ComponentItem::create).lang("Data Stick").onRegister(GTItems.attach((IItemComponent)new DataItemBehavior(false, 8)))).register();
        TOOL_DATA_ORB = ((ItemBuilder)GTRegistration.REGISTRATE.item("data_orb", ComponentItem::create).lang("Data Orb").onRegister(GTItems.attach((IItemComponent)new DataItemBehavior(false, 64)))).register();
        TOOL_DATA_MODULE = ((ItemBuilder)GTRegistration.REGISTRATE.item("data_module", ComponentItem::create).lang("Data Module").onRegister(GTItems.attach((IItemComponent)new DataItemBehavior(true, 256)))).register();
        GLASS_LENSES = new HashMap<MarkerMaterial, ItemEntry<Item>>();
        for (int i = 0; i < MarkerMaterials.Color.VALUES.length; ++i) {
            MarkerMaterial color = MarkerMaterials.Color.VALUES[i];
            if (color == MarkerMaterials.Color.White) continue;
            GLASS_LENSES.put(color, (ItemEntry<Item>)((ItemBuilder)GTRegistration.REGISTRATE.item(String.format("%s_glass_lens", color.getName()), Item::new).lang("Glass Lens (%s)".formatted(FormattingUtil.toEnglishName(color.getName()))).transform(GTItems.unificationItem(TagPrefix.lens, color))).register());
        }
        SILICON_BOULE = GTRegistration.REGISTRATE.item("silicon_boule", Item::new).lang("Monocrystalline Silicon Boule").register();
        PHOSPHORUS_BOULE = GTRegistration.REGISTRATE.item("phosphorus_boule", Item::new).lang("Phosphorus-doped Monocrystalline Silicon Boule").register();
        NAQUADAH_BOULE = GTRegistration.REGISTRATE.item("naquadah_boule", Item::new).lang("Naquadah-doped Monocrystalline Silicon Boule").register();
        NEUTRONIUM_BOULE = GTRegistration.REGISTRATE.item("neutronium_boule", Item::new).lang("Neutronium-doped Monocrystalline Silicon Boule").register();
        SILICON_WAFER = GTRegistration.REGISTRATE.item("silicon_wafer", Item::new).lang("Silicon Wafer").register();
        PHOSPHORUS_WAFER = GTRegistration.REGISTRATE.item("phosphorus_wafer", Item::new).lang("Phosphorus-doped Wafer").register();
        NAQUADAH_WAFER = GTRegistration.REGISTRATE.item("naquadah_wafer", Item::new).lang("Naquadah-doped Wafer").register();
        NEUTRONIUM_WAFER = GTRegistration.REGISTRATE.item("neutronium_wafer", Item::new).lang("Neutronium-doped Wafer").register();
        CENTRAL_PROCESSING_UNIT_WAFER = GTRegistration.REGISTRATE.item("cpu_wafer", Item::new).lang("CPU Wafer").register();
        RANDOM_ACCESS_MEMORY_WAFER = GTRegistration.REGISTRATE.item("ram_wafer", Item::new).lang("RAM Wafer").register();
        INTEGRATED_LOGIC_CIRCUIT_WAFER = GTRegistration.REGISTRATE.item("ilc_wafer", Item::new).lang("ILC Wafer").register();
        NANO_CENTRAL_PROCESSING_UNIT_WAFER = GTRegistration.REGISTRATE.item("nano_cpu_wafer", Item::new).lang("Nano CPU Wafer").register();
        QUBIT_CENTRAL_PROCESSING_UNIT_WAFER = GTRegistration.REGISTRATE.item("qbit_cpu_wafer", Item::new).lang("Qubit CPU Wafer").register();
        SIMPLE_SYSTEM_ON_CHIP_WAFER = GTRegistration.REGISTRATE.item("simple_soc_wafer", Item::new).lang("Simple SoC Wafer").register();
        SYSTEM_ON_CHIP_WAFER = GTRegistration.REGISTRATE.item("soc_wafer", Item::new).lang("SoC Wafer").register();
        ADVANCED_SYSTEM_ON_CHIP_WAFER = GTRegistration.REGISTRATE.item("advanced_soc_wafer", Item::new).lang("ASoC Wafer").register();
        HIGHLY_ADVANCED_SOC_WAFER = GTRegistration.REGISTRATE.item("highly_advanced_soc_wafer", Item::new).lang("HASoC Wafer").register();
        NAND_MEMORY_CHIP_WAFER = GTRegistration.REGISTRATE.item("nand_memory_wafer", Item::new).lang("NAND Memory Wafer").register();
        NOR_MEMORY_CHIP_WAFER = GTRegistration.REGISTRATE.item("nor_memory_wafer", Item::new).lang("NOR Memory Wafer").register();
        ULTRA_LOW_POWER_INTEGRATED_CIRCUIT_WAFER = GTRegistration.REGISTRATE.item("ulpic_wafer", Item::new).lang("ULPIC Wafer").register();
        LOW_POWER_INTEGRATED_CIRCUIT_WAFER = GTRegistration.REGISTRATE.item("lpic_wafer", Item::new).lang("LPIC Wafer").register();
        POWER_INTEGRATED_CIRCUIT_WAFER = GTRegistration.REGISTRATE.item("mpic_wafer", Item::new).lang("MPIC Wafer").register();
        HIGH_POWER_INTEGRATED_CIRCUIT_WAFER = GTRegistration.REGISTRATE.item("hpic_wafer", Item::new).lang("HPIC Wafer").register();
        ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT_WAFER = GTRegistration.REGISTRATE.item("uhpic_wafer", Item::new).lang("UHPIC Wafer").register();
        ENGRAVED_CRYSTAL_CHIP = GTRegistration.REGISTRATE.item("engraved_crystal_chip", Item::new).lang("Engraved Crystal Chip").register();
        ENGRAVED_LAPOTRON_CHIP = GTRegistration.REGISTRATE.item("engraved_lapotron_crystal_chip", Item::new).lang("Engraved Lapotron Crystal Chip").register();
        CENTRAL_PROCESSING_UNIT = GTRegistration.REGISTRATE.item("cpu_chip", Item::new).lang("CPU Chip").register();
        RANDOM_ACCESS_MEMORY = GTRegistration.REGISTRATE.item("ram_chip", Item::new).lang("RAM Chip").register();
        INTEGRATED_LOGIC_CIRCUIT = GTRegistration.REGISTRATE.item("ilc_chip", Item::new).lang("IC Chip").register();
        NANO_CENTRAL_PROCESSING_UNIT = GTRegistration.REGISTRATE.item("nano_cpu_chip", Item::new).lang("Nano CPU Chip").register();
        QUBIT_CENTRAL_PROCESSING_UNIT = GTRegistration.REGISTRATE.item("qbit_cpu_chip", Item::new).lang("Qubit CPU Chip").register();
        SIMPLE_SYSTEM_ON_CHIP = GTRegistration.REGISTRATE.item("simple_soc", Item::new).lang("Simple SoC").register();
        SYSTEM_ON_CHIP = GTRegistration.REGISTRATE.item("soc", Item::new).lang("SoC").register();
        ADVANCED_SYSTEM_ON_CHIP = GTRegistration.REGISTRATE.item("advanced_soc", Item::new).lang("ASoC").register();
        HIGHLY_ADVANCED_SOC = GTRegistration.REGISTRATE.item("highly_advanced_soc", Item::new).lang("HASoC").register();
        NAND_MEMORY_CHIP = GTRegistration.REGISTRATE.item("nand_memory_chip", Item::new).lang("NAND Memory Chip").register();
        NOR_MEMORY_CHIP = GTRegistration.REGISTRATE.item("nor_memory_chip", Item::new).lang("NOR Memory Chip").register();
        ULTRA_LOW_POWER_INTEGRATED_CIRCUIT = GTRegistration.REGISTRATE.item("ulpic_chip", Item::new).lang("ULPIC Chip").register();
        LOW_POWER_INTEGRATED_CIRCUIT = GTRegistration.REGISTRATE.item("lpic_chip", Item::new).lang("LPIC Chip").register();
        POWER_INTEGRATED_CIRCUIT = GTRegistration.REGISTRATE.item("mpic_chip", Item::new).lang("MPIC Chip").register();
        HIGH_POWER_INTEGRATED_CIRCUIT = GTRegistration.REGISTRATE.item("hpic_chip", Item::new).lang("HPIC Chip").register();
        ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT = GTRegistration.REGISTRATE.item("uhpic_chip", Item::new).lang("UHPIC Chip").register();
        RAW_CRYSTAL_CHIP = GTRegistration.REGISTRATE.item("raw_crystal_chip", Item::new).lang("Raw Crystal Chip").register();
        RAW_CRYSTAL_CHIP_PART = GTRegistration.REGISTRATE.item("raw_crystal_chip_parts", Item::new).lang("Raw Crystal Chip Parts").register();
        CRYSTAL_CENTRAL_PROCESSING_UNIT = GTRegistration.REGISTRATE.item("crystal_cpu", Item::new).lang("Crystal CPU").register();
        CRYSTAL_SYSTEM_ON_CHIP = GTRegistration.REGISTRATE.item("crystal_soc", Item::new).lang("Crystal SoC").register();
        COATED_BOARD = GTRegistration.REGISTRATE.item("resin_circuit_board", Item::new).lang("Resin Circuit Board").register();
        PHENOLIC_BOARD = GTRegistration.REGISTRATE.item("phenolic_circuit_board", Item::new).lang("Phenolic Circuit Board").register();
        PLASTIC_BOARD = GTRegistration.REGISTRATE.item("plastic_circuit_board", Item::new).lang("Plastic Circuit Board").register();
        EPOXY_BOARD = GTRegistration.REGISTRATE.item("epoxy_circuit_board", Item::new).lang("Epoxy Circuit Board").register();
        FIBER_BOARD = GTRegistration.REGISTRATE.item("fiber_reinforced_circuit_board", Item::new).lang("Fiber-Reinforced Circuit Board").register();
        MULTILAYER_FIBER_BOARD = GTRegistration.REGISTRATE.item("multilayer_fiber_reinforced_circuit_board", Item::new).lang("Multi-layer Fiber-Reinforced Circuit Board").register();
        WETWARE_BOARD = GTRegistration.REGISTRATE.item("wetware_circuit_board", Item::new).lang("Wetware Circuit Board").register();
        BASIC_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("resin_printed_circuit_board", Item::new).lang("Resin Printed Circuit Board").register();
        GOOD_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("phenolic_printed_circuit_board", Item::new).lang("Phenolic Printed Circuit Board").register();
        PLASTIC_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("plastic_printed_circuit_board", Item::new).lang("Plastic Printed Circuit Board").register();
        ADVANCED_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("epoxy_printed_circuit_board", Item::new).lang("Epoxy Printed Circuit Board").register();
        EXTREME_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("fiber_reinforced_printed_circuit_board", Item::new).lang("Fiber-Reinforced Printed Circuit Board").register();
        ELITE_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("multilayer_fiber_reinforced_printed_circuit_board", Item::new).lang("Multi-layer Fiber-Reinforced Printed Circuit Board").register();
        WETWARE_CIRCUIT_BOARD = GTRegistration.REGISTRATE.item("wetware_printed_circuit_board", Item::new).lang("Wetware Printed Circuit Board").register();
        VACUUM_TUBE = GTRegistration.REGISTRATE.item("vacuum_tube", Item::new).lang("Vacuum Tube").tag(new TagKey[]{CustomTags.ULV_CIRCUITS}).register();
        GLASS_TUBE = ((ItemBuilder)GTRegistration.REGISTRATE.item("glass_tube", Item::new).lang("Glass Tube").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Glass, 3628800L))))).register();
        TRANSISTOR = GTRegistration.REGISTRATE.item("transistor", Item::new).lang("Transistor").tag(new TagKey[]{CustomTags.TRANSISTORS}).register();
        RESISTOR = GTRegistration.REGISTRATE.item("resistor", Item::new).lang("Resistor").tag(new TagKey[]{CustomTags.RESISTORS}).register();
        CAPACITOR = GTRegistration.REGISTRATE.item("capacitor", Item::new).lang("Capacitor").tag(new TagKey[]{CustomTags.CAPACITORS}).register();
        DIODE = GTRegistration.REGISTRATE.item("diode", Item::new).lang("Diode").tag(new TagKey[]{CustomTags.DIODES}).register();
        INDUCTOR = GTRegistration.REGISTRATE.item("inductor", Item::new).lang("Inductor").tag(new TagKey[]{CustomTags.INDUCTORS}).register();
        SMD_TRANSISTOR = GTRegistration.REGISTRATE.item("smd_transistor", Item::new).lang("SMD Transistor").tag(new TagKey[]{CustomTags.TRANSISTORS}).register();
        SMD_RESISTOR = GTRegistration.REGISTRATE.item("smd_resistor", Item::new).lang("SMD Resistor").tag(new TagKey[]{CustomTags.RESISTORS}).register();
        SMD_CAPACITOR = GTRegistration.REGISTRATE.item("smd_capacitor", Item::new).lang("SMD Capacitor").tag(new TagKey[]{CustomTags.CAPACITORS}).register();
        SMD_DIODE = GTRegistration.REGISTRATE.item("smd_diode", Item::new).lang("SMD Diode").tag(new TagKey[]{CustomTags.DIODES}).register();
        SMD_INDUCTOR = GTRegistration.REGISTRATE.item("smd_inductor", Item::new).lang("SMD Inductor").tag(new TagKey[]{CustomTags.INDUCTORS}).register();
        ADVANCED_SMD_TRANSISTOR = GTRegistration.REGISTRATE.item("advanced_smd_transistor", Item::new).lang("Advanced SMD Transistor").register();
        ADVANCED_SMD_RESISTOR = GTRegistration.REGISTRATE.item("advanced_smd_resistor", Item::new).lang("Advanced SMD Resistor").register();
        ADVANCED_SMD_CAPACITOR = GTRegistration.REGISTRATE.item("advanced_smd_capacitor", Item::new).lang("Advanced SMD Capacitor").register();
        ADVANCED_SMD_DIODE = GTRegistration.REGISTRATE.item("advanced_smd_diode", Item::new).lang("Advanced SMD Diode").register();
        ADVANCED_SMD_INDUCTOR = GTRegistration.REGISTRATE.item("advanced_smd_inductor", Item::new).lang("Advanced SMD Inductor").register();
        ELECTRONIC_CIRCUIT_LV = GTRegistration.REGISTRATE.item("basic_electronic_circuit", Item::new).lang("Basic Electronic Circuit").tag(new TagKey[]{CustomTags.LV_CIRCUITS}).register();
        ELECTRONIC_CIRCUIT_MV = GTRegistration.REGISTRATE.item("good_electronic_circuit", Item::new).lang("Good Electronic Circuit").tag(new TagKey[]{CustomTags.MV_CIRCUITS}).register();
        INTEGRATED_CIRCUIT_LV = GTRegistration.REGISTRATE.item("basic_integrated_circuit", Item::new).lang("Basic Integrated Circuit").tag(new TagKey[]{CustomTags.LV_CIRCUITS}).register();
        INTEGRATED_CIRCUIT_MV = GTRegistration.REGISTRATE.item("good_integrated_circuit", Item::new).lang("Good Integrated Circuit").tag(new TagKey[]{CustomTags.MV_CIRCUITS}).register();
        INTEGRATED_CIRCUIT_HV = GTRegistration.REGISTRATE.item("advanced_integrated_circuit", Item::new).lang("Advanced Integrated Circuit").tag(new TagKey[]{CustomTags.HV_CIRCUITS}).register();
        NAND_CHIP_ULV = GTRegistration.REGISTRATE.item("nand_chip", Item::new).lang("NAND Chip").tag(new TagKey[]{CustomTags.ULV_CIRCUITS}).register();
        MICROPROCESSOR_LV = GTRegistration.REGISTRATE.item("microchip_processor", Item::new).lang("Microchip Processor").tag(new TagKey[]{CustomTags.LV_CIRCUITS}).register();
        PROCESSOR_MV = GTRegistration.REGISTRATE.item("micro_processor", Item::new).lang("Microprocessor").tag(new TagKey[]{CustomTags.MV_CIRCUITS}).register();
        PROCESSOR_ASSEMBLY_HV = GTRegistration.REGISTRATE.item("micro_processor_assembly", Item::new).lang("Microprocessor Assembly").tag(new TagKey[]{CustomTags.HV_CIRCUITS}).register();
        WORKSTATION_EV = GTRegistration.REGISTRATE.item("micro_processor_computer", Item::new).lang("Microprocessor Supercomputer").tag(new TagKey[]{CustomTags.EV_CIRCUITS}).register();
        MAINFRAME_IV = GTRegistration.REGISTRATE.item("micro_processor_mainframe", Item::new).lang("Microprocessor Mainframe").tag(new TagKey[]{CustomTags.IV_CIRCUITS}).register();
        NANO_PROCESSOR_HV = GTRegistration.REGISTRATE.item("nano_processor", Item::new).lang("Nanoprocessor").tag(new TagKey[]{CustomTags.HV_CIRCUITS}).register();
        NANO_PROCESSOR_ASSEMBLY_EV = GTRegistration.REGISTRATE.item("nano_processor_assembly", Item::new).lang("Nanoprocessor Assembly").tag(new TagKey[]{CustomTags.EV_CIRCUITS}).register();
        NANO_COMPUTER_IV = GTRegistration.REGISTRATE.item("nano_processor_computer", Item::new).lang("Nanoprocessor Supercomputer").tag(new TagKey[]{CustomTags.IV_CIRCUITS}).register();
        NANO_MAINFRAME_LuV = GTRegistration.REGISTRATE.item("nano_processor_mainframe", Item::new).lang("Nanoprocessor Mainframe").tag(new TagKey[]{CustomTags.LuV_CIRCUITS}).register();
        QUANTUM_PROCESSOR_EV = GTRegistration.REGISTRATE.item("quantum_processor", Item::new).lang("Quantum Processor").tag(new TagKey[]{CustomTags.EV_CIRCUITS}).register();
        QUANTUM_ASSEMBLY_IV = GTRegistration.REGISTRATE.item("quantum_processor_assembly", Item::new).lang("Quantum Processor Assembly").tag(new TagKey[]{CustomTags.IV_CIRCUITS}).register();
        QUANTUM_COMPUTER_LuV = GTRegistration.REGISTRATE.item("quantum_processor_computer", Item::new).lang("Quantum Processor Supercomputer").tag(new TagKey[]{CustomTags.LuV_CIRCUITS}).register();
        QUANTUM_MAINFRAME_ZPM = GTRegistration.REGISTRATE.item("quantum_processor_mainframe", Item::new).lang("Quantum Processor Mainframe").tag(new TagKey[]{CustomTags.ZPM_CIRCUITS}).register();
        CRYSTAL_PROCESSOR_IV = GTRegistration.REGISTRATE.item("crystal_processor", Item::new).lang("Crystal Processor").tag(new TagKey[]{CustomTags.IV_CIRCUITS}).register();
        CRYSTAL_ASSEMBLY_LuV = GTRegistration.REGISTRATE.item("crystal_processor_assembly", Item::new).lang("Crystal Processor Assembly").tag(new TagKey[]{CustomTags.LuV_CIRCUITS}).register();
        CRYSTAL_COMPUTER_ZPM = GTRegistration.REGISTRATE.item("crystal_processor_computer", Item::new).lang("Crystal Processor Supercomputer").tag(new TagKey[]{CustomTags.ZPM_CIRCUITS}).register();
        CRYSTAL_MAINFRAME_UV = GTRegistration.REGISTRATE.item("crystal_processor_mainframe", Item::new).lang("Crystal Processor Mainframe").tag(new TagKey[]{CustomTags.UV_CIRCUITS}).register();
        WETWARE_PROCESSOR_LuV = GTRegistration.REGISTRATE.item("wetware_processor", Item::new).lang("Wetware Processor").tag(new TagKey[]{CustomTags.LuV_CIRCUITS}).register();
        WETWARE_PROCESSOR_ASSEMBLY_ZPM = GTRegistration.REGISTRATE.item("wetware_processor_assembly", Item::new).lang("Wetware Processor Assembly").tag(new TagKey[]{CustomTags.ZPM_CIRCUITS}).register();
        WETWARE_SUPER_COMPUTER_UV = GTRegistration.REGISTRATE.item("wetware_processor_computer", Item::new).lang("Wetware Processor Supercomputer").tag(new TagKey[]{CustomTags.UV_CIRCUITS}).register();
        WETWARE_MAINFRAME_UHV = GTRegistration.REGISTRATE.item("wetware_processor_mainframe", Item::new).lang("Wetware Processor Mainframe").tag(new TagKey[]{CustomTags.UHV_CIRCUITS}).register();
        COMPONENT_GRINDER_DIAMOND = ((ItemBuilder)GTRegistration.REGISTRATE.item("diamond_grinding_head", Item::new).lang("Diamond Grinding Head").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 29030400L), new MaterialStack(GTMaterials.Diamond, 18144000L))))).register();
        COMPONENT_GRINDER_TUNGSTEN = ((ItemBuilder)GTRegistration.REGISTRATE.item("tungsten_grinding_head", Item::new).lang("Tungsten Grinding Head").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Tungsten, 14515200L), new MaterialStack(GTMaterials.VanadiumSteel, 29030400L), new MaterialStack(GTMaterials.Diamond, 3628800L))))).register();
        IRON_MINECART_WHEELS = ((ItemBuilder)GTRegistration.REGISTRATE.item("iron_minecart_wheels", Item::new).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Iron, 3628800L))))).register();
        STEEL_MINECART_WHEELS = ((ItemBuilder)GTRegistration.REGISTRATE.item("steel_minecart_wheels", Item::new).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 3628800L))))).register();
        QUANTUM_EYE = GTRegistration.REGISTRATE.item("quantum_eye", Item::new).lang("Quantum Eye").register();
        QUANTUM_STAR = GTRegistration.REGISTRATE.item("quantum_star", Item::new).lang("Quantum Star").register();
        GRAVI_STAR = GTRegistration.REGISTRATE.item("gravi_star", Item::new).lang("Gravi-Star").register();
        ITEM_FILTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("item_filter", ComponentItem::create).onRegister(GTItems.attach(new ItemFilterBehaviour(SimpleItemFilter::loadFilter), new CoverPlaceBehavior(GTCovers.ITEM_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 7257600L), new MaterialStack(GTMaterials.Steel, 3628800L))))).register();
        TAG_FILTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("item_tag_filter", ComponentItem::create).lang("Item Tag Filter").onRegister(GTItems.attach(new ItemFilterBehaviour(TagItemFilter::loadFilter), new CoverPlaceBehavior(GTCovers.ITEM_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 7257600L))))).register();
        SMART_ITEM_FILTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("item_smart_filter", ComponentItem::create).lang("Smart Item Filter").onRegister(GTItems.attach(new ItemFilterBehaviour(SmartItemFilter::loadFilter), new CoverPlaceBehavior(GTCovers.ITEM_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 5443200L))))).register();
        FLUID_FILTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("fluid_filter", ComponentItem::create).onRegister(GTItems.attach(new FluidFilterBehaviour(SimpleFluidFilter::loadFilter), new CoverPlaceBehavior(GTCovers.FLUID_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 7257600L))))).register();
        TAG_FLUID_FILTER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("fluid_tag_filter", ComponentItem::create).lang("Fluid Tag Filter").onRegister(GTItems.attach(new FluidFilterBehaviour(TagFluidFilter::loadFilter), new CoverPlaceBehavior(GTCovers.FLUID_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 5443200L))))).register();
        COVER_WIRELESS_TRANSMITTER = ((ItemBuilder)GTRegistration.REGISTRATE.item("wireless_transmitter_cover", ComponentItem::create).lang("Wireless Transmitter").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.WIRELESS_TRANSMITTER)))).register();
        COVER_MACHINE_CONTROLLER = ((ItemBuilder)GTRegistration.REGISTRATE.item("machine_controller_cover", ComponentItem::create).lang("Machine Controller").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.MACHINE_CONTROLLER)))).register();
        COVER_ACTIVITY_DETECTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("activity_detector_cover", ComponentItem::create).lang("Activity Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ACTIVITY_DETECTOR)))).register();
        COVER_ACTIVITY_DETECTOR_ADVANCED = ((ItemBuilder)GTRegistration.REGISTRATE.item("advanced_activity_detector_cover", ComponentItem::create).lang("Advanced Activity Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ACTIVITY_DETECTOR_ADVANCED)))).register();
        COVER_FLUID_DETECTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("fluid_detector_cover", ComponentItem::create).lang("Fluid Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_DETECTOR)))).register();
        COVER_FLUID_DETECTOR_ADVANCED = ((ItemBuilder)GTRegistration.REGISTRATE.item("advanced_fluid_detector_cover", ComponentItem::create).lang("Advanced Fluid Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_DETECTOR_ADVANCED)))).register();
        COVER_ITEM_DETECTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("item_detector_cover", ComponentItem::create).lang("Item Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ITEM_DETECTOR)))).register();
        COVER_ITEM_DETECTOR_ADVANCED = ((ItemBuilder)GTRegistration.REGISTRATE.item("advanced_item_detector_cover", ComponentItem::create).lang("Advanced Item Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ITEM_DETECTOR_ADVANCED)))).register();
        COVER_ENERGY_DETECTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("energy_detector_cover", ComponentItem::create).lang("Energy Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ENERGY_DETECTOR)))).register();
        COVER_ENERGY_DETECTOR_ADVANCED = ((ItemBuilder)GTRegistration.REGISTRATE.item("advanced_energy_detector_cover", ComponentItem::create).lang("Advanced Energy Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ENERGY_DETECTOR_ADVANCED)))).register();
        COVER_MAINTENANCE_DETECTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("maintenance_detector_cover", ComponentItem::create).lang("Maintenance Detector").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.MAINTENANCE_DETECTOR)))).register();
        COVER_SCREEN = ((ItemBuilder)GTRegistration.REGISTRATE.item("computer_monitor_cover", ComponentItem::create).lang("Computer Monitor").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.COMPUTER_MONITOR)))).register();
        COVER_STORAGE = ((ItemBuilder)GTRegistration.REGISTRATE.item("storage_cover", ComponentItem::create).lang("Storage Cover").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.COVER_STORAGE)))).register();
        COVER_SHUTTER = ((ItemBuilder)GTRegistration.REGISTRATE.item("shutter_module_cover", ComponentItem::create).lang("Shutter Module").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SHUTTER)))).register();
        COVER_INFINITE_WATER = ((ItemBuilder)GTRegistration.REGISTRATE.item("infinite_water_cover", ComponentItem::create).lang("Infinite Water Cover").onRegister(GTItems.attach(new TooltipBehavior(lines -> lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{800}))), new CoverPlaceBehavior(GTCovers.INFINITE_WATER)))).register();
        COVER_ENDER_FLUID_LINK = ((ItemBuilder)GTRegistration.REGISTRATE.item("ender_fluid_link_cover", ComponentItem::create).lang("Ender Fluid Link").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ENDER_FLUID_LINK)))).register();
        COVER_ENDER_ITEM_LINK = ((ItemBuilder)GTRegistration.REGISTRATE.item("ender_item_link_cover", ComponentItem::create).lang("Ender Item Link").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ENDER_ITEM_LINK)))).register();
        COVER_ENDER_REDSTONE_LINK = ((ItemBuilder)GTRegistration.REGISTRATE.item("ender_redstone_link_cover", ComponentItem::create).lang("Ender Redstone Link").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ENDER_REDSTONE_LINK)))).register();
        COVER_FLUID_VOIDING = ((ItemBuilder)GTRegistration.REGISTRATE.item("fluid_voiding_cover", ComponentItem::create).lang("Fluid Voiding Cover").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_VOIDING)))).register();
        COVER_FLUID_VOIDING_ADVANCED = ((ItemBuilder)GTRegistration.REGISTRATE.item("advanced_fluid_voiding_cover", ComponentItem::create).lang("Advanced Fluid Voiding Cover").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.FLUID_VOIDING_ADVANCED)))).register();
        COVER_ITEM_VOIDING = ((ItemBuilder)GTRegistration.REGISTRATE.item("item_voiding_cover", ComponentItem::create).lang("Item Voiding Cover").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ITEM_VOIDING)))).register();
        COVER_ITEM_VOIDING_ADVANCED = ((ItemBuilder)GTRegistration.REGISTRATE.item("advanced_item_voiding_cover", ComponentItem::create).lang("Advanced Item Voiding Cover").onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.ITEM_VOIDING_ADVANCED)))).register();
        COVER_FACADE = ((ItemBuilder)GTRegistration.REGISTRATE.item("facade_cover", ComponentItem::create).lang("%s Cover Facade").onRegister(GTItems.attach(new FacadeItemBehaviour(), new CoverPlaceBehavior(GTCovers.FACADE)))).model(NonNullBiConsumer.noop()).register();
        COVER_SOLAR_PANEL = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("solar_panel", ComponentItem::create).lang("Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{1, GTValues.VNF[0]})))))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL_BASIC)))).register();
        COVER_SOLAR_PANEL_ULV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ulv_solar_panel", ComponentItem::create).lang("Ultra Low Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[0], GTValues.VNF[0]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[0])))).register();
        COVER_SOLAR_PANEL_LV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("lv_solar_panel", ComponentItem::create).lang("Low Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[1], GTValues.VNF[1]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[1])))).register();
        COVER_SOLAR_PANEL_MV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("mv_solar_panel", ComponentItem::create).lang("Medium Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[2], GTValues.VNF[2]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[2])))).register();
        COVER_SOLAR_PANEL_HV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("hv_solar_panel", ComponentItem::create).lang("High Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[3], GTValues.VNF[3]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[3])))).register();
        COVER_SOLAR_PANEL_EV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("ev_solar_panel", ComponentItem::create).lang("Extreme Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[4], GTValues.VNF[4]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[4])))).register();
        COVER_SOLAR_PANEL_IV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("iv_solar_panel", ComponentItem::create).lang("Insane Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[5], GTValues.VNF[5]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[5])))).register();
        COVER_SOLAR_PANEL_LuV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("luv_solar_panel", ComponentItem::create).lang("Ludicrous Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[6], GTValues.VNF[6]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[6])))).register();
        COVER_SOLAR_PANEL_ZPM = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_solar_panel", ComponentItem::create).lang("Zero Point Module Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[7], GTValues.VNF[7]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[7])))).register();
        COVER_SOLAR_PANEL_UV = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("uv_solar_panel", ComponentItem::create).lang("Ultimate Voltage Solar Panel").onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("item.gtceu.solar_panel.tooltip"));
            lines.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[8], GTValues.VNF[8]}));
        })))).onRegister(GTItems.attach((IItemComponent)new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[8])))).register();
        PROGRAMMED_CIRCUIT = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("programmed_circuit", ComponentItem::create).lang("Programmed Circuit").model(GTModels.overrideModel(GTCEu.id("circuit"), 33)).onRegister(GTItems.modelPredicate(GTCEu.id("circuit"), (ItemStack itemStack) -> (float)IntCircuitBehaviour.getCircuitConfiguration(itemStack) / 100.0f))).onRegister(GTItems.attach((IItemComponent)new IntCircuitBehaviour()))).register();
        GELLED_TOLUENE = GTRegistration.REGISTRATE.item("gelled_toluene", Item::new).register();
        BOTTLE_PURPLE_DRINK = ((ItemBuilder)GTRegistration.REGISTRATE.item("purple_drink", ComponentItem::create).lang("Purple Drink").onRegister(GTItems.attach((IItemComponent)new FoodStats(GTFoods.DRINK, true, () -> ((Item)Items.f_42590_).m_7968_())))).register();
        DOUGH = ((ItemBuilder)GTRegistration.REGISTRATE.item("dough", ComponentItem::create).lang("Dough").onRegister(GTItems.attach((IItemComponent)new FoodStats(new FoodProperties.Builder().m_38760_(1).effect(() -> new MobEffectInstance(MobEffects.f_19612_, 400), 0.4f).effect(() -> new MobEffectInstance(MobEffects.f_19614_, 100), 0.05f).m_38767_())))).tag(new TagKey[]{CustomTags.WHEAT_DOUGHS}).register();
        PLANT_BALL = ((ItemBuilder)GTRegistration.REGISTRATE.item("plant_ball", ComponentItem::create).onRegister(GTItems.burnTime(75))).register();
        STICKY_RESIN = ((ItemBuilder)GTRegistration.REGISTRATE.item("sticky_resin", ComponentItem::create).lang("Sticky Resin").onRegister(GTItems.burnTime(200))).register();
        BIO_CHAFF = ((ItemBuilder)GTRegistration.REGISTRATE.item("bio_chaff", ComponentItem::create).onRegister(GTItems.burnTime(200))).register();
        ENERGIUM_DUST = GTRegistration.REGISTRATE.item("energium_dust", Item::new).register();
        POWER_UNIT_LV = ((ItemBuilder)GTRegistration.REGISTRATE.item("lv_power_unit", ComponentItem::create).lang("LV Power Unit").properties(p -> p.m_41487_(8)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/tools/power_unit_lv")})).onRegister(GTItems.attach((IItemComponent)ElectricStats.createElectricItem(100000L, 1)))).register();
        POWER_UNIT_MV = ((ItemBuilder)GTRegistration.REGISTRATE.item("mv_power_unit", ComponentItem::create).lang("MV Power Unit").properties(p -> p.m_41487_(8)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/tools/power_unit_mv")})).onRegister(GTItems.attach((IItemComponent)ElectricStats.createElectricItem(400000L, 2)))).register();
        POWER_UNIT_HV = ((ItemBuilder)GTRegistration.REGISTRATE.item("hv_power_unit", ComponentItem::create).lang("HV Power Unit").properties(p -> p.m_41487_(8)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/tools/power_unit_hv")})).onRegister(GTItems.attach((IItemComponent)ElectricStats.createElectricItem(1600000L, 3)))).register();
        POWER_UNIT_EV = ((ItemBuilder)GTRegistration.REGISTRATE.item("ev_power_unit", ComponentItem::create).lang("EV Power Unit").properties(p -> p.m_41487_(8)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/tools/power_unit_ev")})).onRegister(GTItems.attach((IItemComponent)ElectricStats.createElectricItem(6400000L, 4)))).register();
        POWER_UNIT_IV = ((ItemBuilder)GTRegistration.REGISTRATE.item("iv_power_unit", ComponentItem::create).lang("IV Power Unit").properties(p -> p.m_41487_(8)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/tools/power_unit_iv")})).onRegister(GTItems.attach((IItemComponent)ElectricStats.createElectricItem(25600000L, 5)))).register();
        MASK_FILTER = GTRegistration.REGISTRATE.item("mask_filter", Item::new).lang("Gas Mask Filter").properties(p -> p.m_41487_(1)).register();
        PARACETAMOL_PILL = ((ItemBuilder)GTRegistration.REGISTRATE.item("paracetamol_pill", ComponentItem::create).lang("Paracetamol Pill").properties(p -> p.m_41489_(GTFoods.ANTIDOTE)).onRegister(GTItems.attach((IItemComponent)new AntidoteBehavior(10, GTMedicalConditions.CHEMICAL_BURNS, GTMedicalConditions.WEAK_POISON, GTMedicalConditions.NAUSEA, GTMedicalConditions.IRRITANT, GTMedicalConditions.METHANOL_POISONING, GTMedicalConditions.CARBON_MONOXIDE_POISONING)))).register();
        RAD_AWAY_PILL = ((ItemBuilder)GTRegistration.REGISTRATE.item("rad_away_pill", ComponentItem::create).lang("RadAway\u2122 Pill").properties(p -> p.m_41489_(GTFoods.ANTIDOTE)).onRegister(GTItems.attach((IItemComponent)new AntidoteBehavior(50, GTMedicalConditions.CARCINOGEN)))).register();
        NANO_SABER = ((ItemBuilder)((ItemBuilder)GTRegistration.REGISTRATE.item("nano_saber", ComponentItem::create).lang("Nano Saber").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(new NanoSaberBehavior(), ElectricStats.createElectricItem(4000000L, 3)))).model((ctx, prov) -> {
            ItemModelBuilder rootModel = prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("item/nano_saber/normal")});
            ((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/nano_saber/active")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", prov.modLoc("item/nano_saber/active"));
            rootModel.override().predicate(NanoSaberBehavior.OVERRIDE_KEY_LOCATION, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/nano_saber/active"))).end();
        }).onRegister(GTItems.modelPredicate(NanoSaberBehavior.OVERRIDE_KEY_LOCATION, () -> () -> (stack, level, entity, layer) -> NanoSaberBehavior.isItemActive(stack) ? 1.0f : 0.0f))).register();
        PROSPECTOR_LV = ((ItemBuilder)GTRegistration.REGISTRATE.item("prospector.lv", ComponentItem::create).lang("Ore Prospector (LV)").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(100000L, 1), new ProspectorScannerBehavior(2, GTValues.V[1] / 16L, ProspectorMode.ORE)))).register();
        PROSPECTOR_HV = ((ItemBuilder)GTRegistration.REGISTRATE.item("prospector.hv", ComponentItem::create).lang("Advanced Prospector (HV)").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(1600000L, 3), new ProspectorScannerBehavior(3, GTValues.V[3] / 16L, ProspectorMode.ORE, ProspectorMode.FLUID, ConfigHolder.INSTANCE.machines.doBedrockOres ? ProspectorMode.BEDROCK_ORE : null)))).register();
        PROSPECTOR_LuV = ((ItemBuilder)GTRegistration.REGISTRATE.item("prospector.luv", ComponentItem::create).lang("Super Prospector (LuV)").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(1000000000L, 6), new ProspectorScannerBehavior(5, GTValues.V[6] / 16L, ProspectorMode.ORE, ProspectorMode.FLUID, ConfigHolder.INSTANCE.machines.doBedrockOres ? ProspectorMode.BEDROCK_ORE : null)))).register();
        ITEM_MAGNET_LV = ((ItemBuilder)GTRegistration.REGISTRATE.item("lv_item_magnet", ComponentItem::create).lang("LV Item Magnet").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(100000L, 1), new ItemMagnetBehavior(8)))).register();
        ITEM_MAGNET_HV = ((ItemBuilder)GTRegistration.REGISTRATE.item("hv_item_magnet", ComponentItem::create).lang("HV Item Magnet").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach(ElectricStats.createElectricItem(1600000L, 3), new ItemMagnetBehavior(32)))).register();
        TERMINAL = ((ItemBuilder)GTRegistration.REGISTRATE.item("terminal", ComponentItem::create).lang("Terminal").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach((IItemComponent)new TerminalBehavior()))).register();
        MACHINE_MEMORY_CARD = ((ItemBuilder)GTRegistration.REGISTRATE.item("machine_memory_card", ComponentItem::create).lang("Machine Memory Card").properties(p -> p.m_41487_(1)).onRegister(GTItems.attach((IItemComponent)new MetaMachineConfigCopyBehaviour()))).register();
        DYE_ONLY_ITEMS = new ItemEntry[DyeColor.values().length];
        DyeColor[] colors = DyeColor.values();
        for (int i = 0; i < colors.length; ++i) {
            DyeColor dyeColor = colors[i];
            GTItems.DYE_ONLY_ITEMS[i] = GTRegistration.REGISTRATE.item("chemical_%s_dye".formatted(dyeColor.m_41065_()), props -> new DyeItem(dyeColor, props)).lang("Chemical %s Dye".formatted(FormattingUtil.toEnglishName(dyeColor.m_41065_()))).tag(new TagKey[]{TagUtil.createItemTag("dyes/" + dyeColor.m_41065_())}).register();
        }
        SPRAY_CAN_DYES = new ItemEntry[DyeColor.values().length];
        for (int i = 0; i < DyeColor.values().length; ++i) {
            DyeColor dyeColor = DyeColor.values()[i];
            GTItems.SPRAY_CAN_DYES[i] = ((ItemBuilder)GTRegistration.REGISTRATE.item("%s_dye_spray_can".formatted(dyeColor.m_41065_()), ComponentItem::create).lang("Spray Can (%s)".formatted(FormattingUtil.toEnglishName(dyeColor.m_41065_()))).properties(p -> p.m_41487_(1)).onRegister(GTItems.attach((IItemComponent)new ColorSprayBehaviour(() -> SPRAY_EMPTY.asStack(), 512, i)))).register();
        }
        TURBINE_ROTOR = ((ItemBuilder)GTRegistration.REGISTRATE.item("turbine_rotor", ComponentItem::create).lang("%s Turbine Rotor").properties(p -> p.m_41487_(1)).model((ctx, prov) -> GTModels.createTextureModel((DataGenContext<Item, ? extends Item>)ctx, prov, GTCEu.id("item/tools/turbine"))).color(() -> IMaterialPartItem::getItemStackColor).onRegister(GTItems.attach((IItemComponent)new TurbineRotorBehaviour()))).register();
        NEURO_PROCESSOR = GTRegistration.REGISTRATE.item("neuro_processing_unit", Item::new).lang("Neuro Processing Unit").register();
        STEM_CELLS = GTRegistration.REGISTRATE.item("stem_cells", Item::new).register();
        PETRI_DISH = GTRegistration.REGISTRATE.item("petri_dish", Item::new).register();
        VOLTAGE_COIL_ULV = ((ItemBuilder)GTRegistration.REGISTRATE.item("ulv_voltage_coil", ComponentItem::create).lang("Ultra Low Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Lead, 7257600L), new MaterialStack(GTMaterials.IronMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_LV = ((ItemBuilder)GTRegistration.REGISTRATE.item("lv_voltage_coil", ComponentItem::create).lang("Low Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 7257600L), new MaterialStack(GTMaterials.IronMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_MV = ((ItemBuilder)GTRegistration.REGISTRATE.item("mv_voltage_coil", ComponentItem::create).lang("Medium Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Aluminium, 7257600L), new MaterialStack(GTMaterials.SteelMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_HV = ((ItemBuilder)GTRegistration.REGISTRATE.item("hv_voltage_coil", ComponentItem::create).lang("High Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BlackSteel, 7257600L), new MaterialStack(GTMaterials.SteelMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_EV = ((ItemBuilder)GTRegistration.REGISTRATE.item("ev_voltage_coil", ComponentItem::create).lang("Extreme Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Platinum, 7257600L), new MaterialStack(GTMaterials.NeodymiumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_IV = ((ItemBuilder)GTRegistration.REGISTRATE.item("iv_voltage_coil", ComponentItem::create).lang("Insane Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Iridium, 7257600L), new MaterialStack(GTMaterials.NeodymiumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_LuV = ((ItemBuilder)GTRegistration.REGISTRATE.item("luv_voltage_coil", ComponentItem::create).lang("Ludicrous Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Osmiridium, 7257600L), new MaterialStack(GTMaterials.SamariumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_ZPM = ((ItemBuilder)GTRegistration.REGISTRATE.item("zpm_voltage_coil", ComponentItem::create).lang("Zero Point Module Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Europium, 7257600L), new MaterialStack(GTMaterials.SamariumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_UV = ((ItemBuilder)GTRegistration.REGISTRATE.item("uv_voltage_coil", ComponentItem::create).lang("Ultimate Voltage Coil").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Tritanium, 7257600L), new MaterialStack(GTMaterials.SamariumMagnetic, 1814400L))))).register();
        NIGHTVISION_GOGGLES = GTRegistration.REGISTRATE.item("nightvision_goggles", p -> new ArmorComponentItem(GTArmorMaterials.GOGGLES, ArmorItem.Type.HELMET, (Item.Properties)p).setArmorLogic(new NightvisionGoggles(2, 80000L * (long)Math.max(1.0, Math.pow(1.0, ConfigHolder.INSTANCE.tools.voltageTierNightVision - 1)), ConfigHolder.INSTANCE.tools.voltageTierNightVision, ArmorItem.Type.HELMET))).lang("Nightvision Goggles").tag(new TagKey[]{Tags.Items.ARMORS_HELMETS}).register();
        NANO_CHESTPLATE = GTRegistration.REGISTRATE.item("nanomuscle_chestplate", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new NanoMuscleSuite(ArmorItem.Type.CHESTPLATE, 512, 6400000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierNanoSuit - 3)), ConfigHolder.INSTANCE.tools.voltageTierNanoSuit))).lang("NanoMuscle\u2122 Suite Chestplate").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).register();
        NANO_LEGGINGS = GTRegistration.REGISTRATE.item("nanomuscle_leggings", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.LEGGINGS, (Item.Properties)p).setArmorLogic(new NanoMuscleSuite(ArmorItem.Type.LEGGINGS, 512, 6400000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierNanoSuit - 3)), ConfigHolder.INSTANCE.tools.voltageTierNanoSuit))).lang("NanoMuscle\u2122 Suite Leggings").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_LEGGINGS}).register();
        NANO_BOOTS = GTRegistration.REGISTRATE.item("nanomuscle_boots", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.BOOTS, (Item.Properties)p).setArmorLogic(new NanoMuscleSuite(ArmorItem.Type.BOOTS, 512, 6400000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierNanoSuit - 3)), ConfigHolder.INSTANCE.tools.voltageTierNanoSuit))).lang("NanoMuscle\u2122 Suite Boots").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_BOOTS}).tag(new TagKey[]{CustomTags.STEP_BOOTS}).register();
        NANO_HELMET = GTRegistration.REGISTRATE.item("nanomuscle_helmet", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.HELMET, (Item.Properties)p).setArmorLogic(new NanoMuscleSuite(ArmorItem.Type.HELMET, 512, 6400000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierNanoSuit - 3)), ConfigHolder.INSTANCE.tools.voltageTierNanoSuit))).lang("NanoMuscle\u2122 Suite Helmet").tag(new TagKey[]{Tags.Items.ARMORS_HELMETS}).properties(p -> p.m_41497_(Rarity.UNCOMMON)).register();
        FACE_MASK = ((ItemBuilder)GTRegistration.REGISTRATE.item("face_mask", p -> new ArmorComponentItem(GTArmorMaterials.BAD_PPE_EQUIPMENT, ArmorItem.Type.HELMET, (Item.Properties)p).setArmorLogic(new HazmatSuit(ArmorItem.Type.HELMET, "bad_hazmat"))).lang("Face Mask").tag(new TagKey[]{Tags.Items.ARMORS_HELMETS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(tooltips -> {
            tooltips.add(Component.m_237115_((String)"gtceu.hazard_trigger.protection.description"));
            tooltips.add(Component.m_237115_((String)"gtceu.hazard_trigger.inhalation"));
        })))).register();
        RUBBER_GLOVES = ((ItemBuilder)GTRegistration.REGISTRATE.item("rubber_gloves", p -> new ArmorComponentItem(GTArmorMaterials.BAD_PPE_EQUIPMENT, ArmorItem.Type.HELMET, (Item.Properties)p).setArmorLogic(new HazmatSuit(ArmorItem.Type.CHESTPLATE, "bad_hazmat"))).lang("Rubber Gloves").tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).onRegister(GTItems.attach((IItemComponent)new TooltipBehavior(tooltips -> {
            tooltips.add(Component.m_237115_((String)"gtceu.hazard_trigger.protection.description"));
            tooltips.add(Component.m_237115_((String)"gtceu.hazard_trigger.skin_contact"));
        })))).register();
        HAZMAT_CHESTPLATE = GTRegistration.REGISTRATE.item("hazmat_chestpiece", p -> new ArmorComponentItem(GTArmorMaterials.GOOD_PPE_EQUIPMENT, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new HazmatSuit(ArmorItem.Type.CHESTPLATE, "hazmat"))).lang("Hazardous Materials Suit Chestpiece").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        HAZMAT_LEGGINGS = GTRegistration.REGISTRATE.item("hazmat_leggings", p -> new ArmorComponentItem(GTArmorMaterials.GOOD_PPE_EQUIPMENT, ArmorItem.Type.LEGGINGS, (Item.Properties)p).setArmorLogic(new HazmatSuit(ArmorItem.Type.LEGGINGS, "hazmat"))).lang("Hazardous Materials Suit Leggings").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_LEGGINGS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        HAZMAT_BOOTS = GTRegistration.REGISTRATE.item("hazmat_boots", p -> new ArmorComponentItem(GTArmorMaterials.GOOD_PPE_EQUIPMENT, ArmorItem.Type.BOOTS, (Item.Properties)p).setArmorLogic(new HazmatSuit(ArmorItem.Type.BOOTS, "hazmat"))).lang("Hazardous Materials Suit Boots").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_BOOTS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        HAZMAT_HELMET = GTRegistration.REGISTRATE.item("hazmat_headpiece", p -> new ArmorComponentItem(GTArmorMaterials.GOOD_PPE_EQUIPMENT, ArmorItem.Type.HELMET, (Item.Properties)p).setArmorLogic(new HazmatSuit(ArmorItem.Type.HELMET, "hazmat"))).lang("Hazardous Materials Suit Headpiece").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_HELMETS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        QUANTUM_CHESTPLATE = GTRegistration.REGISTRATE.item("quarktech_chestplate", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new QuarkTechSuite(ArmorItem.Type.CHESTPLATE, 8192, 100000000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierQuarkTech - 5)), ConfigHolder.INSTANCE.tools.voltageTierQuarkTech))).lang("QuarkTech\u2122 Suite Chestplate").properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).tag(new TagKey[]{ItemTags.f_144320_}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        QUANTUM_LEGGINGS = GTRegistration.REGISTRATE.item("quarktech_leggings", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.LEGGINGS, (Item.Properties)p).setArmorLogic(new QuarkTechSuite(ArmorItem.Type.LEGGINGS, 8192, 100000000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierQuarkTech - 5)), ConfigHolder.INSTANCE.tools.voltageTierQuarkTech))).lang("QuarkTech\u2122 Suite Leggings").properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{Tags.Items.ARMORS_LEGGINGS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        QUANTUM_BOOTS = GTRegistration.REGISTRATE.item("quarktech_boots", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.BOOTS, (Item.Properties)p).setArmorLogic(new QuarkTechSuite(ArmorItem.Type.BOOTS, 8192, 100000000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierQuarkTech - 5)), ConfigHolder.INSTANCE.tools.voltageTierQuarkTech))).lang("QuarkTech\u2122 Suite Boots").properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{Tags.Items.ARMORS_BOOTS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).tag(new TagKey[]{CustomTags.STEP_BOOTS}).register();
        QUANTUM_HELMET = GTRegistration.REGISTRATE.item("quarktech_helmet", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.HELMET, (Item.Properties)p).setArmorLogic(new QuarkTechSuite(ArmorItem.Type.HELMET, 8192, 100000000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierQuarkTech - 5)), ConfigHolder.INSTANCE.tools.voltageTierQuarkTech))).lang("QuarkTech\u2122 Suite Helmet").properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{Tags.Items.ARMORS_HELMETS}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        LIQUID_FUEL_JETPACK = ((ItemBuilder)GTRegistration.REGISTRATE.item("liquid_fuel_jetpack", p -> new ArmorComponentItem(GTArmorMaterials.JETPACK, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new PowerlessJetpack())).lang("Liquid Fuel Jetpack").tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).register();
        ELECTRIC_JETPACK = ((ItemBuilder)GTRegistration.REGISTRATE.item("electric_jetpack", p -> new ArmorComponentItem(GTArmorMaterials.JETPACK, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new Jetpack(15, 1000000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierImpeller - 2)), ConfigHolder.INSTANCE.tools.voltageTierImpeller))).lang("Electric Jetpack").properties(p -> p.m_41497_(Rarity.UNCOMMON)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).model(GTModels.overrideModel(GTCEu.id("electric_jetpack"), 8)).onRegister(GTItems.modelPredicate(GTCEu.id("electric_jetpack"), ElectricStats::getStoredPredicate))).register();
        ELECTRIC_JETPACK_ADVANCED = GTRegistration.REGISTRATE.item("advanced_electric_jetpack", p -> new ArmorComponentItem(GTArmorMaterials.JETPACK, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new AdvancedJetpack(256, 6400000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierAdvImpeller - 4)), ConfigHolder.INSTANCE.tools.voltageTierAdvImpeller))).lang("Advanced Electric Jetpack").properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).register();
        NANO_CHESTPLATE_ADVANCED = GTRegistration.REGISTRATE.item("advanced_nanomuscle_chestplate", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new AdvancedNanoMuscleSuite(512, 12800000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierAdvNanoSuit - 3)), ConfigHolder.INSTANCE.tools.voltageTierAdvNanoSuit))).lang("Advanced NanoMuscle\u2122 Suite Chestplate").properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        QUANTUM_CHESTPLATE_ADVANCED = GTRegistration.REGISTRATE.item("advanced_quarktech_chestplate", p -> new ArmorComponentItem(GTArmorMaterials.ARMOR, ArmorItem.Type.CHESTPLATE, (Item.Properties)p).setArmorLogic(new AdvancedQuarkTechSuite(8192, 1000000000L * (long)Math.max(1.0, Math.pow(4.0, ConfigHolder.INSTANCE.tools.voltageTierAdvQuarkTech - 6)), ConfigHolder.INSTANCE.tools.voltageTierAdvQuarkTech))).lang("Advanced QuarkTech\u2122 Suite Chestplate").properties(p -> p.m_41497_(Rarity.EPIC)).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES}).tag(new TagKey[]{ItemTags.f_144320_}).tag(new TagKey[]{CustomTags.PPE_ARMOR}).register();
        POWER_THRUSTER = GTRegistration.REGISTRATE.item("power_thruster", Item::new).properties(p -> p.m_41497_(Rarity.UNCOMMON)).register();
        POWER_THRUSTER_ADVANCED = GTRegistration.REGISTRATE.item("advanced_power_thruster", Item::new).lang("Advanced Power Thruster").properties(p -> p.m_41497_(Rarity.RARE)).register();
        GRAVITATION_ENGINE = GTRegistration.REGISTRATE.item("gravitation_engine_unit", Item::new).lang("Gravitation Engine Unit").properties(p -> p.m_41497_(Rarity.EPIC)).register();
        SUS_RECORD = GTRegistration.REGISTRATE.item("sus_record", p -> new RecordItem(15, GTSoundEntries.SUS_RECORD::getMainEvent, p, 820)).lang("Music Disc").register();
        NAN_CERTIFICATE = GTRegistration.REGISTRATE.item("nan_certificate", Item::new).lang("Certificate of Not Being a Noob Anymore").properties(p -> p.m_41497_(Rarity.EPIC)).register();
        FERTILIZER = ((ItemBuilder)GTRegistration.REGISTRATE.item("fertilizer", ComponentItem::create).onRegister(GTItems.attach((IItemComponent)new FertilizerBehavior()))).register();
        BLACKLIGHT = GTRegistration.REGISTRATE.item("blacklight", Item::new).register();
        RUBBER_BOAT = GTRegistration.REGISTRATE.item("rubber_boat", p -> new GTBoatItem(false, GTBoat.BoatType.RUBBER, new Item.Properties())).lang("Rubber Boat").register();
        TREATED_WOOD_BOAT = GTRegistration.REGISTRATE.item("treated_wood_boat", p -> new GTBoatItem(false, GTBoat.BoatType.TREATED_WOOD, new Item.Properties())).lang("Treated Wood Boat").register();
        RUBBER_CHEST_BOAT = GTRegistration.REGISTRATE.item("rubber_chest_boat", p -> new GTBoatItem(true, GTBoat.BoatType.RUBBER, new Item.Properties())).lang("Rubber Boat with Chest").register();
        TREATED_WOOD_CHEST_BOAT = GTRegistration.REGISTRATE.item("treated_wood_chest_boat", p -> new GTBoatItem(true, GTBoat.BoatType.TREATED_WOOD, new Item.Properties())).lang("Treated Wood Boat with Chest").register();
        TEXT_MODULE = ((ItemBuilder)GTRegistration.REGISTRATE.item("text_module", ComponentItem::create).onRegister(GTItems.attach((IItemComponent)new TextModuleBehaviour()))).register();
        IMAGE_MODULE = ((ItemBuilder)GTRegistration.REGISTRATE.item("image_module", ComponentItem::create).onRegister(GTItems.attach((IItemComponent)new ImageModuleBehaviour()))).register();
    }

    @FunctionalInterface
    public static interface StackProperty {
        public float apply(ItemStack var1);
    }
}

