/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.fluid.potion;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTFluids;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluid;
import com.gregtechceu.gtceu.core.mixins.forge.StrictNBTIngredientAccessor;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class PotionFluidHelper {
    public static final int BOTTLE_AMOUNT = 250;
    public static final int MB_PER_RECIPE = 750;

    public static Pair<FluidStack, ItemStack> emptyPotion(ItemStack stack, boolean simulate) {
        FluidStack fluid = PotionFluidHelper.getFluidFromPotionItem(stack, 250);
        if (!simulate) {
            stack.m_41774_(1);
        }
        return Pair.of((Object)fluid, (Object)new ItemStack((ItemLike)Items.f_42590_));
    }

    public static FluidIngredient potionIngredient(Potion potion, int amount) {
        FluidStack stack = PotionFluidHelper.getFluidFromPotionItem(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion), amount);
        stack.setAmount(amount);
        return FluidIngredient.of(stack);
    }

    public static FluidIngredient getPotionFluidIngredientFrom(Ingredient potion, int amount) {
        if (potion instanceof StrictNBTIngredientAccessor) {
            StrictNBTIngredientAccessor strict = (StrictNBTIngredientAccessor)potion;
            return FluidIngredient.fromValue(new FluidIngredient.FluidValue((Fluid)GTFluids.POTION.get()), amount, strict.getStack().m_41783_());
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (ItemStack stack : potion.m_43908_()) {
            FluidStack fluidStack = PotionFluidHelper.getFluidFromPotionItem(stack, amount);
            if (fluidStack.isEmpty()) continue;
            fluids.add(fluidStack);
        }
        return FluidIngredient.of(fluids);
    }

    public static FluidStack getFluidFromPotionItem(ItemStack stack, int amount) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion == Potions.f_43598_) {
            return FluidStack.EMPTY;
        }
        List list = PotionUtils.m_43571_((ItemStack)stack);
        if (potion == Potions.f_43599_ && list.isEmpty()) {
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        return PotionFluid.withEffects(amount, potion, list);
    }

    public static FluidStack getFluidFromPotion(Potion potion, int amount) {
        if (potion == Potions.f_43599_) {
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        return PotionFluid.of(amount, potion);
    }

    public static ItemStack fillBottle(ItemStack stack, FluidStack availableFluid) {
        CompoundTag tag = availableFluid.getOrCreateTag();
        if (stack.m_150930_(Items.f_42590_)) {
            int count = stack.m_41613_();
            CompoundTag stackTag = stack.m_41783_();
            stack = new ItemStack((ItemLike)Items.f_42589_);
            stack.m_41764_(count);
            stack.m_41751_(stackTag);
        }
        PotionUtils.m_43549_((ItemStack)stack, (Potion)PotionUtils.m_43577_((CompoundTag)tag));
        PotionUtils.m_43552_((ItemStack)stack, (Collection)PotionUtils.m_43573_((CompoundTag)tag));
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(FluidStack fs, Consumer<Component> tooltip) {
        List list = PotionUtils.m_43566_((CompoundTag)fs.getOrCreateTag());
        ArrayList modifiers = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.accept((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectInstance : list) {
                MutableComponent name = Component.m_237115_((String)effectInstance.m_19576_());
                MobEffect effect = effectInstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        AttributeModifier mutated = new AttributeModifier(modifier.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), modifier), modifier.m_22217_());
                        modifiers.add(new Tuple((Object)((Attribute)entry.getKey()).m_22087_(), (Object)mutated));
                    }
                }
                if (effectInstance.m_19564_() > 0) {
                    name = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{name, Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_()))});
                }
                if (!effectInstance.m_267633_(20)) {
                    name = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{name, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)});
                }
                tooltip.accept((Component)name.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!modifiers.isEmpty()) {
            tooltip.accept((Component)Component.m_237119_());
            tooltip.accept((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Tuple tuple : modifiers) {
                AttributeModifier modifier2 = (AttributeModifier)tuple.m_14419_();
                double d0 = modifier2.m_22218_();
                double d1 = modifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier2.m_22218_() : modifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    tooltip.accept((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((String)tuple.m_14418_()))}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.accept((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((String)tuple.m_14418_()))}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static Component formatDuration(MobEffectInstance effect) {
        MutableComponent unit;
        Instant max;
        if (effect.m_267577_()) {
            return Component.m_237115_((String)"effect.duration.infinite");
        }
        int time = effect.m_19557_();
        Instant start = Instant.now();
        Duration durationMax = Duration.between(start, max = Instant.now().plusSeconds(time / 20));
        if (durationMax.getSeconds() <= 60L) {
            time = GTMath.saturatedCast(durationMax.getSeconds());
            unit = Component.m_237115_((String)"item.gtceu.battery.charge_unit.second");
        } else if (durationMax.toMinutes() <= 60L) {
            time = GTMath.saturatedCast(durationMax.toMinutes());
            unit = Component.m_237115_((String)"item.gtceu.battery.charge_unit.minute");
        } else {
            time = GTMath.saturatedCast(durationMax.toHours());
            unit = Component.m_237115_((String)"item.gtceu.battery.charge_unit.hour");
        }
        return Component.m_237113_((String)FormattingUtil.formatNumbers(time)).m_7220_((Component)unit);
    }
}

