/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.common.item.armor.NanoMuscleSuite;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedNanoMuscleSuite
extends NanoMuscleSuite
implements IJetpack {
    private long timer = 0L;
    private List<Pair<NonNullList<ItemStack>, IntList>> inventoryIndexMap;

    public AdvancedNanoMuscleSuite(int energyPerUse, long capacity, int tier) {
        super(ArmorItem.Type.CHESTPLATE, energyPerUse, capacity, tier);
    }

    @Override
    public void onArmorTick(Level world, Player player, @NotNull ItemStack item) {
        IElectricItem cont = GTCapabilityHelper.getElectricItem(item);
        if (cont == null) {
            return;
        }
        CompoundTag data = item.m_41784_();
        if (!data.m_128441_("enabled")) {
            data.m_128379_("enabled", true);
            data.m_128379_("hover", false);
            data.m_128344_("toggleTimer", (byte)0);
            data.m_128379_("canShare", false);
        }
        boolean jetpackEnabled = data.m_128471_("enabled");
        boolean hoverMode = data.m_128471_("hover");
        int toggleTimer = data.m_128445_("toggleTimer");
        boolean canShare = data.m_128471_("canShare");
        Object messageKey = null;
        if (toggleTimer == 0) {
            if (KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
                jetpackEnabled = !jetpackEnabled;
                messageKey = "metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable");
                data.m_128379_("enabled", jetpackEnabled);
            } else if (KeyBind.ARMOR_HOVER.isKeyDown(player)) {
                hoverMode = !hoverMode;
                messageKey = "metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable");
                data.m_128379_("hover", hoverMode);
            } else if (KeyBind.ARMOR_CHARGING.isKeyDown(player)) {
                boolean bl = canShare = !canShare;
                if (canShare && cont.getCharge() == 0L) {
                    messageKey = "metaarmor.nms.share.error";
                    canShare = false;
                } else {
                    messageKey = "metaarmor.nms.share." + (canShare ? "enable" : "disable");
                }
                data.m_128379_("canShare", canShare);
            }
            if (messageKey != null) {
                toggleTimer = 5;
                if (!world.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)messageKey), true);
                }
            }
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128344_("toggleTimer", (byte)toggleTimer);
        this.performFlying(player, jetpackEnabled, hoverMode, item);
        if (canShare && !world.f_46443_) {
            if (this.timer % 100L == 0L) {
                this.inventoryIndexMap = ArmorUtils.getChargeableItem(player, cont.getTier());
            }
            if (this.inventoryIndexMap != null && !this.inventoryIndexMap.isEmpty()) {
                for (int i = 0; i < this.inventoryIndexMap.size(); ++i) {
                    Pair<NonNullList<ItemStack>, IntList> inventoryMap = this.inventoryIndexMap.get(i);
                    IntListIterator inventoryIterator = ((IntList)inventoryMap.getSecond()).iterator();
                    while (inventoryIterator.hasNext()) {
                        int slot = inventoryIterator.nextInt();
                        IElectricItem chargable = GTCapabilityHelper.getElectricItem((ItemStack)((NonNullList)inventoryMap.getFirst()).get(slot));
                        if (chargable == null || chargable == cont) {
                            inventoryIterator.remove();
                            continue;
                        }
                        long attemptedChargeAmount = chargable.getTransferLimit() * 10L;
                        if (chargable.getCharge() >= chargable.getMaxCharge() || !cont.canUse(attemptedChargeAmount) || this.timer % 10L != 0L) continue;
                        long delta = chargable.charge(attemptedChargeAmount, cont.getTier(), true, false);
                        if (delta > 0L) {
                            cont.discharge(delta, cont.getTier(), true, false, false);
                        }
                        if (chargable.getCharge() == chargable.getMaxCharge()) {
                            inventoryIterator.remove();
                        }
                        player.f_36095_.m_150429_();
                    }
                    if (!((IntList)inventoryMap.getSecond()).isEmpty()) continue;
                    this.inventoryIndexMap.remove(inventoryMap);
                }
            }
        }
        ++this.timer;
        if (this.timer == Long.MAX_VALUE) {
            this.timer = 0L;
        }
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        CompoundTag data = itemStack.m_41784_();
        boolean enabled = !data.m_128441_("enabled") || data.m_128471_("enabled");
        MutableComponent state = enabled ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{state}));
        boolean canShare = data.m_128441_("canShare") && data.m_128471_("canShare");
        state = canShare ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.m_237110_((String)"metaarmor.energy_share.tooltip", (Object[])new Object[]{state}));
        lines.add((Component)Component.m_237115_((String)"metaarmor.energy_share.tooltip.guide"));
        boolean hover = data.m_128441_("hover") && data.m_128471_("hover");
        state = hover ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{state}));
    }

    @Override
    public InteractionResultHolder<ItemStack> onRightClick(Level world, @NotNull Player player, InteractionHand hand) {
        ItemStack armor = player.m_21120_(hand);
        if (armor.m_41720_() instanceof ArmorComponentItem && player.m_6144_()) {
            CompoundTag data = armor.m_41784_();
            boolean canShare = data.m_128441_("canShare") && data.m_128471_("canShare");
            IElectricItem cont = GTCapabilityHelper.getElectricItem(armor);
            if (cont == null) {
                return InteractionResultHolder.m_19100_((Object)armor);
            }
            boolean bl = canShare = !canShare;
            if (!world.f_46443_) {
                if (canShare && cont.getCharge() == 0L) {
                    player.m_213846_((Component)Component.m_237115_((String)"metaarmor.energy_share.error"));
                } else if (canShare) {
                    player.m_213846_((Component)Component.m_237115_((String)"metaarmor.energy_share.enable"));
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"metaarmor.energy_share.disable"));
                }
            }
            canShare = canShare && cont.getCharge() != 0L;
            data.m_128379_("canShare", canShare);
            return InteractionResultHolder.m_19090_((Object)armor);
        }
        return super.onRightClick(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        AdvancedNanoMuscleSuite.addCapacityHUD(item, this.HUD);
        IElectricItem cont = GTCapabilityHelper.getElectricItem(item);
        if (cont == null) {
            return;
        }
        if (!cont.canUse(this.energyPerUse)) {
            return;
        }
        CompoundTag data = item.m_41783_();
        if (data != null) {
            Object status;
            if (data.m_128441_("enabled")) {
                status = data.m_128471_("enabled") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                MutableComponent result = Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{status});
                this.HUD.newString((Component)result);
            }
            if (data.m_128441_("canShare")) {
                status = data.m_128471_("canShare") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
                this.HUD.newString((Component)Component.m_237110_((String)"mataarmor.hud.supply_mode", (Object[])new Object[]{Component.m_237115_((String)status)}));
            }
            if (data.m_128441_("hover")) {
                status = data.m_128471_("hover") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
                this.HUD.newString((Component)Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{Component.m_237115_((String)status)}));
            }
        }
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/advanced_nano_muscle_suite_1.png");
    }

    @Override
    public boolean canUseEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = AdvancedNanoMuscleSuite.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.canUse(amount);
    }

    @Override
    public void drainEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = AdvancedNanoMuscleSuite.getIElectricItem(stack);
        if (container == null) {
            return;
        }
        container.discharge(amount, this.tier, true, false, false);
    }

    @Override
    public boolean hasEnergy(@NotNull ItemStack stack) {
        IElectricItem container = AdvancedNanoMuscleSuite.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.getCharge() > 0L;
    }

    @Nullable
    private static IElectricItem getIElectricItem(@NotNull ItemStack stack) {
        return GTCapabilityHelper.getElectricItem(stack);
    }

    @Override
    public double getSprintEnergyModifier() {
        return 4.0;
    }

    @Override
    public double getSprintSpeedModifier() {
        return 1.8;
    }

    @Override
    public double getVerticalHoverSpeed() {
        return 0.4;
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.005;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.14;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.8;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.19;
    }

    @Override
    @Nullable
    public ParticleOptions getParticle() {
        return null;
    }

    @Override
    public float getFallDamageReduction() {
        return 3.5f;
    }

    @Override
    public boolean isPPE() {
        return true;
    }
}

