/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="gtceu", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEventHandlers {
    @SubscribeEvent
    public static void onPlayerDestroyItem(@NotNull PlayerDestroyItemEvent event) {
        ItemStack original = event.getOriginal();
        InteractionHand hand = event.getHand();
        Player player = event.getEntity();
        Item item = original.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool def = (IGTTool)item;
            ItemStack brokenStack = def.getToolStats().getBrokenStack();
            if (GTCapabilityHelper.getElectricItem(brokenStack) != null && def.isElectric()) {
                long remainingCharge = def.getCharge(original);
                IElectricItem electricStack = GTCapabilityHelper.getElectricItem(brokenStack);
                if (electricStack != null) {
                    if (electricStack instanceof ElectricItem) {
                        ElectricItem electricItem = (ElectricItem)electricStack;
                        electricItem.setMaxChargeOverride(def.getMaxCharge(original));
                    }
                    electricStack.charge(Math.min(remainingCharge, def.getMaxCharge(original)), def.getElectricTier(), true, false);
                }
            }
            if (!brokenStack.m_41619_()) {
                if (hand == null) {
                    if (!player.m_36356_(brokenStack)) {
                        player.m_36176_(brokenStack, true);
                    }
                } else {
                    player.m_21008_(hand, brokenStack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(@NotNull PlayerInteractEvent.EntityInteract event) {
        IGTTool toolItem;
        Item item;
        InteractionHand hand;
        Player player;
        block5: {
            block4: {
                player = event.getEntity();
                ItemStack stack = player.m_21120_(hand = event.getHand());
                item = stack.m_41720_();
                if (!(item instanceof IGTTool)) break block4;
                toolItem = (IGTTool)item;
                item = event.getTarget();
                if (item instanceof ItemFrame) break block5;
            }
            return;
        }
        ItemFrame itemFrame = (ItemFrame)item;
        ItemStack brokenStack = toolItem.getToolStats().getBrokenStack();
        if (!brokenStack.m_41619_()) {
            itemFrame.m_6096_(player, hand);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static List<ItemStack> onHarvestDrops(Player player, ItemStack tool, ServerLevel level, BlockPos pos, BlockState state, boolean isSilkTouch, int fortuneLevel, List<ItemStack> drops, float dropChance) {
        Item item;
        if (!tool.m_41782_() || !((item = tool.m_41720_()) instanceof IGTTool)) {
            return drops;
        }
        IGTTool toolItem = (IGTTool)item;
        if (!isSilkTouch) {
            ToolHelper.applyHammerDropConversion(level, pos, tool, state, drops, fortuneLevel, dropChance, player.m_217043_());
        }
        if (!ToolHelper.hasBehaviorsTag(tool)) {
            return drops;
        }
        CompoundTag behaviorTag = ToolHelper.getBehaviorsTag(tool);
        Block block = state.m_60734_();
        if (!isSilkTouch && state.m_204336_(BlockTags.f_13047_) && behaviorTag.m_128471_("HarvestIce")) {
            Item iceBlock = block.m_5456_();
            if (drops.stream().noneMatch(drop -> drop.m_150930_(iceBlock))) {
                drops.add(iceBlock.m_7968_());
                level.m_7654_().execute(() -> {
                    BlockState oldState = level.m_8055_(pos);
                    if (oldState.m_60819_().m_164512_((Fluid)Fluids.f_76193_)) {
                        BlockState newState = oldState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)oldState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : Blocks.f_50016_.m_49966_();
                        level.m_46597_(pos, newState);
                    }
                });
                toolItem.playSound(player);
            }
        }
        if (behaviorTag.m_128471_("RelocateMinedBlocks")) {
            drops = new ArrayList<ItemStack>(drops);
            Iterator<ItemStack> dropItr = drops.iterator();
            while (dropItr.hasNext()) {
                ItemStack dropStack = dropItr.next();
                ItemEntity drop2 = new ItemEntity(EntityType.f_20461_, (Level)level);
                drop2.m_32045_(dropStack);
                if (ForgeEventFactory.onItemPickup((ItemEntity)drop2, (Player)player) != -1 && !player.m_36356_(dropStack)) continue;
                dropItr.remove();
            }
        }
        return drops;
    }

    @SubscribeEvent
    public static void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Item item = left.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool leftTool = (IGTTool)item;
            item = right.m_41720_();
            if (item instanceof IGTTool) {
                IGTTool rightTool = (IGTTool)item;
                if (leftTool.isElectric() || rightTool.isElectric()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKilledEntity(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack tool = player.m_21205_();
        if (!ToolHelper.hasBehaviorsTag(tool)) {
            return;
        }
        CompoundTag behaviorTag = ToolHelper.getBehaviorsTag(tool);
        if (behaviorTag.m_128471_("RelocateMobDrops")) {
            Iterator dropItr = event.getDrops().iterator();
            while (dropItr.hasNext()) {
                ItemEntity drop = (ItemEntity)dropItr.next();
                ItemStack dropStack = drop.m_32055_();
                if (ForgeEventFactory.onItemPickup((ItemEntity)drop, (Player)player) != -1 && !player.m_36356_(dropStack)) continue;
                dropItr.remove();
            }
        }
    }
}

