/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoeGroundBehavior
implements IToolBehavior {
    public static final HoeGroundBehavior INSTANCE = new HoeGroundBehavior();

    protected HoeGroundBehavior() {
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return action == ToolActions.HOE_TILL;
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        List<BlockPos> blocks;
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (HoeGroundBehavior.isBlockTillable(context)) {
            if (aoeDefinition.isZero()) {
                blocks = List.of(pos);
            } else {
                blocks = HoeGroundBehavior.getTillableBlocks(aoeDefinition, context);
                blocks.add(0, context.m_8083_());
            }
        } else {
            return InteractionResult.PASS;
        }
        boolean tilled = false;
        for (BlockPos blockPos : blocks) {
            UseOnContext posContext = new UseOnContext(level, player, context.m_43724_(), stack, context.m_43718_().m_82430_(blockPos));
            tilled |= this.tillGround(posContext);
            ToolHelper.damageItem(stack, (LivingEntity)player);
            if (!stack.m_41619_()) continue;
            break;
        }
        if (tilled) {
            level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static List<BlockPos> getTillableBlocks(AoESymmetrical aoeDefinition, UseOnContext context) {
        return ToolHelper.iterateAoE(aoeDefinition, HoeGroundBehavior::isBlockTillable, context);
    }

    protected static boolean isBlockTillable(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        BlockState newState = state.getToolModifiedState(context, ToolActions.HOE_TILL, true);
        return newState != null && newState != state;
    }

    protected boolean tillGround(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        BlockState newState = state.getToolModifiedState(context, ToolActions.HOE_TILL, false);
        if (newState != null && newState != state) {
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)newState));
            return level.m_7731_(pos, newState, 11);
        }
        return false;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.ground_tilling"));
    }
}

