/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TorchPlaceBehavior
implements IToolBehavior {
    public static final TorchPlaceBehavior INSTANCE = new TorchPlaceBehavior();

    protected TorchPlaceBehavior() {
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        int i;
        int cachedTorchSlot;
        ItemStack slotStack;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        CompoundTag behaviourTag = ToolHelper.getBehaviorsTag(stack);
        if (!context.m_43723_().m_21206_().m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!behaviourTag.m_128471_("TorchPlacing")) {
            return InteractionResult.PASS;
        }
        if (behaviourTag.m_128471_("TorchPlacing$Slot") && TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack = (cachedTorchSlot = behaviourTag.m_128451_("TorchPlacing$Slot")) < 0 ? (ItemStack)player.m_150109_().f_35976_.get(0) : (ItemStack)player.m_150109_().f_35974_.get(cachedTorchSlot))) {
            return InteractionResult.SUCCESS;
        }
        for (i = 0; i < player.m_150109_().f_35976_.size(); ++i) {
            slotStack = (ItemStack)player.m_150109_().f_35976_.get(i);
            if (!TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack)) continue;
            behaviourTag.m_128405_("TorchPlacing$Slot", -(i + 1));
            return InteractionResult.SUCCESS;
        }
        for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            slotStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (!TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack)) continue;
            behaviourTag.m_128405_("TorchPlacing$Slot", i);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean checkAndPlaceTorch(UseOnContext context, ItemStack slotStack) {
        if (slotStack.m_41619_()) {
            return false;
        }
        Item slotItem = slotStack.m_41720_();
        if (slotItem != Items.f_42000_ && !slotStack.m_204117_(TagUtil.createItemTag("torches"))) {
            return false;
        }
        if (context.m_43723_() == null) {
            return false;
        }
        if (!(slotItem instanceof BlockItem)) {
            return false;
        }
        BlockItem slotItemBlock = (BlockItem)slotItem;
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        if (!state.m_247087_()) {
            pos = pos.m_121945_(context.m_43719_());
        }
        if (context.m_43723_().m_36204_(pos, context.m_43719_(), slotStack)) {
            UseOnContext torchContext = new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), slotStack, context.m_43718_());
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(torchContext);
            InteractionResult placed = slotItemBlock.m_40576_(blockPlaceContext);
            boolean wasPlaced = placed.m_19077_();
            if (wasPlaced) {
                SoundType sound = slotItemBlock.m_40614_().m_49962_(slotItemBlock.m_40614_().m_49966_());
                context.m_43725_().m_5594_(context.m_43723_(), pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            }
            return wasPlaced;
        }
        return false;
    }

    @Override
    public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull CompoundTag tag) {
        tag.m_128379_("TorchPlacing", true);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level Level2, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.torch_place"));
    }
}

