/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AssemblyLineMachine
extends WorkableElectricMultiblockMachine {
    @Persisted
    protected boolean allowCircuitSlots;

    public AssemblyLineMachine(IMachineBlockEntity holder, boolean allowCircuitSlots) {
        super(holder, new Object[0]);
        this.allowCircuitSlots = allowCircuitSlots;
    }

    public AssemblyLineMachine(IMachineBlockEntity holder) {
        this(holder, false);
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new AsslineRecipeLogic(this);
    }

    public static Comparator<IMultiPart> partSorter(MultiblockControllerMachine mc) {
        return Comparator.comparing(p -> p.self().getPos(), RelativeDirection.RIGHT.getSorter(mc.getFrontFacing(), mc.getUpwardsFacing(), mc.isFlipped()));
    }

    private boolean checkItemInputs(@NotNull GTRecipe recipe, boolean isTick) {
        List itemInputs = (isTick ? recipe.tickInputs : recipe.inputs).getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList());
        if (itemInputs.isEmpty()) {
            return true;
        }
        int inputsSize = itemInputs.size();
        List itemHandlers = this.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP);
        if (itemHandlers.size() < inputsSize) {
            return false;
        }
        List<ItemStack> itemInventory = itemHandlers.stream().filter(IRecipeHandler::shouldSearchContent).map(container -> container.getContents().stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).filter(s -> !s.m_41619_()).findFirst()).limit(inputsSize).map(o -> o.orElse(ItemStack.f_41583_)).toList();
        if (itemInventory.size() < inputsSize) {
            return false;
        }
        for (int i = 0; i < inputsSize; ++i) {
            ItemStack itemStack = itemInventory.get(i);
            Ingredient recipeStack = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemInputs.get((int)i)).content);
            if (recipeStack.test(itemStack)) continue;
            return false;
        }
        return true;
    }

    private ActionResult consumeItemContents(@NotNull GTRecipe recipe, boolean isTick) {
        List<Ingredient> left;
        NotifiableItemStackHandler itemBus;
        IRecipeHandler currentBus;
        Ingredient recipeStack;
        int i;
        List itemInputs = (isTick ? recipe.tickInputs : recipe.inputs).getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList());
        if (itemInputs.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        int inputsSize = itemInputs.size();
        List itemHandlers = this.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP);
        if (itemHandlers.size() < inputsSize) {
            return ActionResult.FAIL_NO_REASON;
        }
        List<IRecipeHandler> itemInventory = itemHandlers.stream().filter(IRecipeHandler::shouldSearchContent).toList();
        if (itemInventory.size() < inputsSize) {
            return ActionResult.FAIL_NO_REASON;
        }
        for (i = 0; i < inputsSize; ++i) {
            recipeStack = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemInputs.get((int)i)).content);
            currentBus = itemInventory.get(i);
            if (!(currentBus instanceof NotifiableItemStackHandler)) {
                throw new RuntimeException("Handler in Assline.consumeItemContent's ItemRecipeCapability.IN was not of type NotifiableItemStackHandler");
            }
            itemBus = (NotifiableItemStackHandler)currentBus;
            left = itemBus.handleRecipeInner(IO.IN, recipe, (List<Ingredient>)new ArrayList<Ingredient>(List.of(recipeStack)), true);
            if (left == null || left.isEmpty()) continue;
            return ActionResult.FAIL_NO_REASON;
        }
        for (i = 0; i < inputsSize; ++i) {
            recipeStack = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemInputs.get((int)i)).content);
            currentBus = itemInventory.get(i);
            if (!(currentBus instanceof NotifiableItemStackHandler)) {
                throw new RuntimeException("Handler in Assline.consumeItemContent's ItemRecipeCapability.IN was not of type NotifiableItemStackHandler");
            }
            itemBus = (NotifiableItemStackHandler)currentBus;
            left = itemBus.handleRecipeInner(IO.IN, recipe, (List<Ingredient>)new ArrayList<Ingredient>(List.of(recipeStack)), false);
            if (left == null || left.isEmpty()) continue;
            GTCEu.LOGGER.error("Recipe in Assline.consumeItemContents was true when simulating, but false when consuming.");
            return ActionResult.FAIL_NO_REASON;
        }
        return ActionResult.SUCCESS;
    }

    private boolean checkFluidInputs(@NotNull GTRecipe recipe, boolean isTick) {
        List fluidInputs = (isTick ? recipe.tickInputs : recipe.inputs).getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
        if (fluidInputs.isEmpty()) {
            return true;
        }
        int inputsSize = fluidInputs.size();
        List fluidHandlers = this.getCapabilitiesFlat(IO.IN, FluidRecipeCapability.CAP);
        if (fluidHandlers.size() < inputsSize) {
            return false;
        }
        List<FluidStack> fluidInventory = fluidHandlers.stream().filter(IRecipeHandler::shouldSearchContent).map(container -> container.getContents().stream().filter(FluidStack.class::isInstance).map(FluidStack.class::cast).filter(f -> !f.isEmpty()).findFirst()).limit(inputsSize).map(o -> o.orElse(FluidStack.EMPTY)).toList();
        if (fluidInventory.size() < inputsSize) {
            return false;
        }
        for (int i = 0; i < inputsSize; ++i) {
            FluidStack fluidStack = fluidInventory.get(i);
            FluidIngredient recipeStack = (FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidInputs.get((int)i)).content);
            if (recipeStack.test(fluidStack) && recipeStack.getAmount() <= fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private ActionResult consumeFluidContents(@NotNull GTRecipe recipe, boolean isTick) {
        List<FluidIngredient> left;
        NotifiableFluidTank fluidTank;
        IRecipeHandler currentBus;
        FluidIngredient recipeStack;
        int i;
        List fluidInputs = (isTick ? recipe.tickInputs : recipe.inputs).getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
        if (fluidInputs.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        int fluidsSize = fluidInputs.size();
        List fluidHandlers = this.getCapabilitiesFlat(IO.IN, FluidRecipeCapability.CAP);
        if (fluidHandlers.size() < fluidsSize) {
            return ActionResult.FAIL_NO_REASON;
        }
        List<IRecipeHandler> fluidInventory = fluidHandlers.stream().filter(IRecipeHandler::shouldSearchContent).toList();
        if (fluidInventory.size() < fluidsSize) {
            return ActionResult.FAIL_NO_REASON;
        }
        for (i = 0; i < fluidsSize; ++i) {
            recipeStack = (FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidInputs.get((int)i)).content);
            currentBus = fluidInventory.get(i);
            if (!(currentBus instanceof NotifiableFluidTank)) {
                throw new RuntimeException("Handler in Assline.consumeItemContent's FluidRecipeCapability.IN was not of type NotifiableFluidTank");
            }
            fluidTank = (NotifiableFluidTank)currentBus;
            left = fluidTank.handleRecipeInner(IO.IN, recipe, (List<FluidIngredient>)new ArrayList<FluidIngredient>(List.of(recipeStack)), true);
            if (left == null || left.isEmpty()) continue;
            return ActionResult.FAIL_NO_REASON;
        }
        for (i = 0; i < fluidsSize; ++i) {
            recipeStack = (FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidInputs.get((int)i)).content);
            currentBus = fluidInventory.get(i);
            if (!(currentBus instanceof NotifiableFluidTank)) {
                throw new RuntimeException("Handler in Assline.consumeItemContent's FluidRecipeCapability.IN was not of type NotifiableFluidTank");
            }
            fluidTank = (NotifiableFluidTank)currentBus;
            left = fluidTank.handleRecipeInner(IO.IN, recipe, (List<FluidIngredient>)new ArrayList<FluidIngredient>(List.of(recipeStack)), false);
            if (left == null || left.isEmpty()) continue;
            GTCEu.LOGGER.error("Recipe in Assline.consumeFluidContents was true when simulating, but false when consuming.");
            return ActionResult.FAIL_NO_REASON;
        }
        return ActionResult.SUCCESS;
    }

    private ActionResult consumeAll(@NotNull GTRecipe recipe, boolean isTick, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches) {
        ActionResult result;
        GTRecipe copyWithItems = recipe.copy();
        copyWithItems.inputs.clear();
        copyWithItems.tickInputs.clear();
        GTRecipe copyWithFluids = recipe.copy();
        copyWithFluids.inputs.clear();
        copyWithFluids.tickInputs.clear();
        GTRecipe copyWithoutItemsFluids = recipe.copy();
        copyWithoutItemsFluids.inputs.clear();
        copyWithoutItemsFluids.tickInputs.clear();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.inputs.entrySet()) {
            if (entry.getKey().equals(FluidRecipeCapability.CAP)) {
                copyWithFluids.inputs.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey().equals(ItemRecipeCapability.CAP)) {
                copyWithItems.inputs.put(entry.getKey(), entry.getValue());
                continue;
            }
            copyWithoutItemsFluids.inputs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.tickInputs.entrySet()) {
            if (entry.getKey().equals(FluidRecipeCapability.CAP)) {
                copyWithFluids.tickInputs.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey().equals(ItemRecipeCapability.CAP)) {
                copyWithItems.tickInputs.put(entry.getKey(), entry.getValue());
                continue;
            }
            copyWithoutItemsFluids.tickInputs.put(entry.getKey(), entry.getValue());
        }
        ConfigHolder.MachineConfigs config = ConfigHolder.INSTANCE.machines;
        if (config.orderedAssemblyLineItems) {
            result = this.consumeItemContents(copyWithItems, isTick);
        } else {
            ActionResult actionResult = result = isTick ? RecipeHelper.handleTickRecipeIO(this, copyWithItems, IO.IN, chanceCaches) : RecipeHelper.handleRecipeIO(this, copyWithItems, IO.IN, chanceCaches);
        }
        if (!result.isSuccess()) {
            return result;
        }
        if (config.orderedAssemblyLineFluids) {
            result = this.consumeFluidContents(copyWithFluids, isTick);
        } else {
            ActionResult actionResult = result = isTick ? RecipeHelper.handleTickRecipeIO(this, copyWithFluids, IO.IN, chanceCaches) : RecipeHelper.handleRecipeIO(this, copyWithFluids, IO.IN, chanceCaches);
        }
        if (!result.isSuccess()) {
            return result;
        }
        return isTick ? RecipeHelper.handleTickRecipeIO(this, copyWithoutItemsFluids, IO.IN, chanceCaches) : RecipeHelper.handleRecipeIO(this, copyWithoutItemsFluids, IO.IN, chanceCaches);
    }

    @Override
    @Generated
    public boolean allowCircuitSlots() {
        return this.allowCircuitSlots;
    }

    class AsslineRecipeLogic
    extends RecipeLogic {
        public AsslineRecipeLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        @Override
        protected ActionResult handleRecipeIO(GTRecipe recipe, IO io) {
            if (io.equals(IO.IN)) {
                return AssemblyLineMachine.this.consumeAll(recipe, false, this.getChanceCaches());
            }
            return RecipeHelper.handleRecipeIO(this.machine, recipe, io, this.chanceCaches);
        }

        @Override
        protected ActionResult handleTickRecipeIO(GTRecipe recipe, IO io) {
            if (io.equals(IO.IN)) {
                return AssemblyLineMachine.this.consumeAll(recipe, true, this.getChanceCaches());
            }
            return RecipeHelper.handleTickRecipeIO(this.machine, recipe, io, this.chanceCaches);
        }

        @Override
        protected ActionResult matchRecipe(GTRecipe recipe) {
            ActionResult normalMatch = RecipeHelper.matchContents(this.machine, recipe);
            if (!normalMatch.isSuccess()) {
                return normalMatch;
            }
            ConfigHolder.MachineConfigs config = ConfigHolder.INSTANCE.machines;
            if (!config.orderedAssemblyLineItems && !config.orderedAssemblyLineFluids) {
                return ActionResult.SUCCESS;
            }
            if (!AssemblyLineMachine.this.checkItemInputs(recipe, false)) {
                return ActionResult.FAIL_NO_REASON;
            }
            if (!AssemblyLineMachine.this.checkItemInputs(recipe, true)) {
                return ActionResult.FAIL_NO_REASON;
            }
            if (!config.orderedAssemblyLineFluids) {
                return ActionResult.SUCCESS;
            }
            if (!AssemblyLineMachine.this.checkFluidInputs(recipe, false)) {
                return ActionResult.FAIL_NO_REASON;
            }
            if (!AssemblyLineMachine.this.checkFluidInputs(recipe, true)) {
                return ActionResult.FAIL_NO_REASON;
            }
            return ActionResult.SUCCESS;
        }
    }
}

