/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.gcym;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class LargeMacerationTowerMachine
extends WorkableElectricMultiblockMachine {
    @NotNull
    private AABB grindBound = new AABB(BlockPos.f_121853_);
    @NotNull
    private final List<IItemHandler> handlers = new ArrayList<IItemHandler>();
    private TickableSubscription hurtSub;

    public LargeMacerationTowerMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.updateBounds();
        for (IRecipeHandler holder : this.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP)) {
            if (!(holder instanceof IItemHandler)) continue;
            IItemHandler ih = (IItemHandler)holder;
            this.handlers.add(ih);
        }
        this.hurtSub = this.subscribeServerTick(this::spinWheels);
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.unsubscribe(this.hurtSub);
        this.hurtSub = null;
        this.handlers.clear();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.unsubscribe(this.hurtSub);
        this.hurtSub = null;
        this.handlers.clear();
    }

    private void updateBounds() {
        BlockPos fl = RelativeDirection.offsetPos(this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped(), 1, 1, -1);
        BlockPos br = RelativeDirection.offsetPos(this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped(), 1, -2, -4);
        this.grindBound = AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)fl, (Vec3i)br));
    }

    private void spinWheels() {
        if (this.isRemote() || this.getLevel() == null) {
            return;
        }
        if (this.getOffsetTimer() % 10L != 0L) {
            return;
        }
        ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
        for (Entity entity : this.getLevel().m_45933_(null, this.grindBound)) {
            if (entity instanceof ItemEntity) {
                ItemEntity ie = (ItemEntity)entity;
                itemEntities.add(ie);
                continue;
            }
            if (!this.recipeLogic.isWorking()) continue;
            entity.m_6469_(entity.m_269291_().m_269354_(), 2.0f);
        }
        if (this.handlers.isEmpty()) {
            return;
        }
        block1: for (ItemEntity item : itemEntities) {
            if (item.m_213877_()) continue;
            for (IItemHandler holder : this.handlers) {
                item.m_32045_(ItemHandlerHelper.insertItem((IItemHandler)holder, (ItemStack)item.m_32055_(), (boolean)false));
                if (!item.m_32055_().m_41619_()) continue;
                item.m_146870_();
                continue block1;
            }
        }
    }
}

