/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part.monitor;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.machine.multiblock.part.monitor.MonitorPartMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class AdvancedMonitorPartMachine
extends MonitorPartMachine
implements IInteractedMachine {
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedMonitorPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private double clickPosX;
    @Persisted
    private double clickPosY;
    @Persisted
    private boolean clicked;
    @Persisted
    private boolean resetClickedNextTick = false;
    @Nullable
    private TickableSubscription clickResetSubscription;

    public AdvancedMonitorPartMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() != this.getFrontFacing()) {
            return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
        }
        this.clicked = true;
        this.clickPosX = hit.m_82450_().m_82507_(RelativeDirection.RIGHT.getRelative(this.getFrontFacing(), this.getUpwardsFacing(), false).m_122434_());
        this.clickPosY = hit.m_82450_().m_82507_(this.getFrontFacing().m_122434_().m_122478_() ? Direction.Axis.X : Direction.Axis.Y);
        this.clickPosX -= Math.floor(this.clickPosX);
        if (this.clickPosX < 0.0) {
            this.clickPosX += 1.0;
        }
        this.clickPosY -= Math.floor(this.clickPosY);
        if (this.clickPosY < 0.0) {
            this.clickPosY += 1.0;
        }
        return InteractionResult.SUCCESS;
    }

    public void resetClicked() {
        this.resetClickedNextTick = true;
    }

    private void unsetClicked() {
        if (this.resetClickedNextTick) {
            this.clicked = false;
        }
        this.resetClickedNextTick = false;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.clickResetSubscription = this.subscribeServerTick(this::unsetClicked);
    }

    @Override
    public void onUnload() {
        this.unsubscribe(this.clickResetSubscription);
    }

    @Generated
    public double getClickPosX() {
        return this.clickPosX;
    }

    @Generated
    public double getClickPosY() {
        return this.clickPosY;
    }

    @Generated
    public boolean isClicked() {
        return this.clicked;
    }
}

