/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class FTBOwner
extends MachineOwner {
    private static final Component displayName = Component.m_237115_((String)"gtceu.ownership.name.ftb");

    public FTBOwner(UUID playerUUID) {
        super(playerUUID);
    }

    @Nullable
    public Team getPlayerTeam(UUID playerUUID) {
        if (FTBTeamsAPI.api().isManagerLoaded()) {
            return FTBTeamsAPI.api().getManager().getPlayerTeamForPlayerID(playerUUID).orElse(null);
        }
        if (FTBTeamsAPI.api().isClientManagerLoaded()) {
            return FTBTeamsAPI.api().getClientManager().getTeams().stream().filter(t -> t.getMembers().contains(playerUUID)).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public Team getTeam() {
        return this.getPlayerTeam(this.playerUUID);
    }

    @Override
    public @UnmodifiableView @NotNull Set<UUID> getMembers() {
        Team team = this.getTeam();
        if (team == null) {
            return Collections.emptySet();
        }
        if (team.isPlayerTeam()) {
            return Collections.unmodifiableSet(((PlayerTeam)team).getEffectiveTeam().getMembers());
        }
        if (team.isPartyTeam() || team.isServerTeam()) {
            return Collections.unmodifiableSet(team.getMembers());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isPlayerInTeam(UUID playerUUID) {
        if (this.playerUUID.equals(playerUUID)) {
            return true;
        }
        if (FTBTeamsAPI.api().isManagerLoaded()) {
            return FTBTeamsAPI.api().getManager().arePlayersInSameTeam(playerUUID, this.playerUUID);
        }
        if (FTBTeamsAPI.api().isClientManagerLoaded()) {
            Team ownTeam = this.getPlayerTeam(this.playerUUID);
            if (ownTeam == null) {
                return false;
            }
            Team otherTeam = this.getPlayerTeam(playerUUID);
            return otherTeam != null && ownTeam.getTeamId().equals(otherTeam.getTeamId());
        }
        return true;
    }

    @Override
    public boolean isPlayerFriendly(UUID playerUUID) {
        Team team = this.getTeam();
        if (team == null) {
            return this.playerUUID.equals(playerUUID);
        }
        return team.getRankForPlayer(playerUUID).isAllyOrBetter();
    }

    @Override
    public UUID getUUID() {
        Team team = this.getTeam();
        return team != null ? team.getId() : EMPTY;
    }

    @Override
    public String getName() {
        Team team = this.getTeam();
        return team != null ? team.getName().getString() : Component.m_237115_((String)"gtceu.tooltip.status.trinary.unknown").getString();
    }

    @Override
    public Component getTypeDisplayName() {
        return displayName;
    }

    @Override
    public void displayInfo(List<Component> compList) {
        super.displayInfo(compList);
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.team_name", (Object[])new Object[]{this.getName()}));
        MachineOwner.displayPlayerInfo(compList, this.playerUUID);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof FTBOwner && super.equals(object);
    }
}

