/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CentralMonitorMachine;
import net.minecraft.util.Mth;

public class CentralMonitorLogic
extends RecipeLogic
implements IWorkable {
    private static final int BASE_UPDATE_INTERVAL = 160;

    public CentralMonitorLogic(IRecipeLogicMachine machine) {
        super(machine);
    }

    @Override
    public CentralMonitorMachine getMachine() {
        return (CentralMonitorMachine)this.machine;
    }

    private boolean consumeEnergy() {
        int tier = Mth.m_14045_((int)this.getMachine().getTier(), (int)0, (int)14);
        long energyToDrain = GTValues.VA[tier];
        EnergyContainerList energyContainer = this.getMachine().getFormedEnergyContainer();
        if (energyContainer == null) {
            return false;
        }
        long resultEnergy = energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= energyContainer.getEnergyCapacity()) {
            energyContainer.removeEnergy(energyToDrain);
            return true;
        }
        return false;
    }

    private int getUpdateInterval() {
        int interval = 160;
        for (int i = 1; i < this.getMachine().getTier(); ++i) {
            interval /= 2;
        }
        return Math.max(interval, 1);
    }

    @Override
    public void serverTick() {
        if (!this.getMachine().isFormed() || !this.isWorkingEnabled()) {
            this.setStatus(RecipeLogic.Status.IDLE);
        } else if (this.consumeEnergy()) {
            this.setStatus(RecipeLogic.Status.WORKING);
            this.isActive = true;
            this.progress = (this.progress + 1) % this.getUpdateInterval();
            if (this.progress == 0) {
                this.getMachine().tick();
            }
        } else {
            this.setStatus(RecipeLogic.Status.WAITING);
            this.isActive = false;
            this.progress = Math.max(this.progress - 2, 1);
        }
    }

    @Override
    public int getMaxProgress() {
        return this.getUpdateInterval();
    }

    @Override
    public boolean isActive() {
        return this.getMachine().isFormed() && this.isActive;
    }
}

