/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.utils.input.SyncedKeyMapping;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class CPacketKeyDown
implements GTNetwork.INetPacket {
    private final Int2BooleanMap updateKeys;

    public CPacketKeyDown(Int2BooleanMap updateKeys) {
        this.updateKeys = updateKeys;
    }

    public CPacketKeyDown(FriendlyByteBuf buf) {
        this.updateKeys = new Int2BooleanOpenHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.updateKeys.put(buf.readInt(), buf.readBoolean());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.updateKeys.size());
        for (Int2BooleanMap.Entry entry : this.updateKeys.int2BooleanEntrySet()) {
            buf.writeInt(entry.getIntKey());
            buf.writeBoolean(entry.getBooleanValue());
        }
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        if (context.getSender() != null) {
            for (Int2BooleanMap.Entry entry : this.updateKeys.int2BooleanEntrySet()) {
                SyncedKeyMapping keyMapping = SyncedKeyMapping.getFromSyncId(entry.getIntKey());
                keyMapping.serverActivate(entry.getBooleanValue(), context.getSender());
            }
        }
    }
}

