/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CentralMonitorMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;

public class SCPacketMonitorGroupNBTChange
implements GTNetwork.INetPacket {
    private final ItemStack stack;
    private final int monitorGroupId;
    private final BlockPos pos;

    public SCPacketMonitorGroupNBTChange(ItemStack stack, MonitorGroup group, CentralMonitorMachine machine) {
        this.stack = stack;
        this.monitorGroupId = machine.getMonitorGroups().indexOf(group);
        this.pos = machine.getPos();
    }

    public SCPacketMonitorGroupNBTChange(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.monitorGroupId = buf.m_130242_();
        this.pos = buf.m_130135_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.stack, false);
        buffer.m_130130_(this.monitorGroupId);
        buffer.m_130064_(this.pos);
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        Level level = ((Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide())).or(() -> Optional.ofNullable(context.getSender()).map(Entity::m_9236_)).orElse(null);
        if (level == null) {
            return;
        }
        MetaMachine machine = MetaMachine.getMachine((BlockGetter)level, this.pos);
        if (machine instanceof CentralMonitorMachine) {
            CentralMonitorMachine centralMonitor = (CentralMonitorMachine)machine;
            centralMonitor.getMonitorGroups().get(this.monitorGroupId).getItemStackHandler().setStackInSlot(0, this.stack);
        }
    }

    private static class ClientCallWrapper {
        private ClientCallWrapper() {
        }

        private static Level getClientLevel() {
            return Minecraft.m_91087_().f_91073_;
        }
    }
}

