/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public final class WireRecipeHandler {
    private static final Reference2IntMap<TagPrefix> INSULATION_AMOUNT = (Reference2IntMap)Util.m_137469_((Object)new Reference2IntOpenHashMap(), map -> {
        map.put((Object)TagPrefix.cableGtSingle, 1);
        map.put((Object)TagPrefix.cableGtDouble, 1);
        map.put((Object)TagPrefix.cableGtQuadruple, 2);
        map.put((Object)TagPrefix.cableGtOctal, 3);
        map.put((Object)TagPrefix.cableGtHex, 5);
    });
    private static final TagPrefix[] wireSizes = new TagPrefix[]{TagPrefix.wireGtDouble, TagPrefix.wireGtQuadruple, TagPrefix.wireGtOctal, TagPrefix.wireGtHex};

    private WireRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        WireProperties property = material.getProperty(PropertyKey.WIRE);
        if (property == null) {
            return;
        }
        WireRecipeHandler.processWires(provider, material);
        WireRecipeHandler.generateCableCovering(provider, property, TagPrefix.wireGtSingle, material);
        WireRecipeHandler.generateCableCovering(provider, property, TagPrefix.wireGtDouble, material);
        WireRecipeHandler.generateCableCovering(provider, property, TagPrefix.wireGtQuadruple, material);
        WireRecipeHandler.generateCableCovering(provider, property, TagPrefix.wireGtOctal, material);
        WireRecipeHandler.generateCableCovering(provider, property, TagPrefix.wireGtHex, material);
    }

    private static void processWires(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.wireGtSingle)) {
            return;
        }
        TagPrefix prefix = material.hasProperty(PropertyKey.INGOT) ? TagPrefix.ingot : (material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.dust);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_wire").inputItems(prefix, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_WIRE).outputItems(TagPrefix.wireGtSingle, material, 2).duration((int)material.getMass() * 2).EUt(6L * (long)WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire").inputItems(prefix, material).circuitMeta(1).outputItems(TagPrefix.wireGtSingle, material, 2).duration((int)material.getMass()).EUt(WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        for (TagPrefix wireSize : wireSizes) {
            int multiplier = (int)(wireSize.getMaterialAmount(material) / 3628800L);
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_" + multiplier * 2).inputItems(prefix, material, multiplier).circuitMeta(multiplier * 2).outputItems(wireSize, material).duration((int)material.getMass() * multiplier).EUt(WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_FINE_WIRE)) {
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_fine").inputItems(prefix, material, 1).circuitMeta(3).outputItems(TagPrefix.wireFine, material, 8).duration((int)material.getMass() * 3).EUt(WireRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
        if (!material.hasFlag(MaterialFlags.NO_WORKING) && material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_wire_single", material.getName()), ChemicalHelper.get(TagPrefix.wireGtSingle, material), "Xx", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, material));
        }
    }

    private static void generateCableCovering(@NotNull Consumer<FinishedRecipe> provider, @NotNull WireProperties property, @NotNull TagPrefix prefix, @NotNull Material material) {
        GTRecipeBuilder builder;
        if (!material.shouldGenerateRecipesFor(prefix) || property.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(prefix.getMaterialAmount(material) * 2L / 3628800L);
        TagPrefix cablePrefix = TagPrefix.get("cable" + prefix.name().substring(4));
        byte voltageTier = GTUtil.getTierByVoltage(property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.getInt((Object)cablePrefix);
        if (voltageTier <= 1) {
            WireRecipeHandler.generateManualRecipe(provider, prefix, cablePrefix, cableAmount, material);
        }
        if (voltageTier <= 4) {
            builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(prefix) + "_rubber").EUt(GTValues.VA[0]).duration(100).inputItems(prefix, material).outputItems(cablePrefix, material).inputFluids(GTMaterials.Rubber, 144 * insulationAmount);
            if (voltageTier == 4) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            }
            builder.save(provider);
        }
        builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(prefix) + "_silicone").EUt(GTValues.VA[0]).duration(100).inputItems(prefix, material).outputItems(cablePrefix, material);
        if (voltageTier >= 6) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 4) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
        }
        builder.inputFluids(GTMaterials.SiliconeRubber.getFluid(144 * insulationAmount / 2)).save(provider);
        builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(prefix) + "_styrene_butadiene").EUt(GTValues.VA[0]).duration(100).inputItems(prefix, material).outputItems(cablePrefix, material);
        if (voltageTier >= 6) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 4) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
        }
        builder.inputFluids(GTMaterials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4)).save(provider);
    }

    private static void generateManualRecipe(@NotNull Consumer<FinishedRecipe> provider, @NotNull TagPrefix wirePrefix, @NotNull TagPrefix cablePrefix, int cableAmount, @NotNull Material material) {
        int insulationAmount = INSULATION_AMOUNT.getInt((Object)cablePrefix);
        Object[] ingredients = new Object[insulationAmount + 1];
        ingredients[0] = new MaterialEntry(wirePrefix, material);
        for (int i = 1; i <= insulationAmount; ++i) {
            ingredients[i] = ChemicalHelper.get(TagPrefix.plate, GTMaterials.Rubber);
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("%s_cable_%d", material.getName(), cableAmount), ChemicalHelper.get(cablePrefix, material), ingredients);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix)).inputItems(wirePrefix, material).inputItems(TagPrefix.plate, GTMaterials.Rubber, insulationAmount).outputItems(cablePrefix, material).duration(100).EUt(GTValues.VA[0]).save(provider);
    }

    private static int getVoltageMultiplier(@NotNull Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

