/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KJSSteamMachineBuilder
extends BuilderBase<MachineDefinition> {
    public volatile boolean hasLowPressure = true;
    public volatile boolean hasHighPressure = true;
    public volatile SteamCreationFunction machine = (x$0, x$1) -> new SimpleSteamMachine(x$0, x$1, new Object[0]);
    public volatile SteamDefinitionFunction definition = (isHP, def) -> def.tier(isHP ? 1 : 0);
    private volatile MachineBuilder<?> lowPressureBuilder = null;
    private volatile MachineBuilder<?> highPressureBuilder = null;
    private volatile MachineDefinition hpValue = null;

    public KJSSteamMachineBuilder(ResourceLocation id) {
        super(id);
    }

    @Override
    public MachineDefinition register() {
        if (this.hasLowPressure) {
            this.lowPressureBuilder = GTRegistration.REGISTRATE.machine(String.format("lp_%s", this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, false));
            this.lowPressureBuilder.langValue("Low Pressure " + FormattingUtil.toEnglishName(this.id.m_135815_())).tier(0).recipeModifier(SimpleSteamMachine::recipeModifier).modelProperty(GTMachineModelProperties.VENT_DIRECTION, RelativeDirection.BACK).workableSteamHullModel(false, this.id.m_246208_("block/machines/"));
            this.definition.apply(false, this.lowPressureBuilder);
            this.value = this.lowPressureBuilder.register();
        }
        if (this.hasHighPressure) {
            this.highPressureBuilder = GTRegistration.REGISTRATE.machine(String.format("hp_%s", this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, true));
            this.highPressureBuilder.langValue("High Pressure " + FormattingUtil.toEnglishName(this.id.m_135815_())).tier(1).recipeModifier(SimpleSteamMachine::recipeModifier).modelProperty(GTMachineModelProperties.VENT_DIRECTION, RelativeDirection.BACK).workableSteamHullModel(true, this.id.m_246208_("block/machines/"));
            this.definition.apply(true, this.highPressureBuilder);
            this.hpValue = this.highPressureBuilder.register();
        }
        return this.value != null ? (MachineDefinition)this.value : this.hpValue;
    }

    @Override
    public void generateAssetJsons(@Nullable AssetJsonGenerator generator) {
        super.generateAssetJsons(generator);
        if (this.lowPressureBuilder != null) {
            this.lowPressureBuilder.generateAssetJsons(generator);
        }
        if (this.highPressureBuilder != null) {
            this.highPressureBuilder.generateAssetJsons(generator);
        }
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        if (this.value != null) {
            lang.add("gtceu", ((MachineDefinition)this.value).getDescriptionId(), ((MachineDefinition)this.value).getLangValue());
        }
        if (this.hpValue != null) {
            lang.add("gtceu", this.hpValue.getDescriptionId(), this.hpValue.getLangValue());
        }
    }

    @Override
    public MachineDefinition get() {
        return this.value != null ? (MachineDefinition)this.value : this.hpValue;
    }

    @NotNull
    @Generated
    public KJSSteamMachineBuilder hasLowPressure(boolean hasLowPressure) {
        this.hasLowPressure = hasLowPressure;
        return this;
    }

    @NotNull
    @Generated
    public KJSSteamMachineBuilder hasHighPressure(boolean hasHighPressure) {
        this.hasHighPressure = hasHighPressure;
        return this;
    }

    @NotNull
    @Generated
    public KJSSteamMachineBuilder machine(SteamCreationFunction machine) {
        this.machine = machine;
        return this;
    }

    @NotNull
    @Generated
    public KJSSteamMachineBuilder definition(SteamDefinitionFunction definition) {
        this.definition = definition;
        return this;
    }

    @FunctionalInterface
    public static interface SteamCreationFunction {
        public MetaMachine create(IMachineBlockEntity var1, boolean var2);
    }

    @FunctionalInterface
    public static interface SteamDefinitionFunction {
        public void apply(boolean var1, MachineBuilder<?> var2);
    }
}

