/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CableInfoProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return GTCEu.id("cable_info");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        CableBlock cableBlock;
        CableBlockEntity cable;
        Block block = blockState.m_60734_();
        if (block instanceof CableBlock && (cable = (CableBlockEntity)(cableBlock = (CableBlock)block).getPipeTile((BlockGetter)level, iProbeHitData.getPos())) != null) {
            long voltage = cable.getCurrentMaxVoltage();
            double amperage = cable.getAverageAmperage();
            IProbeInfo horizontalPane = iProbeInfo.horizontal(iProbeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.text((Component)Component.m_237115_((String)"gtceu.top.cable_voltage"));
            if (voltage != 0L) {
                horizontalPane.text(GTValues.VNF[GTUtil.getTierByVoltage(voltage)]).text(" / ");
            }
            horizontalPane.text(GTValues.VNF[GTUtil.getTierByVoltage(cable.getMaxVoltage())]);
            horizontalPane = iProbeInfo.horizontal(iProbeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.text((Component)Component.m_237115_((String)"gtceu.top.cable_amperage"));
            if (amperage != 0.0) {
                horizontalPane.text(FormattingUtil.DECIMAL_FORMAT_1F.format(cable.getAverageAmperage()) + "A / ");
            }
            horizontalPane.text(FormattingUtil.DECIMAL_FORMAT_1F.format(cable.getMaxAmperage()) + "A");
        }
    }
}

