/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public interface IMachineBlock
extends EntityBlock {
    default public Block self() {
        return (Block)this;
    }

    public MachineDefinition getDefinition();

    default public RotationState getRotationState() {
        return this.getDefinition().getRotationState();
    }

    default public Direction getFrontFacing(BlockState state) {
        return this.getRotationState() == RotationState.NONE ? Direction.NORTH : (Direction)state.m_61143_((Property)this.getRotationState().property);
    }

    @Nullable
    default public MetaMachine getMachine(BlockGetter level, BlockPos pos) {
        return MetaMachine.getMachine(level, pos);
    }

    public static int colorTinted(BlockState blockState, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        MetaMachine machine;
        if (level != null && pos != null && (machine = MetaMachine.getMachine((BlockGetter)level, pos)) != null) {
            return machine.tintColor(index);
        }
        return -1;
    }

    @Nullable
    default public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.getDefinition().getBlockEntityType().m_155264_(pos, state);
    }

    @Nullable
    default public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getDefinition().getBlockEntityType()) {
            if (!level.f_46443_) {
                return (pLevel, pPos, pState, pTile) -> {
                    if (pTile instanceof IMachineBlockEntity) {
                        IMachineBlockEntity metaMachine = (IMachineBlockEntity)pTile;
                        metaMachine.getMetaMachine().serverTick();
                    }
                };
            }
            return (pLevel, pPos, pState, pTile) -> {
                if (pTile instanceof IMachineBlockEntity) {
                    IMachineBlockEntity metaMachine = (IMachineBlockEntity)pTile;
                    metaMachine.getMetaMachine().clientTick();
                }
            };
        }
        return null;
    }

    default public boolean canConnectRedstone(BlockGetter level, BlockPos pos, Direction side) {
        return this.getMachine(level, pos).canConnectRedstone(side);
    }
}

