/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IFilteredHandler;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface IRecipeHandler<K>
extends IFilteredHandler<K> {
    public static final Comparator<IRecipeHandler<?>> ENTRY_COMPARATOR = (o1, o2) -> {
        int prio = IFilteredHandler.PRIORITY_COMPARATOR.compare((IFilteredHandler<?>)o1, (IFilteredHandler<?>)o2);
        if (prio != 0) {
            return prio;
        }
        boolean empty1 = o1.getTotalContentAmount() <= 0.0;
        boolean empty2 = o2.getTotalContentAmount() <= 0.0;
        return Boolean.compare(empty1, empty2);
    };

    public List<K> handleRecipeInner(IO var1, GTRecipe var2, List<K> var3, boolean var4);

    default public int getSize() {
        return -1;
    }

    @NotNull
    public List<Object> getContents();

    public double getTotalContentAmount();

    default public boolean isDistinct() {
        return false;
    }

    default public boolean shouldSearchContent() {
        return true;
    }

    public RecipeCapability<K> getCapability();

    default public K copyContent(Object content) {
        return (K)this.getCapability().copyInner(content);
    }

    default public List<K> handleRecipe(IO io, GTRecipe recipe, List<?> left, boolean simulate) {
        ObjectArrayList contents = new ObjectArrayList(left.size());
        for (Object leftObj : left) {
            contents.add(this.copyContent(leftObj));
        }
        return this.handleRecipeInner(io, recipe, (List<K>)contents, simulate);
    }
}

