/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class MaterialProperties {
    private static final Set<PropertyKey<?>> baseTypes = new HashSet<PropertyKey>(Arrays.asList(PropertyKey.FLUID, PropertyKey.DUST, PropertyKey.INGOT, PropertyKey.GEM, PropertyKey.EMPTY));
    private final Map<PropertyKey<? extends IMaterialProperty>, IMaterialProperty> propertyMap = new HashMap<PropertyKey<? extends IMaterialProperty>, IMaterialProperty>();
    private Material material;

    public static void addBaseType(PropertyKey<?> baseTypeKey) {
        baseTypes.add(baseTypeKey);
    }

    public boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    public <T extends IMaterialProperty> T getProperty(PropertyKey<T> key) {
        return key.cast(this.propertyMap.get(key));
    }

    public <T extends IMaterialProperty> boolean hasProperty(PropertyKey<T> key) {
        return this.propertyMap.containsKey(key);
    }

    public <T extends IMaterialProperty> void setProperty(PropertyKey<T> key, IMaterialProperty value) {
        if (value == null) {
            throw new IllegalArgumentException("Material Property must not be null!");
        }
        if (!key.getType().isInstance(value)) {
            throw new IllegalArgumentException("Material Property must be of the same type as the property key!");
        }
        if (this.hasProperty(key)) {
            throw new IllegalArgumentException("Material Property " + key.toString() + " already registered!");
        }
        this.propertyMap.put(key, value);
        this.propertyMap.remove(PropertyKey.EMPTY);
    }

    public <T extends IMaterialProperty> void removeProperty(PropertyKey<T> property) {
        if (!this.hasProperty(property)) {
            throw new IllegalArgumentException("Material Property " + property.toString() + " not present!");
        }
        this.propertyMap.remove(property);
        if (this.propertyMap.isEmpty()) {
            this.propertyMap.put(PropertyKey.EMPTY, PropertyKey.EMPTY.constructDefault());
        }
    }

    public <T extends IMaterialProperty> void ensureSet(PropertyKey<T> key, boolean verify) {
        if (!this.hasProperty(key)) {
            this.propertyMap.put((PropertyKey<? extends IMaterialProperty>)key, (IMaterialProperty)key.constructDefault());
            this.propertyMap.remove(PropertyKey.EMPTY);
            if (verify) {
                this.verify();
            }
        }
    }

    public <T extends IMaterialProperty> void ensureSet(PropertyKey<T> key) {
        this.ensureSet(key, false);
    }

    public void verify() {
        ArrayList<IMaterialProperty> oldList;
        do {
            oldList = new ArrayList<IMaterialProperty>(this.propertyMap.values());
            oldList.forEach(p -> p.verifyProperty(this));
        } while (oldList.size() != this.propertyMap.size());
        if (this.propertyMap.keySet().stream().noneMatch(baseTypes::contains)) {
            if (this.propertyMap.isEmpty()) {
                if (GTCEu.isDev()) {
                    GTCEu.LOGGER.debug("Creating empty placeholder Material {}", (Object)this.material);
                }
                this.propertyMap.put(PropertyKey.EMPTY, PropertyKey.EMPTY.constructDefault());
            } else {
                throw new IllegalArgumentException("Material must have at least one of: " + String.valueOf(baseTypes) + " specified!");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.propertyMap.forEach((k, v) -> sb.append(k.toString()).append("\n"));
        return sb.toString();
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public void setMaterial(Material material) {
        this.material = material;
    }
}

