/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidVeinWorldEntry {
    private final MemoizedSupplier<BedrockFluidDefinition> vein;
    @Nullable
    private String veinId;
    private int fluidYield;
    private int operationsRemaining;

    public FluidVeinWorldEntry(@Nullable BedrockFluidDefinition vein, int fluidYield, int operationsRemaining) {
        this(GTMemoizer.memoize(() -> vein));
        ResourceLocation key;
        if (vein != null && (key = (ResourceLocation)GTRegistries.BEDROCK_FLUID_DEFINITIONS.getKey(vein)) != null) {
            this.veinId = key.toString();
        }
        this.fluidYield = fluidYield;
        this.operationsRemaining = operationsRemaining;
    }

    private FluidVeinWorldEntry(MemoizedSupplier<BedrockFluidDefinition> vein) {
        this.vein = vein;
    }

    @Nullable
    public BedrockFluidDefinition getVein() {
        return this.vein.get();
    }

    @Nullable
    public BedrockFluidDefinition getDefinition() {
        return this.vein.get();
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("fluidYield", this.fluidYield);
        tag.m_128405_("operationsRemaining", this.operationsRemaining);
        if (this.veinId != null) {
            tag.m_128359_("vein", this.veinId);
        }
        return tag;
    }

    @NotNull
    public static FluidVeinWorldEntry readFromNBT(@NotNull CompoundTag tag) {
        MemoizedSupplier<BedrockFluidDefinition> vein;
        String veinId;
        if (tag.m_128441_("vein")) {
            veinId = tag.m_128461_("vein");
            vein = GTMemoizer.memoize(() -> {
                ResourceLocation key = new ResourceLocation(veinId);
                return (BedrockFluidDefinition)GTRegistries.BEDROCK_FLUID_DEFINITIONS.get(key);
            });
        } else {
            veinId = null;
            vein = GTMemoizer.memoize(() -> null);
        }
        FluidVeinWorldEntry info = new FluidVeinWorldEntry(vein);
        info.veinId = veinId;
        info.fluidYield = tag.m_128451_("fluidYield");
        info.operationsRemaining = tag.m_128451_("operationsRemaining");
        return info;
    }

    @Nullable
    @Generated
    public String getVeinId() {
        return this.veinId;
    }

    @Generated
    public int getFluidYield() {
        return this.fluidYield;
    }

    @Generated
    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

