/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreVeinWorldEntry {
    @Nullable
    private BedrockOreDefinition definition;
    private int oreYield;
    private int operationsRemaining;

    public OreVeinWorldEntry(@Nullable BedrockOreDefinition vein, int oreYield, int operationsRemaining) {
        this.definition = vein;
        this.oreYield = oreYield;
        this.operationsRemaining = operationsRemaining;
    }

    private OreVeinWorldEntry() {
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("oreYield", this.oreYield);
        tag.m_128405_("operationsRemaining", this.operationsRemaining);
        if (this.definition != null && GTRegistries.BEDROCK_ORE_DEFINITIONS.getKey(this.definition) != null) {
            tag.m_128359_("vein", ((ResourceLocation)GTRegistries.BEDROCK_ORE_DEFINITIONS.getKey(this.definition)).toString());
        }
        return tag;
    }

    @NotNull
    public static OreVeinWorldEntry readFromNBT(@NotNull CompoundTag tag) {
        ResourceLocation id;
        OreVeinWorldEntry info = new OreVeinWorldEntry();
        info.oreYield = tag.m_128451_("oreYield");
        info.operationsRemaining = tag.m_128451_("operationsRemaining");
        if (tag.m_128441_("vein") && GTRegistries.BEDROCK_ORE_DEFINITIONS.containKey(id = new ResourceLocation(tag.m_128461_("vein")))) {
            info.definition = (BedrockOreDefinition)GTRegistries.BEDROCK_ORE_DEFINITIONS.get(id);
        }
        return info;
    }

    @Nullable
    @Generated
    public BedrockOreDefinition getDefinition() {
        return this.definition;
    }

    @Generated
    public int getOreYield() {
        return this.oreYield;
    }

    @Generated
    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

