/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.ClassicVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.NotNull;

public class CuboidVeinGenerator
extends VeinGenerator {
    public static final Codec<CuboidVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ClassicVeinGenerator.Layer.CODEC.fieldOf("top").forGetter(val -> val.top), (App)ClassicVeinGenerator.Layer.CODEC.fieldOf("middle").forGetter(val -> val.middle), (App)ClassicVeinGenerator.Layer.CODEC.fieldOf("bottom").forGetter(val -> val.bottom), (App)ClassicVeinGenerator.Layer.CODEC.fieldOf("spread").forGetter(val -> val.spread), (App)Codec.INT.fieldOf("min_y").forGetter(val -> val.minY), (App)Codec.INT.fieldOf("max_y").forGetter(val -> val.maxY)).apply((Applicative)instance, CuboidVeinGenerator::new));
    private ClassicVeinGenerator.Layer top;
    private ClassicVeinGenerator.Layer middle;
    private ClassicVeinGenerator.Layer bottom;
    private ClassicVeinGenerator.Layer spread;
    private int minY;
    private int maxY;
    private int spreadDivisor;
    private int totalLayers;
    private int bottomLayer;
    private int middleLayer1;
    private int middleLayer2;
    private int topLayer;

    public CuboidVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public CuboidVeinGenerator(ClassicVeinGenerator.Layer top, ClassicVeinGenerator.Layer middle, ClassicVeinGenerator.Layer bottom, ClassicVeinGenerator.Layer spread, int minY, int maxY) {
        this.top = top;
        this.middle = middle;
        this.bottom = bottom;
        this.spread = spread;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public List<VeinGenerator.VeinEntry> getAllEntries() {
        ArrayList<VeinGenerator.VeinEntry> entries = new ArrayList<VeinGenerator.VeinEntry>(this.top.size() + this.middle.size() + this.bottom.size() + this.spread.size());
        VeinGenerator.mapTarget(this.top.target, this.top.layers).forEach(entries::add);
        VeinGenerator.mapTarget(this.middle.target, this.middle.layers).forEach(entries::add);
        VeinGenerator.mapTarget(this.bottom.target, this.bottom.layers).forEach(entries::add);
        VeinGenerator.mapTarget(this.spread.target, 1).forEach(entries::add);
        return entries;
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        int size = entry.clusterSize().m_214085_(random) / 2;
        int westBound = origin.m_123341_() - random.m_188503_(size);
        int eastBound = origin.m_123341_() + 16 + random.m_188503_(size);
        int northBound = origin.m_123343_() - random.m_188503_(size);
        int southBound = origin.m_123343_() + 16 + random.m_188503_(size);
        int startY = this.minY + random.m_188503_(this.maxY - this.minY - 5) - 1;
        for (int layerOffset = 0; layerOffset <= this.totalLayers; ++layerOffset) {
            int layer = startY + layerOffset;
            if (level.m_151562_(layer)) continue;
            for (int x = westBound; x < eastBound; ++x) {
                for (int z = northBound; z < southBound; ++z) {
                    long randomSeed = random.m_188505_();
                    int xLength = x - origin.m_123341_();
                    int zLength = z - origin.m_123343_();
                    double volume = Math.sqrt(2 + xLength * xLength + zLength * zLength);
                    int localDensity = (int)Math.max(1.0, (double)(8.0f * entry.density()) / volume);
                    int weightX = Math.max(1, Math.max(Mth.m_14040_((int)(westBound - x)), Mth.m_14040_((int)(eastBound - x))) / localDensity);
                    int weightZ = Math.max(1, Math.max(Mth.m_14040_((int)(southBound - z)), Mth.m_14040_((int)(northBound - z))) / localDensity);
                    BlockPos pos = new BlockPos(x, layer, z);
                    if (layerOffset <= this.bottomLayer) {
                        if (this.placeBottom((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ);
                        continue;
                    }
                    if (layerOffset <= this.middleLayer1) {
                        if (this.placeMiddle((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ) || this.placeBottom((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ);
                        continue;
                    }
                    if (layerOffset <= this.middleLayer2) {
                        if (this.placeMiddle((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ);
                        continue;
                    }
                    if (layerOffset <= this.topLayer) {
                        if (this.placeMiddle((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ) || this.placeTop((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ);
                        continue;
                    }
                    if (this.placeTop((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                    this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ);
                }
            }
        }
        return generatedBlocks;
    }

    protected static boolean shouldPlaceOre(@NotNull RandomSource random, int weightX, int weightZ) {
        return random.m_188503_(weightX) == 0 || random.m_188503_(weightZ) == 0;
    }

    private boolean placeTop(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> top = this.top.target;
        if (CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, top, entry));
            return true;
        }
        return false;
    }

    private boolean placeMiddle(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> middle = this.middle.target;
        if (random.m_188503_(2) == 0 && CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, middle, entry));
            return true;
        }
        return false;
    }

    private boolean placeBottom(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> bottom = this.bottom.target;
        if (CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, bottom, entry));
            return true;
        }
        return false;
    }

    private boolean placeSpread(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> spread = this.spread.target;
        if (random.m_188501_() <= entry.density() * (float)this.spreadDivisor && CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, spread, entry));
            return true;
        }
        return false;
    }

    public void placeOre(BulkSectionAccess access, LevelChunkSection section, BlockPos pos, long randomSeed, Either<List<OreConfiguration.TargetBlockState>, Material> ore, GTOreDefinition entry) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
        int x = SectionPos.m_123207_((int)pos.m_123341_());
        int y = SectionPos.m_123207_((int)pos.m_123342_());
        int z = SectionPos.m_123207_((int)pos.m_123343_());
        BlockState existing = section.m_62982_(x, y, z);
        ore.ifLeft(arg_0 -> CuboidVeinGenerator.lambda$placeOre$11(existing, access, (RandomSource)random, entry, pos, section, x, y, z, arg_0)).ifRight(arg_0 -> CuboidVeinGenerator.lambda$placeOre$12(existing, access, (RandomSource)random, entry, pos, section, x, y, z, arg_0));
    }

    @Override
    public VeinGenerator build() {
        this.top.layers = this.top.layers == -1 ? 2 : this.top.layers;
        this.middle.layers = this.middle.layers == -1 ? 3 : this.middle.layers;
        this.bottom.layers = this.bottom.layers == -1 ? 2 : this.bottom.layers;
        Preconditions.checkArgument((this.top.layers + this.bottom.layers >= this.middle.layers ? 1 : 0) != 0, (Object)"Error: cannot have more \"middle\" layers than top and bottom layers combined!");
        this.totalLayers = this.top.layers + this.middle.layers + this.bottom.layers;
        this.bottomLayer = (int)((float)this.totalLayers / 7.0f * 2.0f);
        this.middleLayer1 = (int)((float)this.totalLayers / 7.0f * 3.0f);
        this.middleLayer2 = (int)((float)this.totalLayers / 7.0f * 4.0f);
        this.topLayer = (int)((float)this.totalLayers / 7.0f * 6.0f);
        this.spreadDivisor = (this.top.layers + this.middle.layers - 1) / 2;
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new CuboidVeinGenerator(this.top.copy(), this.middle.copy(), this.bottom.copy(), this.spread.copy(), this.minY, this.maxY);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public CuboidVeinGenerator top(Consumer<ClassicVeinGenerator.Layer.Builder> builder) {
        ClassicVeinGenerator.Layer.Builder layerBuilder = new ClassicVeinGenerator.Layer.Builder(new RuleTest[]{AlwaysTrueTest.f_73954_});
        builder.accept(layerBuilder);
        this.top = layerBuilder.build();
        return this;
    }

    public CuboidVeinGenerator middle(Consumer<ClassicVeinGenerator.Layer.Builder> builder) {
        ClassicVeinGenerator.Layer.Builder layerBuilder = new ClassicVeinGenerator.Layer.Builder(new RuleTest[]{AlwaysTrueTest.f_73954_});
        builder.accept(layerBuilder);
        this.middle = layerBuilder.build();
        return this;
    }

    public CuboidVeinGenerator bottom(Consumer<ClassicVeinGenerator.Layer.Builder> builder) {
        ClassicVeinGenerator.Layer.Builder layerBuilder = new ClassicVeinGenerator.Layer.Builder(new RuleTest[]{AlwaysTrueTest.f_73954_});
        builder.accept(layerBuilder);
        this.bottom = layerBuilder.build();
        return this;
    }

    public CuboidVeinGenerator spread(Consumer<ClassicVeinGenerator.Layer.Builder> builder) {
        ClassicVeinGenerator.Layer.Builder layerBuilder = new ClassicVeinGenerator.Layer.Builder(new RuleTest[]{AlwaysTrueTest.f_73954_});
        builder.accept(layerBuilder);
        this.spread = layerBuilder.build();
        return this;
    }

    @NotNull
    @Generated
    public CuboidVeinGenerator minY(int minY) {
        this.minY = minY;
        return this;
    }

    @NotNull
    @Generated
    public CuboidVeinGenerator maxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    private static /* synthetic */ void lambda$placeOre$12(BlockState existing, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos pos, LevelChunkSection section, int x, int y, int z, Material material) {
        if (!OreVeinUtil.canPlaceOre(existing, arg_0 -> ((BulkSectionAccess)access).m_156110_(arg_0), random, entry, pos)) {
            return;
        }
        BlockState currentState = access.m_156110_(pos);
        Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
        if (prefix.isEmpty()) {
            return;
        }
        Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
        if (toPlace == null || toPlace.m_49966_().m_60795_()) {
            return;
        }
        section.m_62991_(x, y, z, toPlace.m_49966_(), false);
    }

    private static /* synthetic */ void lambda$placeOre$11(BlockState existing, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos pos, LevelChunkSection section, int x, int y, int z, List blockStates) {
        for (OreConfiguration.TargetBlockState targetState : blockStates) {
            if (!OreVeinUtil.canPlaceOre(existing, arg_0 -> ((BulkSectionAccess)access).m_156110_(arg_0), random, entry, targetState, pos) || targetState.f_161033_.m_60795_()) continue;
            section.m_62991_(x, y, z, targetState.f_161033_, false);
            break;
        }
    }
}

