/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ScrollablePhantomFluidWidget
extends PhantomFluidWidget {
    private static final int SCROLL_ACTION_ID = 65537;

    public ScrollablePhantomFluidWidget(@Nullable IFluidHandlerModifiable fluidTank, int tank, int x, int y, int width, int height, Supplier<FluidStack> phantomFluidGetter, Consumer<FluidStack> phantomFluidSetter) {
        super((IFluidHandler)fluidTank, tank, x, y, width, height, phantomFluidGetter, phantomFluidSetter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        int delta = this.getModifiedChangeAmount(wheelDelta > 0.0 ? 1 : -1);
        this.writeClientAction(65537, buf -> buf.writeInt(delta));
        return true;
    }

    private int getModifiedChangeAmount(int amount) {
        if (GTUtil.isShiftDown()) {
            amount *= 10;
        }
        if (GTUtil.isCtrlDown()) {
            amount *= 100;
        }
        if (!GTUtil.isAltDown()) {
            amount *= 1000;
        }
        return amount;
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        switch (id) {
            case 65537: {
                this.handleScrollAction(buffer.readInt());
                break;
            }
            default: {
                super.handleClientAction(id, buffer);
            }
        }
        this.detectAndSendChanges();
    }

    private void handleScrollAction(int delta) {
        IFluidHandlerModifiable fluidTank = (IFluidHandlerModifiable)this.getFluidTank();
        if (fluidTank == null) {
            return;
        }
        FluidStack fluid = fluidTank.getFluidInTank(this.tank);
        if (fluid.isEmpty()) {
            return;
        }
        if (fluid.isEmpty()) {
            return;
        }
        fluid.setAmount(Math.min(Math.max(fluid.getAmount() + delta, 0), fluidTank.getTankCapacity(this.tank)));
        if ((long)fluid.getAmount() <= 0L) {
            fluidTank.setFluidInTank(this.tank, FluidStack.EMPTY);
        }
    }
}

