/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.component;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMaterialPartItem
extends IItemComponent,
IDurabilityBar,
IAddInformation,
ICustomDescriptionId {
    public int getPartMaxDurability(ItemStack var1);

    @Nullable
    default public CompoundTag getPartStatsTag(ItemStack itemStack) {
        return itemStack.m_41737_("GT.PartStats");
    }

    default public CompoundTag getOrCreatePartStatsTag(ItemStack itemStack) {
        return itemStack.m_41698_("GT.PartStats");
    }

    default public Material getPartMaterial(ItemStack itemStack) {
        CompoundTag compound = this.getPartStatsTag(itemStack);
        Material defaultMaterial = GTMaterials.Neutronium;
        if (compound == null || !compound.m_128425_("Material", 8)) {
            return defaultMaterial;
        }
        String materialName = compound.m_128461_("Material");
        Material material = GTMaterials.get(materialName);
        if (material.isNull() || !material.hasProperty(PropertyKey.INGOT)) {
            return defaultMaterial;
        }
        return material;
    }

    default public void setPartMaterial(ItemStack itemStack, @NotNull Material material) {
        if (!material.hasProperty(PropertyKey.INGOT)) {
            throw new IllegalArgumentException("Part material must have an Ingot!");
        }
        CompoundTag compound = this.getOrCreatePartStatsTag(itemStack);
        compound.m_128359_("Material", material.getResourceLocation().toString());
    }

    default public int getPartDamage(ItemStack itemStack) {
        CompoundTag compound = this.getPartStatsTag(itemStack);
        if (compound == null || !compound.m_128425_("Damage", 99)) {
            return 0;
        }
        return compound.m_128451_("Damage");
    }

    default public void setPartDamage(ItemStack itemStack, int damage) {
        CompoundTag compound = this.getOrCreatePartStatsTag(itemStack);
        compound.m_128405_("Damage", Math.min(this.getPartMaxDurability(itemStack), damage));
    }

    @Override
    @Nullable
    default public Component getItemName(ItemStack stack) {
        Material material = this.getPartMaterial(stack);
        return Component.m_237110_((String)stack.m_41778_(), (Object[])new Object[]{material.getLocalizedName()});
    }

    @Override
    default public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Material material = this.getPartMaterial(stack);
        int maxDurability = this.getPartMaxDurability(stack);
        int damage = this.getPartDamage(stack);
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.tool.tooltip.durability", (Object[])new Object[]{maxDurability - damage, maxDurability}));
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{material.getLocalizedName()}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor getItemStackColor() {
        return (itemStack, i) -> {
            Item patt3694$temp = itemStack.m_41720_();
            if (patt3694$temp instanceof IComponentItem) {
                IComponentItem componentItem = (IComponentItem)patt3694$temp;
                for (IItemComponent component : componentItem.getComponents()) {
                    if (!(component instanceof IMaterialPartItem)) continue;
                    IMaterialPartItem materialPartItem = (IMaterialPartItem)component;
                    return materialPartItem.getPartMaterial(itemStack).getMaterialARGB();
                }
            }
            return -1;
        };
    }

    @Override
    default public float getDurabilityForDisplay(ItemStack itemStack) {
        int maxDurability = this.getPartMaxDurability(itemStack);
        return (float)(maxDurability - this.getPartDamage(itemStack)) / (float)maxDurability;
    }

    @Override
    default public int getMaxDurability(ItemStack stack) {
        return this.getPartMaxDurability(stack);
    }
}

