/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class MachineModeFancyConfigurator
implements IFancyUIProvider {
    protected IRecipeLogicMachine machine;

    public MachineModeFancyConfigurator(IRecipeLogicMachine machine) {
        this.machine = machine;
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"gtceu.gui.machinemode.title");
    }

    @Override
    public IGuiTexture getTabIcon() {
        return new ItemStackTexture(new Item[]{(Item)GTItems.ROBOT_ARM_LV.get()});
    }

    @Override
    public Widget createMainPage(FancyMachineUIWidget widget) {
        MachineModeConfigurator group = new MachineModeConfigurator(0, 0, 140, 20 * this.machine.getRecipeTypes().length + 4);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        for (int i = 0; i < this.machine.getRecipeTypes().length; ++i) {
            int finalI = i;
            group.addWidget((Widget)new ButtonWidget(2, 2 + i * 20, 136, 20, IGuiTexture.EMPTY, cd -> this.setActiveRecipeTypeAndUpdateTickSubs(finalI)));
            group.addWidget((Widget)new ImageWidget(2, 2 + i * 20, 136, 20, () -> new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON.copy().setColor(this.machine.getActiveRecipeType() == finalI ? ColorPattern.CYAN.color : -1), new TextTexture(this.machine.getRecipeTypes()[finalI].registryName.m_214298_()).setWidth(136).setType(TextTexture.TextType.ROLL)})));
        }
        return group;
    }

    @Override
    public List<Component> getTabTooltips() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237115_((String)"gtceu.gui.machinemode.tab_tooltip"));
        return tooltip;
    }

    private void setActiveRecipeTypeAndUpdateTickSubs(int activeRecipeType) {
        boolean needUpdateTickSubs = !this.machine.keepSubscribing() && activeRecipeType != this.machine.getActiveRecipeType();
        this.machine.setActiveRecipeType(activeRecipeType);
        if (needUpdateTickSubs) {
            this.machine.getRecipeLogic().updateTickSubscription();
        }
    }

    public class MachineModeConfigurator
    extends WidgetGroup {
        public MachineModeConfigurator(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public void writeInitialData(FriendlyByteBuf buffer) {
            buffer.m_130130_(MachineModeFancyConfigurator.this.machine.getActiveRecipeType());
        }

        public void readInitialData(FriendlyByteBuf buffer) {
            MachineModeFancyConfigurator.this.machine.setActiveRecipeType(buffer.m_130242_());
        }

        public void detectAndSendChanges() {
            this.writeUpdateInfo(0, buf -> buf.m_130130_(MachineModeFancyConfigurator.this.machine.getActiveRecipeType()));
        }

        public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
            if (id == 0) {
                MachineModeFancyConfigurator.this.machine.setActiveRecipeType(buffer.m_130242_());
            }
        }
    }
}

