/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergyInfoProviderList
implements IEnergyInfoProvider {
    private final List<? extends IEnergyInfoProvider> list;

    public EnergyInfoProviderList(List<? extends IEnergyInfoProvider> list) {
        this.list = list;
    }

    @Override
    public IEnergyInfoProvider.EnergyInfo getEnergyInfo() {
        BigInteger capacity = BigInteger.ZERO;
        BigInteger stored = BigInteger.ZERO;
        for (IEnergyInfoProvider iEnergyInfoProvider : this.list) {
            IEnergyInfoProvider.EnergyInfo energyInfo = iEnergyInfoProvider.getEnergyInfo();
            capacity = capacity.add(energyInfo.capacity());
            stored = stored.add(energyInfo.stored());
        }
        return new IEnergyInfoProvider.EnergyInfo(capacity, stored);
    }

    @Override
    public long getInputPerSec() {
        long sum = 0L;
        for (IEnergyInfoProvider iEnergyInfoProvider : this.list) {
            sum += iEnergyInfoProvider.getInputPerSec();
        }
        return sum;
    }

    @Override
    public long getOutputPerSec() {
        long sum = 0L;
        for (IEnergyInfoProvider iEnergyInfoProvider : this.list) {
            sum += iEnergyInfoProvider.getOutputPerSec();
        }
        return sum;
    }

    @Override
    public boolean supportsBigIntEnergyValues() {
        return this.list.size() > 1;
    }
}

