/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ItemRecipeHandler
implements IRecipeHandler<Ingredient> {
    public final IO handlerIO;
    public final CustomItemStackHandler storage;

    public ItemRecipeHandler(IO handlerIO, int slots) {
        this.handlerIO = handlerIO;
        this.storage = new CustomItemStackHandler(slots);
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
        return NotifiableItemStackHandler.handleRecipe(io, recipe, left, simulate, this.handlerIO, this.storage);
    }

    @Override
    @NotNull
    public List<Object> getContents() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            ItemStack stack = this.storage.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ingredients.add(stack);
        }
        return new ArrayList<Object>(ingredients);
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            ItemStack stack = this.storage.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            amount += (long)stack.m_41613_();
        }
        return amount;
    }

    @Override
    public int getSize() {
        return this.storage.getSlots();
    }

    @Override
    public RecipeCapability<Ingredient> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }
}

