/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.virtualregistry;

import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualRegistryMap
implements INBTSerializable<CompoundTag> {
    private final Map<EntryTypes<?>, Map<String, VirtualEntry>> registryMap = new ConcurrentHashMap();

    public VirtualRegistryMap() {
    }

    public VirtualRegistryMap(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Nullable
    public <T extends VirtualEntry> T getEntry(EntryTypes<T> type, String name) {
        return (T)((VirtualEntry)this.registryMap.getOrDefault(type, Collections.emptyMap()).get(name));
    }

    public void addEntry(String name, VirtualEntry entry) {
        this.registryMap.computeIfAbsent(entry.getType(), k -> new ConcurrentHashMap()).put(name, entry);
    }

    public boolean contains(EntryTypes<?> type, String name) {
        return this.registryMap.containsKey(type) && this.registryMap.get(type).containsKey(name);
    }

    public void deleteEntry(EntryTypes<?> type, String name) {
        Map<String, VirtualEntry> entries = this.registryMap.get(type);
        if (entries != null) {
            entries.remove(name);
            if (entries.isEmpty()) {
                this.registryMap.remove(type);
            }
        }
    }

    public void clear() {
        this.registryMap.clear();
    }

    public Set<String> getEntryNames(EntryTypes<?> type) {
        return new HashSet<String>(this.registryMap.getOrDefault(type, Collections.emptyMap()).keySet());
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<EntryTypes<?>, Map<String, VirtualEntry>> entry : this.registryMap.entrySet()) {
            CompoundTag entriesTag = new CompoundTag();
            for (Map.Entry<String, VirtualEntry> subEntry : entry.getValue().entrySet()) {
                entriesTag.m_128365_(subEntry.getKey(), (Tag)subEntry.getValue().serializeNBT());
            }
            tag.m_128365_(entry.getKey().toString(), (Tag)entriesTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String entryTypeString : nbt.m_128431_()) {
            EntryTypes<VirtualEntry> type;
            EntryTypes<VirtualEntry> entryTypes = type = entryTypeString.contains(":") ? EntryTypes.fromLocation(ResourceLocation.m_135820_((String)entryTypeString)) : EntryTypes.fromString(entryTypeString);
            if (type == null) continue;
            CompoundTag virtualEntries = nbt.m_128469_(entryTypeString);
            for (String name : virtualEntries.m_128431_()) {
                CompoundTag entryTag = virtualEntries.m_128469_(name);
                this.addEntry(name, type.createInstance(entryTag));
            }
        }
    }
}

