/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.Node;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public abstract class PipeNet<NodeDataType>
implements ITagSerializable<CompoundTag> {
    protected final LevelPipeNet<NodeDataType, PipeNet<NodeDataType>> worldData;
    private final Map<BlockPos, Node<NodeDataType>> nodeByBlockPos = new HashMap<BlockPos, Node<NodeDataType>>();
    private final Map<BlockPos, Node<NodeDataType>> unmodifiableNodeByBlockPos = Collections.unmodifiableMap(this.nodeByBlockPos);
    private final Object2IntOpenHashMap<ChunkPos> ownedChunks = new Object2IntOpenHashMap();
    private long lastUpdate;
    boolean isValid = false;

    public PipeNet(LevelPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>> Level2) {
        this.worldData = Level2;
    }

    public Set<ChunkPos> getContainedChunks() {
        return Collections.unmodifiableSet(this.ownedChunks.keySet());
    }

    public LevelPipeNet<NodeDataType, PipeNet<NodeDataType>> getWorldData() {
        return this.worldData;
    }

    public ServerLevel getLevel() {
        return this.worldData.getWorld();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void onNodeConnectionsUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    protected void onNodeDataUpdate() {
    }

    public void onPipeConnectionsUpdate() {
    }

    public void onNeighbourUpdate(BlockPos fromPos) {
    }

    public Map<BlockPos, Node<NodeDataType>> getAllNodes() {
        return this.unmodifiableNodeByBlockPos;
    }

    public Node<NodeDataType> getNodeAt(BlockPos blockPos) {
        return this.nodeByBlockPos.get(blockPos);
    }

    public boolean containsNode(BlockPos blockPos) {
        return this.nodeByBlockPos.containsKey(blockPos);
    }

    public boolean isNodeConnectedTo(BlockPos pos, Direction side) {
        Node<NodeDataType> nodeFirst = this.getNodeAt(pos);
        if (nodeFirst == null) {
            return false;
        }
        Node<NodeDataType> nodeSecond = this.getNodeAt(pos.m_121945_(side));
        if (nodeSecond == null) {
            return false;
        }
        return this.canNodesConnect(nodeFirst, side, nodeSecond, this);
    }

    protected void addNodeSilently(BlockPos nodePos, Node<NodeDataType> node) {
        this.nodeByBlockPos.put(nodePos, node);
        this.checkAddedInChunk(nodePos);
    }

    protected void addNode(BlockPos nodePos, Node<NodeDataType> node) {
        this.addNodeSilently(nodePos, node);
        this.onNodeConnectionsUpdate();
        this.worldData.m_77762_();
    }

    protected Node<NodeDataType> removeNodeWithoutRebuilding(BlockPos nodePos) {
        Node<NodeDataType> removedNode = this.nodeByBlockPos.remove(nodePos);
        this.ensureRemovedFromChunk(nodePos);
        this.worldData.m_77762_();
        return removedNode;
    }

    public void removeNode(BlockPos nodePos) {
        if (this.nodeByBlockPos.containsKey(nodePos)) {
            Node<NodeDataType> selfNode = this.removeNodeWithoutRebuilding(nodePos);
            this.rebuildNetworkOnNodeRemoval(nodePos, selfNode);
        }
    }

    protected void checkAddedInChunk(BlockPos nodePos) {
        ChunkPos chunkPos = new ChunkPos(nodePos);
        int oldValue = this.ownedChunks.addTo((Object)chunkPos, 1);
        if (oldValue == 0 && this.isValid()) {
            this.worldData.addPipeNetToChunk(chunkPos, this);
        }
    }

    protected void ensureRemovedFromChunk(BlockPos nodePos) {
        int oldValue;
        ChunkPos chunkPos = new ChunkPos(nodePos);
        int n = oldValue = this.ownedChunks.containsKey((Object)chunkPos) ? this.ownedChunks.addTo((Object)chunkPos, -1) : 0;
        if (oldValue == 1) {
            this.ownedChunks.removeInt((Object)chunkPos);
            if (this.isValid()) {
                this.worldData.removePipeNetFromChunk(chunkPos, this);
            }
        }
    }

    public void updateBlockedConnections(BlockPos nodePos, Direction facing, boolean isBlocked) {
        Node<NodeDataType> neighbourNode;
        if (!this.containsNode(nodePos)) {
            return;
        }
        Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
        if (selfNode.isBlocked(facing) == isBlocked) {
            return;
        }
        this.setBlocked(selfNode, facing, isBlocked);
        BlockPos offsetPos = nodePos.m_121945_(facing);
        PipeNet<NodeDataType> pipeNetAtOffset = this.worldData.getNetFromPos(offsetPos);
        if (pipeNetAtOffset == null) {
            return;
        }
        if (pipeNetAtOffset == this) {
            if (isBlocked) {
                this.setBlocked(selfNode, facing, false);
                if (this.canNodesConnect(selfNode, facing, this.getNodeAt(offsetPos), this)) {
                    this.setBlocked(selfNode, facing, true);
                    HashMap<BlockPos, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(nodePos);
                    if (!this.getAllNodes().equals(thisENet)) {
                        PipeNet<NodeDataType> newPipeNet = this.worldData.createNetInstance();
                        thisENet.keySet().forEach(this::removeNodeWithoutRebuilding);
                        newPipeNet.transferNodeData(thisENet, this);
                        this.worldData.addPipeNet(newPipeNet);
                    }
                }
            }
        } else if (!isBlocked && this.canNodesConnect(selfNode, facing, neighbourNode = pipeNetAtOffset.getNodeAt(offsetPos), pipeNetAtOffset) && pipeNetAtOffset.canNodesConnect(neighbourNode, facing.m_122424_(), selfNode, this)) {
            this.uniteNetworks(pipeNetAtOffset);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.m_77762_();
    }

    public void updateNodeData(BlockPos nodePos, NodeDataType data) {
        if (this.containsNode(nodePos)) {
            Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
            selfNode.data = data;
            this.onNodeDataUpdate();
            this.worldData.m_77762_();
        }
    }

    public void updateMark(BlockPos nodePos, int newMark) {
        if (!this.containsNode(nodePos)) {
            return;
        }
        HashMap<BlockPos, Node<NodeDataType>> selfConnectedBlocks = null;
        Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
        int oldMark = selfNode.mark;
        selfNode.mark = newMark;
        for (Direction facing : GTUtil.DIRECTIONS) {
            HashMap<BlockPos, Node<NodeDataType>> offsetConnectedBlocks;
            Node<NodeDataType> secondNode;
            BlockPos offsetPos = nodePos.m_121945_(facing);
            PipeNet<NodeDataType> otherPipeNet = this.worldData.getNetFromPos(offsetPos);
            Node<NodeDataType> node = secondNode = otherPipeNet == null ? null : otherPipeNet.getNodeAt(offsetPos);
            if (secondNode == null || !this.areNodeBlockedConnectionsCompatible(selfNode, facing, secondNode) || !this.areNodesCustomContactable(selfNode.data, secondNode.data, otherPipeNet) || this.areMarksCompatible(oldMark, secondNode.mark) == this.areMarksCompatible(newMark, secondNode.mark)) continue;
            if (this.areMarksCompatible(newMark, secondNode.mark)) {
                if (otherPipeNet == this) continue;
                this.uniteNetworks(otherPipeNet);
                continue;
            }
            if (otherPipeNet != this) continue;
            if (selfConnectedBlocks == null) {
                selfConnectedBlocks = this.findAllConnectedBlocks(nodePos);
            }
            if (this.getAllNodes().equals(selfConnectedBlocks) || (offsetConnectedBlocks = this.findAllConnectedBlocks(offsetPos)).equals(selfConnectedBlocks)) continue;
            offsetConnectedBlocks.keySet().forEach(this::removeNodeWithoutRebuilding);
            PipeNet<NodeDataType> offsetPipeNet = this.worldData.createNetInstance();
            offsetPipeNet.transferNodeData(offsetConnectedBlocks, this);
            this.worldData.addPipeNet(offsetPipeNet);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.m_77762_();
    }

    private void setBlocked(Node<NodeDataType> selfNode, Direction facing, boolean isBlocked) {
        selfNode.openConnections = !isBlocked ? (selfNode.openConnections |= 1 << facing.ordinal()) : (selfNode.openConnections &= ~(1 << facing.ordinal()));
    }

    public boolean markNodeAsActive(BlockPos nodePos, boolean isActive) {
        if (this.containsNode(nodePos) && this.getNodeAt((BlockPos)nodePos).isActive != isActive) {
            this.getNodeAt((BlockPos)nodePos).isActive = isActive;
            this.worldData.m_77762_();
            this.onNodeConnectionsUpdate();
            return true;
        }
        return false;
    }

    protected final void uniteNetworks(PipeNet<NodeDataType> unitedPipeNet) {
        HashMap<BlockPos, Node<NodeDataType>> allNodes = new HashMap<BlockPos, Node<NodeDataType>>(unitedPipeNet.getAllNodes());
        this.worldData.removePipeNet(unitedPipeNet);
        allNodes.keySet().forEach(unitedPipeNet::removeNodeWithoutRebuilding);
        this.transferNodeData(allNodes, unitedPipeNet);
    }

    private boolean areNodeBlockedConnectionsCompatible(Node<NodeDataType> first, Direction firstFacing, Node<NodeDataType> second) {
        return !first.isBlocked(firstFacing) && !second.isBlocked(firstFacing.m_122424_());
    }

    private boolean areMarksCompatible(int mark1, int mark2) {
        return mark1 == mark2 || mark1 == 0 || mark2 == 0;
    }

    protected final boolean canNodesConnect(Node<NodeDataType> first, Direction firstFacing, Node<NodeDataType> second, PipeNet<NodeDataType> secondPipeNet) {
        return this.areNodeBlockedConnectionsCompatible(first, firstFacing, second) && this.areMarksCompatible(first.mark, second.mark) && this.areNodesCustomContactable(first.data, second.data, secondPipeNet);
    }

    protected HashMap<BlockPos, Node<NodeDataType>> findAllConnectedBlocks(BlockPos startPos) {
        HashMap<BlockPos, Node<NodeDataType>> observedSet = new HashMap<BlockPos, Node<NodeDataType>>();
        observedSet.put(startPos, this.getNodeAt(startPos));
        Node<NodeDataType> firstNode = this.getNodeAt(startPos);
        BlockPos.MutableBlockPos currentPos = startPos.m_122032_();
        ArrayDeque<Direction> moveStack = new ArrayDeque<Direction>();
        while (true) {
            for (Direction facing : GTUtil.DIRECTIONS) {
                currentPos.m_122173_(facing);
                Node<NodeDataType> secondNode = this.getNodeAt((BlockPos)currentPos);
                if (secondNode != null && this.canNodesConnect(firstNode, facing, secondNode, this) && !observedSet.containsKey(currentPos)) {
                    observedSet.put(currentPos.m_7949_(), this.getNodeAt((BlockPos)currentPos));
                    firstNode = secondNode;
                    moveStack.push(facing.m_122424_());
                    continue;
                }
                currentPos.m_122173_(facing.m_122424_());
            }
            if (moveStack.isEmpty()) break;
            currentPos.m_122173_((Direction)moveStack.pop());
            firstNode = this.getNodeAt((BlockPos)currentPos);
        }
        return observedSet;
    }

    protected void rebuildNetworkOnNodeRemoval(BlockPos nodePos, Node<NodeDataType> selfNode) {
        BlockPos offsetPos;
        int amountOfConnectedSides = 0;
        for (Direction facing : GTUtil.DIRECTIONS) {
            offsetPos = nodePos.m_121945_(facing);
            if (!this.containsNode(offsetPos)) continue;
            ++amountOfConnectedSides;
        }
        if (amountOfConnectedSides >= 2) {
            for (Direction facing : GTUtil.DIRECTIONS) {
                offsetPos = nodePos.m_121945_(facing);
                Node<NodeDataType> secondNode = this.getNodeAt(offsetPos);
                if (secondNode == null || !this.canNodesConnect(selfNode, facing, secondNode, this)) continue;
                HashMap<BlockPos, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(offsetPos);
                if (this.getAllNodes().equals(thisENet)) break;
                PipeNet<NodeDataType> energyNet = this.worldData.createNetInstance();
                thisENet.keySet().forEach(this::removeNodeWithoutRebuilding);
                energyNet.transferNodeData(thisENet, this);
                this.worldData.addPipeNet(energyNet);
            }
        }
        if (this.getAllNodes().isEmpty()) {
            this.worldData.removePipeNet(this);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.m_77762_();
    }

    protected boolean areNodesCustomContactable(NodeDataType first, NodeDataType second, PipeNet<NodeDataType> secondNodePipeNet) {
        return true;
    }

    protected boolean canAttachNode(NodeDataType nodeData) {
        return true;
    }

    protected void transferNodeData(Map<BlockPos, Node<NodeDataType>> transferredNodes, PipeNet<NodeDataType> parentNet) {
        transferredNodes.forEach(this::addNodeSilently);
        this.onNodeConnectionsUpdate();
        this.worldData.m_77762_();
    }

    protected abstract void writeNodeData(NodeDataType var1, CompoundTag var2);

    protected abstract NodeDataType readNodeData(CompoundTag var1);

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Nodes", (Tag)this.serializeAllNodeList(this.nodeByBlockPos));
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.nodeByBlockPos.clear();
        this.ownedChunks.clear();
        this.deserializeAllNodeList(nbt.m_128469_("Nodes"));
    }

    protected void deserializeAllNodeList(CompoundTag compound) {
        int i;
        ListTag allNodesList = compound.m_128437_("NodeIndexes", 10);
        ListTag wirePropertiesList = compound.m_128437_("WireProperties", 10);
        Int2ObjectOpenHashMap readProperties = new Int2ObjectOpenHashMap();
        for (i = 0; i < wirePropertiesList.size(); ++i) {
            CompoundTag propertiesTag = wirePropertiesList.m_128728_(i);
            int wirePropertiesIndex = propertiesTag.m_128451_("index");
            NodeDataType nodeData = this.readNodeData(propertiesTag);
            readProperties.put(wirePropertiesIndex, nodeData);
        }
        for (i = 0; i < allNodesList.size(); ++i) {
            CompoundTag nodeTag = allNodesList.m_128728_(i);
            int x = nodeTag.m_128451_("x");
            int y = nodeTag.m_128451_("y");
            int z = nodeTag.m_128451_("z");
            int wirePropertiesIndex = nodeTag.m_128451_("index");
            BlockPos blockPos = new BlockPos(x, y, z);
            Object nodeData = readProperties.get(wirePropertiesIndex);
            int openConnections = nodeTag.m_128451_("open");
            int mark = nodeTag.m_128451_("mark");
            boolean isNodeActive = nodeTag.m_128471_("active");
            this.addNodeSilently(blockPos, new Node<Object>(nodeData, openConnections, mark, isNodeActive));
        }
    }

    protected CompoundTag serializeAllNodeList(Map<BlockPos, Node<NodeDataType>> allNodes) {
        CompoundTag compound = new CompoundTag();
        ListTag allNodesList = new ListTag();
        ListTag wirePropertiesList = new ListTag();
        Object2IntOpenHashMap alreadyWritten = new Object2IntOpenHashMap();
        int currentIndex = 0;
        for (Map.Entry<BlockPos, Node<NodeDataType>> entry : allNodes.entrySet()) {
            BlockPos nodePos = entry.getKey();
            Node<NodeDataType> node = entry.getValue();
            CompoundTag nodeTag = new CompoundTag();
            nodeTag.m_128405_("x", nodePos.m_123341_());
            nodeTag.m_128405_("y", nodePos.m_123342_());
            nodeTag.m_128405_("z", nodePos.m_123343_());
            int wirePropertiesIndex = alreadyWritten.getOrDefault(node.data, -1);
            if (wirePropertiesIndex == -1) {
                wirePropertiesIndex = currentIndex++;
                alreadyWritten.put(node.data, wirePropertiesIndex);
            }
            nodeTag.m_128405_("index", wirePropertiesIndex);
            if (node.mark != 0) {
                nodeTag.m_128405_("mark", node.mark);
            }
            if (node.openConnections > 0) {
                nodeTag.m_128405_("open", node.openConnections);
            }
            if (node.isActive) {
                nodeTag.m_128379_("active", true);
            }
            allNodesList.add((Object)nodeTag);
        }
        for (Object nodeData : alreadyWritten.keySet()) {
            int wirePropertiesIndex = alreadyWritten.getInt(nodeData);
            CompoundTag propertiesTag = new CompoundTag();
            propertiesTag.m_128405_("index", wirePropertiesIndex);
            this.writeNodeData(nodeData, propertiesTag);
            wirePropertiesList.add((Object)propertiesTag);
        }
        compound.m_128365_("NodeIndexes", (Tag)allNodesList);
        compound.m_128365_("WireProperties", (Tag)wirePropertiesList);
        return compound;
    }
}

